<?php
defined('ABSPATH') or exit;
$card_class = 'chk-portfolio-card pos-relative z-1 overflow-hidden w-full h-full flex transition-all';
?>
<article id="post-<?php the_ID(); ?>" <?php post_class($card_class); ?>>
    <?php if (has_post_thumbnail()): ?>
        <div class="chk-portfolio-card__thumbnail pos-relative overflow-hidden text-center z-1 lh-0">
            <?php the_post_thumbnail('chk_portfolio', [
                'class' => 'w-full h-auto transition-all',
                'loading' => 'lazy',
                'alt' => '' . get_the_title() . ''
            ]); ?>
            <span class="chk-portfolio-card__overlay">
                <a href="<?php echo get_the_permalink(); ?>" class="chk-portfolio-card__readmore"><i class="ti-plus d-inline-block"></i></a>
            </span>
        </div>
    <?php endif; ?>

    <?php
    $tag_title = chakavak_get_option('portfolio_card_title_tag', 'h2');
    $title_class = 'chk-portfolio-card__title px-8 py-4';
    if (chakavak_get_option('portfolio_title_inline')) {
        $title_class .= ' chk-title-inline';
    }
    echo '<' . $tag_title . ' class="' . $title_class . '">';
    echo '<a href="' . get_the_permalink() . '" class="transition-all text-current">';
    echo get_the_title();
    echo '</a>';
    echo '</' . $tag_title . '>';
    ?>

</article>