<?php
if (!defined('ABSPATH')) {
    exit;
}
?>
<div id="chk-header__mobile" class="chk-header__mobile pos-relative">
    <div class="container">
        <div class="chk-header__mobile-wrap py-8">
            <div class="d-flex flex-wrap items-center w-full justify-between">
                <div class="chk-header__logo d-inline-flex items-center justify-center">
                    <a href="<?php echo esc_url(home_url('/')); ?>" class="chk-header__logo-image d-block lh-0">
                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/logo.png" alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>">
                    </a>
                </div>
                <div class="chk-mmenu__toggle d-inline-flex items-center justify-center pos-relative cursor-pointer z-1 chk-header-item" id="chk-mmobile-toggle">
                    <button aria-label="menu-toggle"></button>
                </div>
            </div>
        </div>
        <div class="chk-mobile__default_menu-wrap">
            <nav class="chk-mobile__default-nav collapse">
                <?php if (has_nav_menu('mobile-menu')) {
                    wp_nav_menu([
                        'theme_location' => 'mobile-menu',
                        'container' => '',
                        'menu_id' => false,
                        'menu_class' => 'chk-mobile__default-menu m-0 p-0',
                        'depth' => 3,
                        'fallback_cb' => 'wp_page_menu',
                    ]);
                } else { ?>
                    <p>
                        <a href="<?php echo esc_url(admin_url('nav-menus.php')); ?>" target="_blank">
                            <?php echo esc_html__('Please create a menu for this section.', 'chakavak'); ?>
                        </a>
                    </p>
                <?php } ?>
            </nav>
        </div>
    </div>
</div>