<?php
defined('ABSPATH') or exit;
?>
<!-- Main header start -->
<div class="chk-header__desktop pos-relative z-20">
    <div class="chk-header__wrap">
        <div class="container">
            <div class="chk-header__inner d-flex justify-between items-center py-8">
                <div id="chk-header__logo" class="chk-header__logo chk-header-item">
                    <a href="<?php echo esc_url(home_url('/')); ?>" class="chk-header__logo-image d-block lh-0">
                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/logo.png" alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>">
                    </a>
                </div>
                <nav id="chk-navbar" class="chk-navbar chk-header-item">
                    <?php if (has_nav_menu('primary-menu')) {
                        wp_nav_menu([
                            'theme_location' => 'primary-menu',
                            'container' => '',
                            'menu_id' => false,
                            'menu_class' => 'chk-navbar__menu d-flex items-center pos-relative p-0 h-full',
                            'depth' => 3,
                            'fallback_cb' => 'wp_page_menu',
                        ]);
                    } else { ?>
                        <p>
                            <a href="<?php echo esc_url(admin_url('nav-menus.php')); ?>" target="_blank">
                                <?php echo esc_html__('Please create a menu for this section.', 'chakavak'); ?>
                            </a>
                        </p>
                    <?php } ?>
                </nav><!-- #site-navigation -->
            </div>
        </div>
    </div>
</div>
<!-- Main header close -->
