<?php
defined('ABSPATH') or exit;
$format = get_post_format();
$post_class = 'chk-post-card';
$thumb_size = '';
$meta = chakavak_get_option('post_card_entry_meta');
$byline = sprintf(
    esc_html_x('%s', 'post author', 'chakavak'),
    '<i class="ti-user"></i>' . esc_html(get_the_author())
);
if (chakavak_get_option('posts_style') === 'grid' || is_search()) {
    $post_class .= ' chk-post-card__grid';
    $thumb_size = 'chk_blog';
} elseif (chakavak_get_option('posts_style') === 'list') {
    $post_class .= ' chk-post-card__list mb-20';
    $thumb_size = 'chk_blog';
} else {
    $post_class .= ' chk-post-card__classic mb-20';
    $thumb_size = 'full';
}

?>
<article id="post-<?php the_ID(); ?>" <?php post_class($post_class); ?>>
    <?php if (has_post_thumbnail(get_the_ID())) : ?>
        <div class="chk-post-card__thumbnail pos-relative lh-0 z-1 overflow-hidden chk-effect-zoom">
            <?php if (in_array('date', $meta)) { ?>
                <div class="chk-post-card__date if-center pos-absolute z-1 flex-col text-center">
                    <?php echo sprintf('%s', get_the_date('d')); ?>
                    <span>
                        <?php echo sprintf('%s', get_the_date('M')); ?>
                    </span>
                </div>
            <?php } ?>
            <a href="<?php echo get_the_permalink(); ?>" class="chk-post-card__image lh-0 d-block">
                <?php
                the_post_thumbnail($thumb_size, array(
                    'class' => 'w-full h-auto transition-all',
                    'loading' => 'lazy',
                    'alt' => get_the_title()
                ));
                ?>
            </a>
        </div>
    <?php endif; ?>

    <div class="chk-post-card__content">
        <div class="chk-post-card__cat d-inline-flex items-center">
            <?php
            echo '<i class="ti-folder"></i>';
            $chk_post_all_cats = get_the_category();
            $chk_post_cat_list = array();
            if ($chk_post_all_cats) {
                foreach ($chk_post_all_cats as $category) {
                    $chk_post_cat_list[] = '<a class="text-current" href="' . esc_url(get_category_link($category->term_id)) . '" title="' . esc_attr(sprintf(esc_html__('%s', 'chakavak'), $category->name)) . '" >' . esc_html($category->cat_name) . '</a>';
                }
                echo implode(' , ', $chk_post_cat_list);
            } ?>
        </div>

        <?php
        $tag_title = chakavak_get_option('post_card_title_tag', 'h2');
        $title_class = 'chk-post-card__title py-4';
        if (chakavak_get_option('post_card_title_inline')) {
            $title_class .= ' chk-title-inline';
        }
        echo '<' . $tag_title . ' class="' . $title_class . '">';
        echo '<a href="' . get_the_permalink() . '" class="transition-all text-current">';
        echo get_the_title();
        echo '</a>';
        echo '</' . $tag_title . '>';
        ?>

        <?php if (chakavak_get_option('post_card_show_excerpt')) : ?>
            <div class="chk-post-card__excerpt">
                <?php if (chakavak_get_option('post_card_excerpt_length') != 0) {
                    $get_the_excerpt = get_the_excerpt();
                    echo chakavak_short_text($get_the_excerpt, intval(chakavak_get_option('post_card_excerpt_length'))) . ' ...';
                } ?>
            </div>
        <?php endif; ?>

        <div class="mt-auto">
            <div class="chk-post-card__bottom d-flex items-center justify-between">
                <ul class="chk-post-card__meta list-none p-0 d-flex items-center flex-wrap">
                    <?php
                    if (in_array('author', $meta)) {
                        echo '<li class="chk-post-card__meta-author d-inline-flex items-center">' . $byline . '</li>';
                    }
                    if (in_array('comm', $meta)) {
                        echo '<li class="chk-post-card__comment d-inline-flex items-center"><i class="ti-comments"></i>' . get_comments_number() . '</li>';
                    }
                    ?>
                </ul>

                <div class="chk-post-card__readmore">
                    <?php
                    $icon_readmore = is_rtl() ? '<i class="ti-arrow-large-left"></i>' : '<i class="ti-arrow-large-right"></i>';
                    ?>
                    <a href="<?php echo esc_url(get_the_permalink()); ?>" class="if-center transition-all">
                        <?php echo $icon_readmore; ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</article>