<?php
/**
 * Template part for displaying a message that posts cannot be found
 * @package chakavak
 */

?>

<section class="chk-no-results">
    <div class="chk-no-results__content">
        <?php
        if (is_home() && current_user_can('publish_posts')) :
            printf(
                '<p>' . wp_kses(
                /* translators: 1: link to WP admin new post page. */
                    __('Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'chakavak'),
                    array(
                        'a' => array(
                            'href' => array(),
                        ),
                    )
                ) . '</p>',
                esc_url(admin_url('post-new.php'))
            );
        elseif (is_search()) :
            ?>
            <p>
                <?php esc_html_e('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'chakavak'); ?>
            </p>
        <?php else : ?>

            <p>
                <?php esc_html_e('It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'chakavak'); ?>
            </p>
        <?php
        endif;
        ?>
    </div><!-- .page-content -->
</section><!-- .no-results -->
