<?php
defined('ABSPATH') or exit;
$faq_schema = $taxonomy_meta['faq_schema_switch'];
$faq_items = $taxonomy_meta['faq_items'];

if ($taxonomy_meta['faq_switch']) {
    echo '<div class="chk-faqs__wrap">';
    echo '<div class="chk-faqs__title"><i class="ti-faq-circle d-inline-block"></i><span>' . esc_html__('Frequently Asked Questions', 'chakavak') . '</span></div>';
    if ($faq_items) {
        $count = 1;
        echo '<div class="chk-faq-items">';
        foreach ($faq_items as $faq) {
            echo '<div class="chk-faq-item pos-relative w-full h-auto overflow-hidden">';
            echo '<div class="chk-faq-item__head acc-title pos-relative d-flex items-center justify-between">';
            echo '<strong class="faq-item-question cursor-pointer pos-relative overflow-hidden">';
            echo '<em>' . $count . '.</em>' . wp_kses_post($faq['question']) . '</strong><span class="chk-toggle-icon lh-0"><i class="ti-plus"></i></span>';
            echo '</div>';
            echo '<div class="chk-faq-item__answer acc-content">';
            echo '<div class="pos-relative w-full chk-classic-editor">' . wp_kses_post($faq['answer']) . '</div>';
            echo '</div>';
            echo '</div>';
            $count++;
        }
        echo '</div>';
    }
    echo '</div>';
}


if ($faq_schema && $faq_items) {
    $post_date = get_the_date('c');
    $json = [
        '@context' => 'https://schema.org',
        '@type' => 'FAQPage',
        'mainEntity' => [],
        'datePublished' => $post_date,
    ];

    foreach ($faq_items as $index => $item) {
        $json['mainEntity'][] = [
            '@type' => 'Question',
            'name' => wp_strip_all_tags($item['question']),
            'acceptedAnswer' => [
                '@type' => 'Answer',
                'text' => chakavak_clean_schema_content($item['answer']),
                'datePublished' => $post_date,
            ],
        ];
    }
    ?>
    <script type="application/ld+json">
        <?php echo wp_json_encode($json, JSON_UNESCAPED_UNICODE); ?>


    </script>
<?php } ?>