<?php

/**
 * @package Chakavak
 */
get_header();
$term_id = get_queried_object_id();
$taxonomy_meta = get_term_meta($term_id, 'chakavak_taxonomy_meta', true);
?>
<div class="py-32">
    <div class="container">
        <div class="d-flex flex-wrap">
            <div id="chk-archive-portfolio" class="chk-archive-portfolio <?php chakavak_content_columns(); ?>">
                <main id="main" class="site-main">
                    <?php if (chakavak_get_option('archive_portfolio_desc') == 'top-desc') {
                        if (!empty(get_the_archive_description()) || !empty($taxonomy_meta['tax_desc']) || $taxonomy_meta['faq_items']) {
                    ?>
                            <div class="chk-archive-desc top-desc">
                                <?php include locate_template('template-parts/category/description.php'); ?>
                                <?php include locate_template('template-parts/category/faq.php'); ?>
                            </div>
                    <?php }
                    } ?>

                    <?php if (have_posts()) : ?>
                        <div class="<?php chakavak_archive_portfolio_columns_class();
                                    chakavak_portfolio_style() ?>">
                            <?php while (have_posts()) {
                                the_post(); ?>
                                <div class="col-xs">
                                    <?php get_template_part('template-parts/content', get_post_type()); ?>
                                </div>
                            <?php } ?>
                        </div>
                    <?php else :
                        get_template_part('template-parts/content', 'none');
                    endif; ?>

                    <?php chakavak_posts_navigation('standard'); ?>

                    <?php if (chakavak_get_option('archive_portfolio_desc') == 'bottom-desc') { ?>
                        <?php if (!empty(get_the_archive_description()) || !empty($taxonomy_meta['tax_desc']) || $taxonomy_meta['faq_items']) { ?>
                            <div class="chk-archive-desc bottom-desc">
                                <?php include locate_template('template-parts/category/description.php'); ?>
                                <?php include locate_template('template-parts/category/faq.php'); ?>
                            </div>
                    <?php };
                    } ?>

                </main>
            </div>

            <?php get_sidebar('portfolio'); ?>
        </div>
    </div>
</div>

<?php get_footer(); ?>