<?php
/**
 * The template for displaying all pages
 * @package Chakavak
 */
get_header();
$padding_content = chakavak_get_meta('chakavak_page_meta', 'page_content_padding', 'padding-default');
$content_width = chakavak_get_meta('chakavak_page_meta', 'page_content_width', 'container');
?>
    <div class="chk-single-page__area <?php echo $padding_content; ?>">
        <?php if ($content_width == 'container') {
            echo '<div class="container">';
        } ?>

        <?php if (chakavak_get_layout() == 'full-content') :
            while (have_posts()) : the_post();
                the_content();
            endwhile;
        else : ?>
            <div class="d-flex flex-wrap">
                <div id="single-page-primary" class="chk-single-page__primary <?php chakavak_content_columns(); ?>">
                    <?php do_action('chakavak_before_single_page'); ?>
                    <main id="single-page-main" class="chk-single-page__main">
                        <?php
                        while (have_posts()) :
                            the_post();
                            get_template_part('template-parts/content', 'page');
                            if (comments_open() || get_comments_number()) :
                                comments_template();
                            endif;
                        endwhile;
                        ?>
                    </main><!-- #main -->
                    <?php do_action('chakavak_after_single_page'); ?>
                </div><!-- #primary -->

                <?php get_sidebar(); ?>
            </div>
        <?php
        endif; ?>

        <?php if ($content_width == 'container') {
            echo '</div>';
        } ?>

    </div>
<?php get_footer();