<?php

class Chakavak_Portfolio_Categories_Widget extends WP_Widget
{

    public function __construct()
    {
        parent::__construct(
            'chk_portfolio_categories_widget', // Base ID
            esc_html__('Chakavak - Categories Portfolio', 'chakavak'), // Name
            array(
                'description' => esc_html__('Portfolio Categories Display Widget', 'chakavak'),
                'classname' => 'chk-widget-portfolio-cat'
            )
        );
    }

    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        $show_count = isset($instance['show_count']) ? $instance['show_count'] : false;
        $hide_empty = isset($instance['hide_empty']) ? !$instance['hide_empty'] : true;

        echo $args['before_widget'];

        if (!empty($title)) {
            echo $args['before_title'] . $title . $args['after_title'];
        }

        $categories = get_terms(array(
            'taxonomy' => 'portfolio_cat',
            'hide_empty' => $hide_empty
        ));

        if (!empty($categories) && !is_wp_error($categories)) {
            echo '<ul class="chk-portfolio-categories">';

            foreach ($categories as $category) {
                echo '<li class="cat-item cat-item-' . $category->term_id . '">';
                echo '<a href="' . get_term_link($category) . '">' . $category->name;
                echo '</a>';
                if ($show_count) {
                    echo ' <span class="posts-count">(' . $category->count . ')</span>';
                }
                echo '</li>';
            }

            echo '</ul>';
        }

        echo $args['after_widget'];
    }

    // Widget Backend Form
    public function form($instance)
    {
        $title = isset($instance['title']) ? $instance['title'] : __('Portfolio Categories', 'chakavak');
        $show_count = isset($instance['show_count']) ? $instance['show_count'] : false;
        $hide_empty = isset($instance['hide_empty']) ? $instance['hide_empty'] : false;
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php echo esc_html__('Title:', 'chakavak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                   name="<?php echo $this->get_field_name('title'); ?>" type="text"
                   value="<?php echo esc_attr($title); ?>">
        </p>

        <p>
            <input class="checkbox" type="checkbox"
                <?php checked($show_count); ?>
                   id="<?php echo $this->get_field_id('show_count'); ?>"
                   name="<?php echo $this->get_field_name('show_count'); ?>">
            <label for="<?php echo $this->get_field_id('show_count'); ?>">
                <?php echo esc_html__('Show count posts', 'chakavak'); ?>
            </label>
        </p>

        <p>
            <input class="checkbox" type="checkbox"
                <?php checked($hide_empty); ?>
                   id="<?php echo $this->get_field_id('hide_empty'); ?>"
                   name="<?php echo $this->get_field_name('hide_empty'); ?>">
            <label for="<?php echo $this->get_field_id('hide_empty'); ?>">
                <?php echo esc_html__('Show empty category', 'chakavak'); ?>
            </label>
        </p>
        <?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['show_count'] = isset($new_instance['show_count']) ? 1 : 0;
        $instance['hide_empty'] = isset($new_instance['hide_empty']) ? 1 : 0;

        return $instance;
    }
}

function chakavak_register_portfolio_categories_widget()
{
    register_widget('Chakavak_Portfolio_Categories_Widget');
}

add_action('widgets_init', 'chakavak_register_portfolio_categories_widget');