<?php

class Chakavak_Latest_Posts_Widget extends WP_Widget
{
    public function __construct()
    {
        parent::__construct(
            'chk_latest_posts_widget',
            esc_html__('Chakavak - Latest Posts', 'chakavak'), // Name
            array(
                'description' => esc_html__('Show the latest added posts', 'chakavak'),
                'classname' => 'chk-widget-posts-latest chk-latest-widget'
            ),
        );
    }

    // Widget Frontend Display
    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        $show_date = isset($instance['show_date']) ? $instance['show_date'] : false;
        $number_of_posts = isset($instance['number_of_posts']) ? $instance['number_of_posts'] : 5;

        echo $args['before_widget'];

        if (!empty($title)) {
            echo $args['before_title'] . $title . $args['after_title'];
        }

        $query_args = array(
            'post_type' => 'post',
            'posts_per_page' => $number_of_posts,
            'orderby' => 'date',
            'order' => 'DESC'
        );

        $query = new WP_Query($query_args);

        if ($query->have_posts()) {
            echo '<ul class="chk-latest__items">';

            while ($query->have_posts()) {
                $query->the_post();

                echo '<li class="chk-latest__item pos-relative">';
                echo '<a href="' . get_permalink() . '" class="chk-latest__overlay d-inline-block lh-0 overflow-hidden"></a>';

                // Thumbnail with link
                if (has_post_thumbnail()) {
                    echo get_the_post_thumbnail(null, 'portfolio', array('class' => 'chk-latest__image'));
                }

                // Title with link
                echo '<div class="chk-latest__item-content">';
                echo '<h4 class="chk-latest__title">' . get_the_title() . '</h4>';

                // date
                if ($show_date) {
                    echo '<span class="chk-latest__date d-inline-flex items-center">';
                    echo '<i class="ti-calendar d-inline-block"></i>';
                    echo get_the_date('', $query->ID);
                    echo '</span>';
                }
                echo '</div>';
                echo '</li>';
            }
            echo '</ul>';
            wp_reset_postdata();
        }

        echo $args['after_widget'];
    }

    public function form($instance)
    {
        $title = isset($instance['title']) ? $instance['title'] : __('Latest Posts', 'chakavak');
        $show_date = isset($instance['show_date']) ? $instance['show_date'] : false;
        $number_of_posts = isset($instance['number_of_posts']) ? $instance['number_of_posts'] : 5;
?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php echo esc_html__('Title:', 'chakavak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                name="<?php echo $this->get_field_name('title'); ?>" type="text"
                value="<?php echo esc_attr($title); ?>">
        </p>

        <p>
            <input class="checkbox" type="checkbox"
                <?php checked($show_date); ?>
                id="<?php echo $this->get_field_id('show_date'); ?>"
                name="<?php echo $this->get_field_name('show_date'); ?>">
            <label for="<?php echo $this->get_field_id('show_date'); ?>">
                <?php echo esc_html__('Show date', 'chakavak'); ?>
            </label>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('number_of_posts'); ?>"><?php echo esc_html__('Post per page:', 'chakavak'); ?></label>
            <input class="tiny-text" id="<?php echo $this->get_field_id('number_of_posts'); ?>"
                name="<?php echo $this->get_field_name('number_of_posts'); ?>" type="number"
                step="1" min="1" value="<?php echo $number_of_posts; ?>" size="3">
        </p>
<?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['show_date'] = isset($new_instance['show_date']) ? 1 : 0;
        $instance['number_of_posts'] = (int)$new_instance['number_of_posts'];

        return $instance;
    }
}

function chakavak_register_latest_posts_widget()
{
    register_widget('Chakavak_Latest_Posts_Widget');
}

add_action('widgets_init', 'chakavak_register_latest_posts_widget');
