<?php

class Chakavak_Contact_Widget extends WP_Widget
{
    public function __construct()
    {
        parent::__construct(
            'chk_contact_widget',
            esc_html__('Chakavak - Contact us', 'chakavak'), // Name
            array(
                'description' => esc_html__('widget contact us', 'chakavak'),
                'classname' => 'chk-widget-contact'
            ),
        );
    }

    // Widget Frontend Display
    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        $address = !empty($instance['address']) ? $instance['address'] : '';
        $email = !empty($instance['email']) ? $instance['email'] : '';
        $phone_1 = !empty($instance['phone_1']) ? $instance['phone_1'] : '';
        $phone_2 = !empty($instance['phone_2']) ? $instance['phone_2'] : '';
        $fax = !empty($instance['fax']) ? $instance['fax'] : '';
        $address = !empty($instance['address']) ? $instance['address'] : '';

        echo $args['before_widget'];

        if (!empty($title)) {
            echo $args['before_title'] . $title . $args['after_title'];
        }
        ?>
        <ul class="chk-widget-contact__items">
            <?php if ($phone_1) : ?>
                <li class="chk-widget-contact__item phone">
                    <i class="ti-phone"></i>
                    <a href="tel:<?php echo esc_html($phone_1); ?>"><?php echo esc_html($phone_1); ?></a>
                </li>
            <?php endif; ?>

            <?php if ($phone_2) : ?>
                <li class="chk-widget-contact__item mobile">
                    <i class="ti-phone"></i>
                    <a href="tel:<?php echo esc_html($phone_2); ?>"><?php echo esc_html($phone_2); ?></a>
                </li>
            <?php endif; ?>

            <?php if ($fax) : ?>
                <li class="chk-widget-contact__item fax">
                    <i class="ti-fax"></i>
                    <span><?php echo esc_html($fax); ?></span>
                </li>
            <?php endif; ?>

            <?php if ($email) : ?>
                <li class="chk-widget-contact__item email">
                    <i class="ti-email"></i>
                    <a href="mailto:<?php echo esc_html($email); ?>"><?php echo esc_html($email); ?></a>
                </li>
            <?php endif; ?>

            <?php if ($address) : ?>
                <li class="chk-widget-contact__item address">
                    <i class="ti-location"></i>
                    <span><?php echo esc_html($address); ?></span>
                </li>
            <?php endif; ?>

        </ul>
        <?php
        echo $args['after_widget'];
    }

    public function form($instance)
    {
        $title = isset($instance['title']) ? $instance['title'] : __('Contact us', 'chakavak');
        $address = !empty($instance['address']) ? $instance['address'] : '';
        $email = !empty($instance['email']) ? $instance['email'] : '';
        $phone_1 = !empty($instance['phone_1']) ? $instance['phone_1'] : '';
        $phone_2 = !empty($instance['phone_2']) ? $instance['phone_2'] : '';
        $fax = !empty($instance['fax']) ? $instance['fax'] : '';
        $address = !empty($instance['address']) ? $instance['address'] : '';
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php echo esc_html__('Title:', 'chakavak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                   name="<?php echo $this->get_field_name('title'); ?>" type="text"
                   value="<?php echo esc_attr($title); ?>">
        </p>

        <p>
            <label for="<?php echo esc_html($this->get_field_id('phone_1', 'chakavak')); ?>">
                <?php esc_html_e('Phone 1:', 'chakavak'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_html($this->get_field_id('phone_1', 'chakavak')); ?>" name="<?php echo esc_html($this->get_field_name('phone_1', 'chakavak')); ?>" type="text" value="<?php echo esc_attr($phone_1); ?>"/>
        </p>

        <p>
            <label for="<?php echo esc_html($this->get_field_id('phone_2', 'chakavak')); ?>">
                <?php esc_html_e('Phone 2:', 'chakavak'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_html($this->get_field_id('phone_2', 'chakavak')); ?>" name="<?php echo esc_html($this->get_field_name('phone_2', 'chakavak')); ?>" type="text" value="<?php echo esc_attr($phone_2); ?>"/>
        </p>

        <p>
            <label for="<?php echo esc_html($this->get_field_id('fax', 'chakavak')); ?>">
                <?php esc_html_e('fax:', 'chakavak'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_html($this->get_field_id('fax', 'chakavak')); ?>" name="<?php echo esc_html($this->get_field_name('fax', 'chakavak')); ?>" type="text" value="<?php echo esc_attr($fax); ?>"/>
        </p>

        <p>
            <label for="<?php echo esc_html($this->get_field_id('email', 'chakavak')); ?>">
                <?php esc_html_e('email:', 'chakavak'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_html($this->get_field_id('email', 'chakavak')); ?>" name="<?php echo esc_html($this->get_field_name('email', 'chakavak')); ?>" type="email" value="<?php echo esc_attr($email); ?>"/>
        </p>

        <p>
            <label for="<?php echo esc_html($this->get_field_id('address', 'chakavak')); ?>">
                <?php esc_html_e('address:', 'chakavak'); ?>
            </label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('address')); ?>" name="<?php echo esc_attr($this->get_field_name('address')); ?>" type="text" cols="30" rows="5"><?php echo esc_attr($address); ?></textarea>
        </p>


        <?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = isset($new_instance['title']) ? $new_instance['title'] : __('Contact us', 'chakavak');
        $instance['address'] = !empty($new_instance['address']) ? $new_instance['address'] : '';
        $instance['email'] = !empty($new_instance['email']) ? $new_instance['email'] : '';
        $instance['phone_1'] = !empty($new_instance['phone_1']) ? $new_instance['phone_1'] : '';
        $instance['phone_2'] = !empty($new_instance['phone_2']) ? $new_instance['phone_2'] : '';
        $instance['fax'] = !empty($new_instance['fax']) ? $new_instance['fax'] : '';
        $instance['address'] = !empty($new_instance['address']) ? $new_instance['address'] : '';

        return $instance;
    }
}

function chakavak_register_contact_widget()
{
    register_widget('Chakavak_Contact_Widget');
}

add_action('widgets_init', 'chakavak_register_contact_widget');
