<?php

class Chakavak_Button_Widget extends WP_Widget
{

    public function __construct()
    {
        parent::__construct(
            'chk_button_widget',
            esc_html__('Chakavak - Widget button', 'chakavak'), // Name
            array(
                'description' => esc_html__('A widget to display the button', 'chakavak'),
                'classname' => 'chk-widget-button'
            ),
        );
    }

    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        $button_link = $instance['button_link'];
        $button_style = $instance['button_style'];

        echo $args['before_widget'];

        $class = 'chk-button chk-button__default d-flex ' . 'chk-' . $button_style;
        echo "<a href='{$button_link}' class='{$class}'>{$title}</a>";

        echo $args['after_widget'];
    }

    public function form($instance)
    {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $button_link = !empty($instance['button_link']) ? $instance['button_link'] : '';
        $button_style = !empty($instance['button_style']) ? $instance['button_style'] : 'btn-primary';
?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('title:', 'chakavak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('button_link'); ?>"><?php _e('Button link:', 'chakavak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('button_link'); ?>" name="<?php echo $this->get_field_name('button_link'); ?>" type="text" value="<?php echo esc_attr($button_link); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('button_style'); ?>"><?php _e('Style:', 'chakavak'); ?></label>
            <select class="widefat" id="<?php echo $this->get_field_id('button-style'); ?>" name="<?php echo $this->get_field_name('button_style'); ?>">
                <option value="btn-primary" <?php selected($button_style, 'btn-primary'); ?>><?php _e('Primary color', 'chakavak'); ?></option>
                <option value="btn-secondary" <?php selected($button_style, 'btn-secondary'); ?>><?php _e('Secondary color', 'chakavak'); ?></option>
                <option value="btn-black" <?php selected($button_style, 'btn-black'); ?>><?php _e('Black color', 'chakavak'); ?></option>
                <option value="btn-green" <?php selected($button_style, 'btn-green'); ?>><?php _e('Green color', 'chakavak'); ?></option>
                <option value="btn-blue" <?php selected($button_style, 'btn-blue'); ?>><?php _e('Blue color', 'chakavak'); ?></option>
                <option value="btn-gray" <?php selected($button_style, 'btn-gray'); ?>><?php _e('Gray color', 'chakavak'); ?></option>
            </select>
        </p>
<?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['button_link'] = (!empty($new_instance['button_link'])) ? strip_tags($new_instance['button_link']) : '';
        $instance['button_style'] = (!empty($new_instance['button_style'])) ? $new_instance['button_style'] : 'btn-primary';
        return $instance;
    }
}

function chakavak_register_button_widget()
{
    register_widget('Chakavak_Button_Widget');
}

add_action('widgets_init', 'chakavak_register_button_widget');
