<?php

class Chakavak_Author_Widget extends WP_Widget
{

    public function __construct()
    {
        add_action('admin_enqueue_scripts', array($this, 'author_scripts'));

        parent::__construct(
            'chk_author_widget',
            esc_html__('Chakavak - Author Information', 'chakavak'), // Name
            array(
                'description' => esc_html__('A author Information Widget', 'chakavak'),
                'classname' => 'chk-widget-author'
            ),
        );
    }

    public function author_scripts()
    {
        wp_enqueue_script('media-upload');
        wp_enqueue_media();
        $assets_js = get_template_directory_uri() . '/inc/backend/assets/js/';
        $theme = wp_get_theme(get_template());
        $version = $theme->get('Version');
        wp_enqueue_script('chakavak_upload_media_admin', $assets_js . 'upload_media_widget.min.js', array('jquery',), $version, true);
    }

    // Widget Frontend Display
    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        $text = !empty($instance['text']) ? $instance['text'] : '';
        $image = !empty($instance['image']) ? $instance['image'] : '';
        $facebook = !empty($instance['facebook']) ? $instance['facebook'] : '';
        $twitter = !empty($instance['twitter']) ? $instance['twitter'] : '';
        $instagram = !empty($instance['instagram']) ? $instance['instagram'] : '';
        $telegram = !empty($instance['telegram']) ? $instance['telegram'] : '';
        $linkedin = !empty($instance['linkedin']) ? $instance['linkedin'] : '';
        $youtube = !empty($instance['youtube']) ? $instance['youtube'] : '';
        $aparat = !empty($instance['aparat']) ? $instance['aparat'] : '';
        $whatsapp = !empty($instance['whatsapp']) ? $instance['whatsapp'] : '';
        $phone = !empty($instance['phone']) ? $instance['phone'] : '';
        $email = !empty($instance['email']) ? $instance['email'] : '';
        echo $args['before_widget'];
        ?>
        <div class="chk-author-widget__wrap text-center">
            <?php if (($image)) { ?>
                <div class="chk-author-widget__image">
                    <img class="d-inline-block max-w-full" src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($title); ?>">
                </div>
            <?php } ?>
            <?php
            if (!empty($title)) {
                echo '<strong class="chk-author-widget__title">' . esc_html($title) . '</strong>';
            }
            if (!empty($text)) {
                echo '<p class="chk-author-widget__desc">' . wp_kses_post($text) . '</p>';
            }
            ?>

            <div class="chk-author-widget__icons d-flex flex-wrap">
                <?php if ($phone) {
                    echo '<a href="tel:' . esc_html($phone) . '"><i class="ti-phone"></i></a>';
                } ?>
                <?php if ($whatsapp) {
                    echo '<a href="https://api.whatsapp.com/send?phone=+98' . esc_html($whatsapp) . '"><i class="ti-logo-whatsapp"></i></a>';
                } ?>
                <?php if ($email) {
                    echo '<a href="mailto:' . esc_html($email) . '"><i class="ti-email"></i></a>';
                } ?>
                <?php if ($instagram) {
                    echo '<a href="' . esc_url($instagram) . '"><i class="ti-logo-instagram"></i></a>';
                } ?>
                <?php if ($telegram) {
                    echo '<a href="' . esc_url($telegram) . '"><i class="ti-logo-telegram"></i></a>';
                } ?>
                <?php if ($linkedin) {
                    echo '<a href="' . esc_url($linkedin) . '"><i class="ti-logo-linkedin"></i></a>';
                } ?>
                <?php if ($twitter) {
                    echo '<a href="' . esc_url($twitter) . '"><i class="ti-logo-twitter"></i></a>';
                } ?>
                <?php if ($facebook) {
                    echo '<a href="' . esc_url($facebook) . '"><i class="ti-logo-facebook"></i></a>';
                } ?>
                <?php if ($youtube) {
                    echo '<a href="' . esc_url($youtube) . '"><i class="ti-logo-youtube"></i></a>';
                } ?>
                <?php if ($aparat) {
                    echo '<a href="' . esc_url($aparat) . '"><i class="ti-logo-aparat"></i></a>';
                } ?>
            </div>
        </div>
        <?php
        echo $args['after_widget'];
    }

    public function form($instance)
    {
        $title = isset($instance['title']) ? $instance['title'] : __('Chakavak Agancy', 'chakavak');
        $text = !empty($instance['text']) ? $instance['text'] : '';
        $image = !empty($instance['image']) ? $instance['image'] : '';
        $facebook = !empty($instance['facebook']) ? $instance['facebook'] : '';
        $twitter = !empty($instance['twitter']) ? $instance['twitter'] : '';
        $instagram = !empty($instance['instagram']) ? $instance['instagram'] : '';
        $telegram = !empty($instance['telegram']) ? $instance['telegram'] : '';
        $linkedin = !empty($instance['linkedin']) ? $instance['linkedin'] : '';
        $youtube = !empty($instance['youtube']) ? $instance['youtube'] : '';
        $aparat = !empty($instance['aparat']) ? $instance['aparat'] : '';
        $whatsapp = !empty($instance['whatsapp']) ? $instance['whatsapp'] : '';
        $phone = !empty($instance['phone']) ? $instance['phone'] : '';
        $email = !empty($instance['email']) ? $instance['email'] : '';
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php echo esc_html__('Title:', 'chakavak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                   name="<?php echo $this->get_field_name('title'); ?>" type="text"
                   value="<?php echo esc_attr($title); ?>">
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('image'); ?>"><?php echo esc_html__('Image', 'chakavak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('image'); ?>" name="<?php echo $this->get_field_name('image'); ?>" type="text" value="<?php echo esc_url($image); ?>"/>
            <button class="upload_image_button button button-primary">
                <?php echo esc_html__('Upload Image', 'chakavak'); ?>
            </button>
        </p>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('text')); ?>">
                <?php echo esc_html__('Description', 'chakavak'); ?>
            </label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('text')); ?>" name="<?php echo esc_attr($this->get_field_name('text')); ?>" type="text" cols="30" rows="5"><?php echo esc_attr($text); ?></textarea>
        </p>

        <p>
            <label for="<?php echo esc_html($this->get_field_id('facebook', 'chakavak')); ?>">
                <?php esc_html_e('Facebook URL:', 'chakavak'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_html($this->get_field_id('facebook', 'chakavak')); ?>" name="<?php echo esc_html($this->get_field_name('facebook', 'chakavak')); ?>" type="text" value="<?php echo esc_attr($facebook); ?>"/>
        </p>

        <p>
            <label for="<?php echo esc_html($this->get_field_id('twitter', 'chakavak')); ?>">
                <?php esc_html_e('Twitter URL:', 'chakavak'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_html($this->get_field_id('twitter', 'chakavak')); ?>" name="<?php echo esc_html($this->get_field_name('twitter', 'chakavak')); ?>" type="text" value="<?php echo esc_attr($twitter); ?>"/>
        </p>

        <p>
            <label for="<?php echo esc_html($this->get_field_id('instagram', 'chakavak')); ?>">
                <?php esc_html_e('Instagram URL:', 'chakavak'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_html($this->get_field_id('instagram', 'chakavak')); ?>" name="<?php echo esc_html($this->get_field_name('instagram', 'chakavak')); ?>" type="text" value="<?php echo esc_attr($instagram); ?>"/>
        </p>

        <p>
            <label for="<?php echo esc_html($this->get_field_id('telegram', 'chakavak')); ?>">
                <?php esc_html_e('Telegram URL:', 'chakavak'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_html($this->get_field_id('telegram', 'chakavak')); ?>" name="<?php echo esc_html($this->get_field_name('telegram', 'chakavak')); ?>" type="text" value="<?php echo esc_attr($telegram); ?>"/>
        </p>

        <p>
            <label for="<?php echo esc_html($this->get_field_id('linkedin', 'chakavak')); ?>">
                <?php esc_html_e('Linkedin URL:', 'chakavak'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_html($this->get_field_id('linkedin', 'chakavak')); ?>" name="<?php echo esc_html($this->get_field_name('linkedin', 'chakavak')); ?>" type="text" value="<?php echo esc_attr($linkedin); ?>"/>
        </p>

        <p>
            <label for="<?php echo esc_html($this->get_field_id('youtube', 'chakavak')); ?>">
                <?php esc_html_e('Youtube URL:', 'chakavak'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_html($this->get_field_id('youtube', 'chakavak')); ?>" name="<?php echo esc_html($this->get_field_name('youtube', 'chakavak')); ?>" type="text" value="<?php echo esc_attr($youtube); ?>"/>
        </p>

        <p>
            <label for="<?php echo esc_html($this->get_field_id('aparat', 'chakavak')); ?>">
                <?php esc_html_e('Aparat URL:', 'chakavak'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_html($this->get_field_id('aparat', 'chakavak')); ?>" name="<?php echo esc_html($this->get_field_name('aparat', 'chakavak')); ?>" type="text" value="<?php echo esc_attr($aparat); ?>"/>
        </p>

        <p>
            <label for="<?php echo esc_html($this->get_field_id('whatsapp', 'chakavak')); ?>">
                <?php esc_html_e('Whatsapp number:', 'chakavak'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_html($this->get_field_id('whatsapp', 'chakavak')); ?>" name="<?php echo esc_html($this->get_field_name('whatsapp', 'chakavak')); ?>" type="number" value="<?php echo esc_attr($whatsapp); ?>"/>
            <small><?php echo esc_html__('Enter the phone number without the leading zero. For example, 9129998888', 'chakavak'); ?></small>
        </p>

        <p>
            <label for="<?php echo esc_html($this->get_field_id('phone', 'chakavak')); ?>">
                <?php esc_html_e('Phone number:', 'chakavak'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_html($this->get_field_id('phone', 'chakavak')); ?>" name="<?php echo esc_html($this->get_field_name('phone', 'chakavak')); ?>" type="number" value="<?php echo esc_attr($phone); ?>"/>
        </p>

        <p>
            <label for="<?php echo esc_html($this->get_field_id('email', 'chakavak')); ?>">
                <?php esc_html_e('Email:', 'chakavak'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_html($this->get_field_id('email', 'chakavak')); ?>" name="<?php echo esc_html($this->get_field_name('email', 'chakavak')); ?>" type="email" value="<?php echo esc_attr($email); ?>"/>
        </p>
        <?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = isset($new_instance['title']) ? $new_instance['title'] : __('Chakavak Agancy', 'chakavak');
        $instance['text'] = !empty($new_instance['text']) ? $new_instance['text'] : '';
        $instance['image'] = !empty($new_instance['image']) ? $new_instance['image'] : '';
        $instance['facebook'] = !empty($new_instance['facebook']) ? $new_instance['facebook'] : '';
        $instance['twitter'] = !empty($new_instance['twitter']) ? $new_instance['twitter'] : '';
        $instance['instagram'] = !empty($new_instance['instagram']) ? $new_instance['instagram'] : '';
        $instance['telegram'] = !empty($new_instance['telegram']) ? $new_instance['telegram'] : '';
        $instance['linkedin'] = !empty($new_instance['linkedin']) ? $new_instance['linkedin'] : '';
        $instance['youtube'] = !empty($new_instance['youtube']) ? $new_instance['youtube'] : '';
        $instance['aparat'] = !empty($new_instance['aparat']) ? $new_instance['aparat'] : '';
        $instance['whatsapp'] = !empty($new_instance['whatsapp']) ? $new_instance['whatsapp'] : '';
        $instance['phone'] = !empty($new_instance['phone']) ? $new_instance['phone'] : '';
        $instance['email'] = !empty($new_instance['email']) ? $new_instance['email'] : '';

        return $instance;
    }
}

function chakavak_register_author_widget()
{
    register_widget('Chakavak_Author_Widget');
}

add_action('widgets_init', 'chakavak_register_author_widget');
