<?php

/**
 * Register required, recommended plugins for theme
 *
 * @link http://tgmpluginactivation.com/configuration/
 *
 * @package Chakavak
 */
require_once CHAKAVAK_INC . 'libs/class-tgm-plugin-activation.php';
function chakavak_register_required_plugins()
{
    $protocol = is_ssl() ? 'https' : 'http';
    $plugins = [
        [
            'name' => esc_html__('Elementor Page Builder', 'chakavak'),
            'slug' => 'elementor',
            'required' => true,
        ],

        [
            'name' => esc_html__('Contact Form 7', 'chakavak'),
            'slug' => 'contact-form-7',
            'required' => false,
        ],

        [
            'name' => esc_html__('Parsi Date Plugin', 'chakavak'),
            'slug' => 'wp-parsidate',
            'required' => false,
        ],

    ];
    $config = [
        'domain' => 'chakavak',
        'default_path' => '',
        'menu' => 'install-required-plugins',
        'has_notices' => true,
        'is_automatic' => false,
        'message' => '',
        'strings' => array(
            'page_title' => esc_html__('Install Required Plugins', 'chakavak'),
            'menu_title' => esc_html__('Install Plugins', 'chakavak'),
            'installing' => esc_html__('Installing Plugin: %s', 'chakavak'),
            'oops' => esc_html__('Something went wrong with the plugin API.', 'chakavak'),
            'notice_can_install_required' => _n_noop('This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'chakavak'),
            'notice_can_install_recommended' => _n_noop('This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'chakavak'),
            'notice_cannot_install' => _n_noop('Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'chakavak'),
            'notice_can_activate_required' => _n_noop('The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'chakavak'),
            'notice_can_activate_recommended' => _n_noop('The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'chakavak'),
            'notice_cannot_activate' => _n_noop('Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'chakavak'),
            'notice_ask_to_update' => _n_noop('The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'chakavak'),
            'notice_cannot_update' => _n_noop('Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'chakavak'),
            'install_link' => _n_noop('Begin installing plugin', 'Begin installing plugins', 'chakavak'),
            'activate_link' => _n_noop('Activate installed plugin', 'Activate installed plugins', 'chakavak'),
            'return' => esc_html__('Return to Required Plugins Installer', 'chakavak'),
            'plugin_activated' => esc_html__('Plugin activated successfully.', 'chakavak'),
            'complete' => esc_html__('All plugins installed and activated successfully. %s', 'chakavak'),
            'nag_type' => 'updated',
        ),
    ];

    tgmpa($plugins, $config);
}

add_action('tgmpa_register', 'chakavak_register_required_plugins');
