<?php
//Generate custom search form
function chakavak_search_form($form)
{
    $form = '<form role="search" method="get" class="chk-search-form" action="' . esc_url(home_url('/')) . '" >
    <input type="text" id="search-field" class="search-field" placeholder="' . esc_attr__('Type keyword', 'chakavak') . '" value="' . get_search_query() . '" name="s" />
	<button type="submit" class="search-submit"><i class="ti-search"></i></button>
    </form>';

    return $form;
}

add_filter('get_search_form', 'chakavak_search_form');

//Add span to category post count
function chakavak_cat_count_span($links)
{
    $links = str_replace('</a> (', '</a> <span class="posts-count">(', $links);
    $links = str_replace(')', ')</span>', $links);

    return $links;
}

add_filter('wp_list_categories', 'chakavak_cat_count_span');


if (!function_exists('chakavak_entry_sharing')) :
    /**
     * Prints HTML with meta information for the categories, tags and comments.
     */
    function chakavak_entry_sharing()
    {
        // Hide category and tag text for pages.
        if ('post' === get_post_type() || 'portfolio' === get_post_type()) {
            global $post;
            /* translators: used between list items, there is a space after the comma */
            /*get_the_permalink()*/
            $short_link = get_bloginfo('url') . "/?p=" . $post->ID;
            $share = chakavak_get_option('social_sharing');
            echo '<div class="social-sharing-post">';
            if ($share) :
                if (in_array('twitter', $share)) {
                    echo '<a class="share-twitter" target="_blank" href="https://twitter.com/intent/tweet?text=' . get_the_title() . '&url=' . $short_link . '" title="Twitter"><i class="ti-logo-twitter"></i></a>';
                }
                if (in_array('facebook', $share)) {
                    echo '<a class="share-facebook" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=' . $short_link . '" title="Facebook"><i class="ti-logo-facebook"></i></a>';
                }
                if (in_array('linkedin', $share)) {
                    echo '<a class="share-linkedin" target="_blank" href="https://www.linkedin.com/shareArticle?mini=true&url=' . $short_link . '&title=' . get_the_title() . '&summary=' . esc_url(get_home_url('/')) . '&source=' . get_bloginfo('name') . '" title="LinkedIn"><i class="ti-logo-linkedin"></i></a>';
                }
                if (in_array('telegram', $share)) {
                    echo ' <a class="share-telegram" target="_blank" href="https://telegram.me/share/url?url=' . $short_link . '&amp;text=' . get_the_title() . '" title="Telegram"><i class="ti-logo-telegram"></i></a>';
                }
                if (in_array('whatsapp', $share)) {
                    echo ' <a class="share-whatsapp" target="_blank" href="whatsapp://send?text=' . $short_link . '" title="Whatsapp"><i class="ti-logo-whatsapp"></i></a>';
                }
            endif;
            echo '</div>';
        }
    }
endif;

/**
 ** Single Post Navigation
 */
if (!function_exists('chakavak_single_post_nav')) :

    function chakavak_single_post_nav($posttype = 'post')
    {
        echo '<div class="single-post__nav">';
        $ncate = '';
        if (get_previous_post()) {
            $ppost = get_previous_post();
            $ptitle = get_the_title($ppost->ID);
            $pimage = get_the_post_thumbnail($ppost->ID, 'chk_portfolio');
            echo '<div class="single-post__nav-item post-prev">';
            previous_post_link('%link', '<div class="single-post__nav-thumbnail">' . $pimage . '</div><strong class="single-post__nav-title">' . $ptitle . '</strong>');
            echo '</div>';
        }

        if (get_next_post()) {
            $npost = get_next_post();
            $ntitle = get_the_title($npost->ID);
            $ndate = get_the_time(get_option('date_format'), $npost->ID);
            $nimage = get_the_post_thumbnail($npost->ID, 'chk_portfolio');
            echo '<div class="single-post__nav-item post-next">';
            next_post_link('%link', '<div class="single-post__nav-thumbnail">' . $nimage . '</div><strong class="single-post__nav-title">' . $ntitle . '</strong>');
            echo '</div>';
        }

        echo '</div>';
    }
endif;

/**
 ** Add Contact Methods in the User Profile
 */
function chakavak_user_contact_methods($user_contact)
{
    $user_contact['facebook'] = esc_html__('Facebook URL', 'chakavak');
    $user_contact['twitter'] = esc_html__('X Twitter', 'chakavak');
    $user_contact['youtube'] = esc_html__('Youtube Channel', 'chakavak');
    $user_contact['instagram'] = esc_html__('Instagram', 'chakavak');
    $user_contact['telegram'] = esc_html__('Telegram', 'chakavak');
    $user_contact['linkedin'] = esc_html__('Linkedin', 'chakavak');
    //$user_contact['pinterest'] = esc_html__('pinterest', 'chakavak');
    $user_contact['dribbble'] = esc_html__('Dribbble', 'chakavak');

    return $user_contact;
}
add_filter('user_contactmethods', 'chakavak_user_contact_methods');


function chakavak_author_info_box()
{

    global $post;

    $author_details = '';
    // Get author's display name - NB! changed display_name to first_name. Error in code.
    $display_name = get_the_author_meta('display_name', $post->post_author);
    $user_name = get_the_author_meta('nickname', $post->post_author);

    // If display name is not available then use nickname as display name
    if (empty($display_name)) {
        $display_name = get_the_author_meta('nickname', $post->post_author);
    }

    // Get author's biographical information or description
    $user_description = get_the_author_meta('user_description', $post->post_author);
    $user_twitter = get_the_author_meta('twitter', $post->post_author);
    $user_facebook = get_the_author_meta('facebook', $post->post_author);
    $user_youtube = get_the_author_meta('youtube', $post->post_author);
    $user_linkedin = get_the_author_meta('linkedin', $post->post_author);
    $user_instagram = get_the_author_meta('instagram', $post->post_author);
    $user_telegram = get_the_author_meta('telegram', $post->post_author);
    $user_dribbble = get_the_author_meta('dribbble', $post->post_author);

    // Get link to the author archive page
    $user_posts = get_author_posts_url(get_the_author_meta('ID', $post->post_author));
    if (!empty($display_name)) // Author avatar - - the number 90 is the px size of the image.
    {
        $author_details .= '<div class="d-flex items-center flex-wrap chk-author-bio__header">';
    }
    $author_details .= '<div class="chk-author-bio__info d-flex items-center">';
    $author_details .= '<div class="chk-author-bio__image d-inline-block lh-0">' . get_avatar(get_the_author_meta('ID'), 60) . '</div>';
    $author_details .= '<strong class="chk-author-bio__name d-inline-block">' . $display_name . '</strong>';
    $author_details .= '</div>';
    $author_details .= '<div class="chk-author-bio__button"><a class="chk-button" href="' . esc_url($user_posts) . '"><i class="ti-edit-file"></i>' . esc_html__('All Posts', 'chakavak') . '</a></div>';
    $author_details .= '</div>';
    $author_details .= '<p class="chk-author-bio__desc">' . get_the_author_meta('description') . '</p>';
    $author_details .= '<div class="chk-author-bio__socials">';

    $class_social = 'd-inline-flex items-center justify-center transition-all';
    // Check if author has Twitter in their profile
    if (!empty($user_twitter)) {
        $author_details .= ' <a href="' . $user_twitter . '" class="' . $class_social . '" target="_blank" rel="nofollow" title="Twitter"><i class="ti-logo-twitter"></i> </a>';
    }
    if (!empty($user_facebook)) {
        $author_details .= ' <a href="' . $user_facebook . '" class="' . $class_social . '" target="_blank" rel="nofollow" title="Facebook"><i class="ti-logo-facebook"></i> </a>';
    }
    if (!empty($user_linkedin)) {
        $author_details .= ' <a href="' . $user_linkedin . '" class="' . $class_social . '" target="_blank" rel="nofollow" title="linkedin"><i class="ti-logo-linkedin"></i> </a>';
    }
    if (!empty($user_instagram)) {
        $author_details .= ' <a href="' . $user_instagram . '" class="' . $class_social . '" target="_blank" rel="nofollow" title="Instagram"><i class="ti-logo-instagram"></i> </a>';
    }
    if (!empty($user_telegram)) {
        $author_details .= ' <a href="' . $user_telegram . '" class="' . $class_social . '" target="_blank" rel="nofollow" title="Telegram"><i class="ti-logo-telegram"></i> </a>';
    }
    if (!empty($user_youtube)) {
        $author_details .= ' <a href="' . $user_youtube . '" class="' . $class_social . '" target="_blank" rel="nofollow" title="Youtube"><i class="ti-logo-youtube"></i> </a>';
    }
    if (!empty($user_dribbble)) {
        $author_details .= ' <a href="' . $user_dribbble . '" class="' . $class_social . '" target="_blank" rel="nofollow" title="Dribbble"><i class="ti-logo-dribbble"></i> </a>';
    }
    $author_details .= '</div>';

    // Pass all this info to post content
    echo '<div class="chk-author-bio" >' . $author_details . '</div>';
}

/**
 ** Allow HTML in author bio section
 */
remove_filter('pre_user_description', 'wp_filter_kses');

if (!function_exists('chakavak_posted_in')) :
    /**
     * Prints HTML with meta information for the current author.
     */
    function chakavak_posted_in()
    {
        // $categories_list = get_the_category_list( esc_html__( ' ', 'chakavak' ) );
        $categories_list = preg_replace('/<a /', '<a class="d-inline-block transition-all"', get_the_category_list(esc_html__(' ', 'chakavak')));
        $posted_in = '';
        if ($categories_list) {
            /* translators: 1: list of categories. */
            $posted_in = sprintf(esc_html__('%1$s', 'chakavak'), $categories_list); // WPCS: XSS OK.
        }

        echo '<div class="chk-single-post__cates">' . $posted_in . '</div>'; // WPCS: XSS OK.

    }
endif;

if (!function_exists('chakavak_post_meta')) :
    /**
     * Prints HTML with meta information for the current author.
     */
    function chakavak_post_meta()
    {
        $time_string = '<time class="chk-entry-date published updated" datetime="%1$s">%2$s</time>';
        if (get_the_time('U') !== get_the_modified_time('U')) {
            $time_string = '<time class="chk-entry-date published" datetime="%1$s">%2$s</time>';
        }

        $time_string = sprintf(
            $time_string,
            esc_attr(get_the_date(DATE_W3C)),
            esc_html(get_the_date())
        );
        $posted_on = sprintf(
            /* translators: %s: post date. */
            esc_html_x('%s', 'post date', 'chakavak'),
            '<i class="ti-calendar"></i>' . $time_string
        );


        $byline = sprintf(
            /* translators: %s: post author. */
            esc_html_x('%s', 'post author', 'chakavak'),
            '<i class="ti-user"></i><a class="url" href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '">' . esc_html(get_the_author()) . '</a>'
        );

        $metas = chakavak_get_option('single_post_entry_meta');
        if (!empty($metas)) :
            echo "<ul class='chk-single-post__meta list-none p-0 m-0 d-inline-flex items-center flex-wrap '>";
            if (in_array('date', $metas)) {
                echo '<li class="chk-single-post__date d-inline-flex items-center">' . $posted_on . '</li>';
            }
            if (in_array('author', $metas)) {
                echo '<li class="chk-single-post__author d-inline-flex items-center">' . $byline . '</li>';
            }
            if (in_array('comm', $metas)) {
                echo '<li class="chk-single-post__comments d-inline-flex items-center"><i class="ti-comments"></i>';
                comments_number(esc_html__('No comments', 'chakavak'), esc_html__('One Comment', 'chakavak'), esc_html__('% Comments', 'chakavak'));
                echo '</a></li></a>';
            }
            echo "</ul>";
        endif;
    }
endif;

/**
 ** Related Posts
 */
function chakavak_related_posts()
{
    global $post;
    $byline = sprintf(
        esc_html_x('%s', 'post author', 'chakavak'),
        '<i class="ti-user"></i>' . esc_html(get_the_author())
    );
    $related = get_posts(array(
        'category__in' => wp_get_post_categories($post->ID),
        'numberposts' => 3,
        'post__not_in' => array($post->ID)
    ));

    if ($related) :
        echo '<div class="chk-single-post__related">';
        echo '<span class="chk-single-post__related-title"><i class="ti-file"></i><span>' . esc_html__('Related Posts', 'chakavak') . '</span></span>';
        echo '<div class="row rows-cols-xs-1 row-cols-md-3">';
        foreach ($related as $post) {
            setup_postdata($post);
            get_template_part('template-parts/single-post/related');
        }
        wp_reset_postdata();
        echo '</div>';
        echo '</div>';

    endif;
}

if (!function_exists('chakavak_entry_footer')) :
    /**
     * Prints HTML with meta information for the categories, tags and comments.
     */
    function chakavak_entry_footer()
    {
        // Hide category and tag text for pages.
        if ('post' === get_post_type() || 'portfolio' === get_post_type()) {
            global $post;
            /* translators: used between list items, there is a space after the comma */
            /*get_the_permalink()*/
            $short_link = get_bloginfo('url') . "/?p=" . $post->ID;
            $sw_share = chakavak_get_option('sw_single_post_socials');
            $share = chakavak_get_option('single_post_socials');
            echo '<div class="chk-entry-footer__social">';
            if ($sw_share && $share) :
                if (in_array('twitter', $share)) {
                    echo '<a class="share-twitter" target="_blank" href="https://twitter.com/intent/tweet?text=' . get_the_title() . '&url=' . $short_link . '" title="Twitter"><i class="ti-logo-twitter"></i></a>';
                }
                if (in_array('facebook', $share)) {
                    echo '<a class="share-facebook" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=' . $short_link . '" title="Facebook"><i class="ti-logo-facebook"></i></a>';
                }
                if (in_array('linkedin', $share)) {
                    echo '<a class="share-linkedin" target="_blank" href="https://www.linkedin.com/shareArticle?mini=true&url=' . $short_link . '&title=' . get_the_title() . '&summary=' . esc_url(get_home_url('/')) . '&source=' . get_bloginfo('name') . '" title="LinkedIn"><i class="ti-logo-linkedin"></i></a>';
                }
                if (in_array('telegram', $share)) {
                    echo ' <a class="share-telegram" target="_blank" href="https://telegram.me/share/url?url=' . $short_link . '&amp;text=' . get_the_title() . '" title="Telegram"><i class="ti-logo-telegram"></i></a>';
                }
                if (in_array('whatsapp', $share)) {
                    echo ' <a class="share-whatsapp" target="_blank" href="whatsapp://send?text=' . $short_link . '" title="Whatsapp"><i class="ti-logo-whatsapp"></i></a>';
                }
            endif;
            echo '</div>';
            $sw_short_link = chakavak_get_option('single_post_link');
            if ($sw_short_link) :
                echo '<div class="chk-entry-footer__shortlink">';
                echo '<input type="text" class="short-link" value="' . get_bloginfo('url') . '/?p=' . $post->ID . '" id="short-link-input" readonly>';
                echo '</div>';
            endif;
        }
    }
endif;
