<?php

defined('ABSPATH') or exit;

/*Page header Height */
if (!function_exists('chakavak_pheader_height')) {
    function chakavak_pheader_height()
    {
        $dynamic_pheader_height_css = '';
        $pheader_height = chakavak_get_option('pheader_height_group') !== null ? chakavak_get_option('pheader_height_group') : '';
        if (!empty($pheader_height)) {
            if (!empty($pheader_height['pheader_height_mobile'])) {
                $dynamic_pheader_height_css .= '@media (max-width: 767px) { .chk-page-header {min-height:' . $pheader_height['pheader_height_mobile'] . 'px} }';
            }

            if (!empty($pheader_height['pheader_height_tablet'])) {
                $dynamic_pheader_height_css .= '@media (min-width: 768px) { .chk-page-header {min-height:' . $pheader_height['pheader_height_tablet'] . 'px} }';
            }

            if (!empty($pheader_height['pheader_height_desktop'])) {
                $dynamic_pheader_height_css .= '@media (min-width: 1025px) { .chk-page-header {min-height:' . $pheader_height['pheader_height_desktop'] . 'px} }';
            }
        }

        if (!empty($dynamic_pheader_height_css)) {
            echo '<style type="text/css">' . $dynamic_pheader_height_css . '</style>';
        }
    }
}
add_action('wp_head', 'chakavak_pheader_height');


/*Page header Title Font size */
if (!function_exists('chakavak_pheader_fz_title')) {
    function chakavak_pheader_fz_title()
    {
        $dynamic_pheader_title_fz_css = '';
        $pheader_title = chakavak_get_option('ptitle_font_size_group') !== null ? chakavak_get_option('ptitle_font_size_group') : '';

        if (!empty($pheader_title)) {
            if (!empty($pheader_title['ptitle_size_mobile'])) {
                $dynamic_pheader_title_fz_css .= '@media (max-width: 767px) { .chk-page-header__title{font-size:' . $pheader_title['ptitle_size_mobile'] . 'px} }';
            }

            if (!empty($pheader_title['ptitle_size_tablet'])) {
                $dynamic_pheader_title_fz_css .= '@media (min-width: 768px) { .chk-page-header__title{font-size:' . $pheader_title['ptitle_size_tablet'] . 'px} }';
            }

            if (!empty($pheader_title['ptitle_size_desktop'])) {
                $dynamic_pheader_title_fz_css .= '@media (min-width: 1025px) { .chk-page-header__title{font-size:' . $pheader_title['ptitle_size_desktop'] . 'px} }';
            }
        }

        if (!empty($dynamic_pheader_title_fz_css)) {
            echo '<style type="text/css">' . $dynamic_pheader_title_fz_css . '</style>';
        }
    }
}
add_action('wp_head', 'chakavak_pheader_fz_title');


/**
 ** Custom Typography
 */
if (!function_exists('chakavak_fonts_typography')) {
    function chakavak_fonts_typography()
    {
        $dynamic_typography_css = '';
        if (chakavak_get_option('typography_switch')) {
            $body_typography = chakavak_get_option('body_typography') !== null ? chakavak_get_option('body_typography') : '';
            $h1_typography = chakavak_get_option('h1_typography') !== null ? chakavak_get_option('h1_typography') : '';
            $h2_typography = chakavak_get_option('h2_typography') !== null ? chakavak_get_option('h2_typography') : '';
            $h3_typography = chakavak_get_option('h3_typography') !== null ? chakavak_get_option('h3_typography') : '';
            $h4_typography = chakavak_get_option('h4_typography') !== null ? chakavak_get_option('h4_typography') : '';
            $h5_typography = chakavak_get_option('h5_typography') !== null ? chakavak_get_option('h5_typography') : '';
            $h6_typography = chakavak_get_option('h6_typography') !== null ? chakavak_get_option('h6_typography') : '';

            if (!empty($body_typography)) {
                $body_typography_css = '';
                if (!empty($body_typography['font-family'])) {
                    $body_typography_css .= 'font-family: ' . $body_typography['font-family'] . ';';
                }
                if (!empty($body_typography['font-weight'])) {
                    $body_typography_css .= 'font-weight: ' . $body_typography['font-weight'] . ';';
                }
                if (!empty($body_typography['font-size'])) {
                    $body_typography_css .= 'font-size: ' . $body_typography['font-size'] . $body_typography['unit'] . ';';
                }
                if (!empty($body_typography['line-height'])) {
                    $body_typography_css .= 'line-height: ' . $body_typography['line-height'] . $body_typography['unit'] . ';';
                }

                if ($body_typography_css) {
                    if (!empty($body_typography['font-size'])) {
                        $dynamic_typography_css .= 'html{ ' . $body_typography['font-size'] . ' }';
                    }
                    $dynamic_typography_css .= 'html{ ' . $body_typography['font-size'] . ' }body{ ' . $body_typography_css . ' }.chk-classic-editor {' . $body_typography_css . '}';
                    if (!empty($body_typography['font-family'])) {
                        $dynamic_typography_css .= 'input { font-family: ' . $body_typography['font-family'] . '}';
                        $dynamic_typography_css .= 'form :is(input[type=text],input[type=email],input[type=url],input[type=password],input[type=search],input[type=number],input[type=tel],input[type=range],input[type=date],input[type=month],input[type=week],input[type=time],input[type=datetime],input[type=datetime-local],input[type=color],select,textarea,input.input-form,textarea.input-form,select.input-form)  { font-family: ' . $body_typography['font-family'] . '}';
                        $dynamic_typography_css .= 'button, .chk-button { font-family: ' . $body_typography['font-family'] . '}';
                    }
                }
            }

            if (!empty($h1_typography)) {
                $h1_typography_css = '';
                if (!empty($h1_typography['font-family'])) {
                    $h1_typography_css .= 'font-family: ' . $h1_typography['font-family'] . ';';
                }
                if (!empty($h1_typography['font-weight'])) {
                    $h1_typography_css .= 'font-weight: ' . $h1_typography['font-weight'] . ';';
                }
                if (!empty($h1_typography['font-size'])) {
                    $h1_typography_css .= 'font-size: ' . $h1_typography['font-size'] . $h1_typography['unit'] . ';';
                }
                if (!empty($h1_typography['line-height'])) {
                    $h1_typography_css .= 'line-height: ' . $h1_typography['line-height'] . $h1_typography['unit'] . ';';
                }
                if ($h1_typography_css) {
                    $dynamic_typography_css .= '.chk-classic-editor h1 , .elementor-element h1{ ' . $h1_typography_css . ' }';

                    echo $dynamic_typography_css;
                }
            }

            if (!empty($h2_typography)) {
                $h2_typography_css = '';
                if (!empty($h2_typography['font-family'])) {
                    $h2_typography_css .= 'font-family: ' . $h2_typography['font-family'] . ';';
                }
                if (!empty($h2_typography['font-weight'])) {
                    $h2_typography_css .= 'font-weight: ' . $h2_typography['font-weight'] . ';';
                }
                if (!empty($h2_typography['font-size'])) {
                    $h2_typography_css .= 'font-size: ' . $h2_typography['font-size'] . $h2_typography['unit'] . ';';
                }
                if (!empty($h2_typography['line-height'])) {
                    $h2_typography_css .= 'line-height: ' . $h2_typography['line-height'] . $h2_typography['unit'] . ';';
                }
                if ($h2_typography_css) {
                    $dynamic_typography_css .= '.chk-classic-editor h2 , .elementor-element h2{ ' . $h2_typography_css . ' }';
                }
            }

            if (!empty($h3_typography)) {
                $h3_typography_css = '';
                if (!empty($h3_typography['font-family'])) {
                    $h3_typography_css .= 'font-family: ' . $h3_typography['font-family'] . ';';
                }
                if (!empty($h3_typography['font-weight'])) {
                    $h3_typography_css .= 'font-weight: ' . $h3_typography['font-weight'] . ';';
                }
                if (!empty($h3_typography['font-size'])) {
                    $h3_typography_css .= 'font-size: ' . $h3_typography['font-size'] . $h3_typography['unit'] . ';';
                }
                if (!empty($h3_typography['line-height'])) {
                    $h3_typography_css .= 'line-height: ' . $h3_typography['line-height'] . $h3_typography['unit'] . ';';
                }
                if ($h3_typography) {
                    $dynamic_typography_css .= '.chk-classic-editor h3 , .elementor-element h3{ ' . $h3_typography_css . ' }';
                }
            }

            if (!empty($h4_typography)) {
                $h4_typography_css = '';
                if (!empty($h4_typography['font-family'])) {
                    $h4_typography_css .= 'font-family: ' . $h4_typography['font-family'] . ';';
                }
                if (!empty($h4_typography['font-weight'])) {
                    $h4_typography_css .= 'font-weight: ' . $h4_typography['font-weight'] . ';';
                }
                if (!empty($h4_typography['font-size'])) {
                    $h4_typography_css .= 'font-size: ' . $h4_typography['font-size'] . $h4_typography['unit'] . ';';
                }
                if (!empty($h4_typography['line-height'])) {
                    $h4_typography_css .= 'line-height: ' . $h4_typography['line-height'] . $h4_typography['unit'] . ';';
                }
                if ($h4_typography) {
                    $dynamic_typography_css .= '.chk-classic-editor h4 , .elementor-element h4{ ' . $h4_typography_css . ' }';
                }
            }

            if (!empty($h5_typography)) {
                $h5_typography_css = '';
                if (!empty($h5_typography['font-family'])) {
                    $h5_typography_css .= 'font-family: ' . $h5_typography['font-family'] . ';';
                }
                if (!empty($h5_typography['font-weight'])) {
                    $h5_typography_css .= 'font-weight: ' . $h5_typography['font-weight'] . ';';
                }
                if (!empty($h5_typography['font-size'])) {
                    $h5_typography_css .= 'font-size: ' . $h5_typography['font-size'] . $h5_typography['unit'] . ';';
                }
                if (!empty($h5_typography['line-height'])) {
                    $h5_typography_css .= 'line-height: ' . $h5_typography['line-height'] . $h5_typography['unit'] . ';';
                }
                if ($h5_typography) {
                    $dynamic_typography_css .= '.chk-classic-editor h5 , .elementor-element h5{ ' . $h5_typography_css . ' }';
                }
            }

            if (!empty($h6_typography)) {
                $h6_typography_css = '';
                if (!empty($h6_typography['font-family'])) {
                    $h6_typography_css .= 'font-family: ' . $h6_typography['font-family'] . ';';
                }
                if (!empty($h6_typography['font-weight'])) {
                    $h6_typography_css .= 'font-weight: ' . $h6_typography['font-weight'] . ';';
                }
                if (!empty($h6_typography['font-size'])) {
                    $h6_typography_css .= 'font-size: ' . $h6_typography['font-size'] . $h6_typography['unit'] . ';';
                }
                if (!empty($h6_typography['line-height'])) {
                    $h6_typography_css .= 'line-height: ' . $h6_typography['line-height'] . $h6_typography['unit'] . ';';
                }
                if ($h6_typography) {
                    $dynamic_typography_css .= '.chk-classic-editor h6 , .elementor-element h6{ ' . $h6_typography_css . ' }';
                }
            }
        }

        if (!empty($dynamic_typography_css)) {
            echo '<style type="text/css">' . $dynamic_typography_css . '</style>';
        }
    }
}
add_action('wp_head', 'chakavak_fonts_typography');
/**
 ** Custom Page header Typography
 */
if (!function_exists('chakavak_pheader_fonts_typography')) {
    function chakavak_pheader_fonts_typography()
    {
        $dynamic_typography_css = '';

        $pheader_typography = chakavak_get_option('pheader_typography');
        if (!empty($pheader_typography) && is_array($pheader_typography)) {
            $pheader_typography_css = '';

            if (!empty($pheader_typography['font-family'])) {
                $pheader_typography_css .= 'font-family: ' . esc_attr($pheader_typography['font-family']) . ';';
            }

            if (!empty($pheader_typography['font-weight'])) {
                $pheader_typography_css .= 'font-weight: ' . esc_attr($pheader_typography['font-weight']) . ';';
            }

            if (!empty($pheader_typography_css)) {
                $dynamic_typography_css .= '.chk-page-header__title{ ' . $pheader_typography_css . ' }';
            }
        }

        $breadcrumbs_typography = chakavak_get_option('breadcrumbs_typography');
        if (!empty($breadcrumbs_typography) && is_array($breadcrumbs_typography)) {
            $breadcrumbs_typography_css = '';

            if (!empty($breadcrumbs_typography['font-family'])) {
                $breadcrumbs_typography_css .= 'font-family: ' . esc_attr($breadcrumbs_typography['font-family']) . ';';
            }

            if (!empty($breadcrumbs_typography['font-weight'])) {
                $breadcrumbs_typography_css .= 'font-weight: ' . esc_attr($breadcrumbs_typography['font-weight']) . ';';
            }

            if (!empty($breadcrumbs_typography_css)) {
                $dynamic_typography_css .= '.chk-page-header .chk-breadcrumbs { ' . $breadcrumbs_typography_css . ' }';
            }
        }

        if (!empty($dynamic_typography_css)) {
            echo '<style type="text/css">' . $dynamic_typography_css . '</style>';
        }
    }
}
add_action('wp_head', 'chakavak_pheader_fonts_typography');

/*Container Max width */
if (!function_exists('chakavak_container_width')) {
    function chakavak_container_width()
    {
        $dynamic_container_width_css = '';
        $container_width = chakavak_get_option('container_width') !== null ? chakavak_get_option('container_width') : '';
        if (!empty($container_width)) {
            $dynamic_container_width_css .= '@media(min-width: 1200px){ .container {--max-width:' . $container_width . 'px} }';
        }

        if (!empty($dynamic_container_width_css)) {
            echo '<style type="text/css">' . $dynamic_container_width_css . '</style>';
        }
    }
}
add_action('wp_head', 'chakavak_container_width');

/**
 ** Preloader Color Scheme
 */
if (!function_exists('chakavak_preloader_color_scheme')) {
    function chakavak_preloader_color_scheme()
    {
        $preloader_color_scheme_css = '';
        if (chakavak_get_option('display_loader')) {
            $bg_loader = chakavak_get_option('loader_bg_color');
            $color_loader = chakavak_get_option('loader_color');
            if (!empty($bg_loader) && $bg_loader != '#ffffff') {
                $preloader_color_scheme_css .= '#chk-preloader{background-color:' . $bg_loader . ' }';
            }
            if (!empty($bg_loader) && $color_loader != '#1D4ED8') {
                $preloader_color_scheme_css .= '.ball-clip-rotate > div{border-color:' . $color_loader . ' }';
                $preloader_color_scheme_css .= '.ball-spin-fade-loader > div{background-color:' . $color_loader . ' }';
                $preloader_color_scheme_css .= '.ball-grid-pulse > div{background-color:' . $color_loader . ' }';
                $preloader_color_scheme_css .= '.ball-scale-multiple > div{background-color:' . $color_loader . ' }';
                $preloader_color_scheme_css .= '.square-spin > div{background-color:' . $color_loader . ' }';
                $preloader_color_scheme_css .= '.pacman > div:nth-child(3),.pacman > div:nth-child(4),.pacman > div:nth-child(5),.pacman > div:nth-child(6){background-color:' . $color_loader . ' }';
                $preloader_color_scheme_css .= '.pacman > div:nth-child(2){border-top-color:' . $color_loader . ';border-left-color:' . $color_loader . ';border-bottom-color:' . $color_loader . ' }';
                $preloader_color_scheme_css .= '.pacman > div:nth-child(2){border-top-color:' . $color_loader . ';border-left-color:' . $color_loader . ';border-bottom-color:' . $color_loader . ' }';
                $preloader_color_scheme_css .= '.pacman > div:first-of-type{border-top-color:' . $color_loader . ';border-left-color:' . $color_loader . ';border-bottom-color:' . $color_loader . ' }';
                $preloader_color_scheme_css .= '.ball-clip-rotate-multiple > div:last-child{border-color:' . $color_loader . ' transparent ' . $color_loader . ' transparent }';
                $preloader_color_scheme_css .= '.ball-clip-rotate-multiple > div{border-color:' . $color_loader . '}';
                $preloader_color_scheme_css .= '.line-scale-pulse-out > div{background-color:' . $color_loader . '}';
            }
        }
        if (!empty($preloader_color_scheme_css)) {
            echo '<style type="text/css">' . $preloader_color_scheme_css . '</style>';
        }
    }
}
add_action('wp_head', 'chakavak_preloader_color_scheme');

/*
* color_scheme
*/
if (!function_exists('chakavak_color_scheme')) {
    function chakavak_color_scheme()
    {
        $dynamic_color_scheme_css = '';
        $primary_color = chakavak_get_option('primary_color') !== null ? chakavak_get_option('primary_color') : '';
        $secondary_color = chakavak_get_option('secondary_color') !== null ? chakavak_get_option('secondary_color') : '';
        $text_color = chakavak_get_option('text_color') !== null ? chakavak_get_option('text_color') : '';
        $heading_color = chakavak_get_option('heading_color') !== null ? chakavak_get_option('heading_color') : '';
        $bg_body = chakavak_get_option('bg_body') !== null ? chakavak_get_option('bg_body') : '';

        if (!empty($primary_color) && $primary_color != '#1d4ed8') {
            $dynamic_color_scheme_css .= ':root {--chk-c-primary:' . $primary_color . ' }';
        }
        if (!empty($secondary_color) && $secondary_color != '#02153f') {
            $dynamic_color_scheme_css .= ':root {--chk-c-secondary:' . $secondary_color . ' }';
        }

        if (!empty($text_color) && $text_color != '#111827') {
            $dynamic_color_scheme_css .= 'body{--chk-c-text:' . $text_color . ' }';
            $dynamic_color_scheme_css .= '.chk-classic-editor{--chk-c-text:' . $text_color . ' }';
        }

        if (!empty($heading_color) && $heading_color != '#111827') {
            $dynamic_color_scheme_css .= '.chk-classic-editor > :is(h1,h2,h3,h4,h5,h6) {--chk-c-heading:' . $heading_color . ' }';
        }

        if (!empty($bg_body) && $bg_body != '#ffffff') {
            $dynamic_color_scheme_css .= 'body {--chk-c-body:' . $bg_body . ' }';
        }

        if (!empty($dynamic_color_scheme_css)) {
            echo '<style type="text/css">' . $dynamic_color_scheme_css . '</style>';
        }
    }
}
add_action('wp_head', 'chakavak_color_scheme');


/*
* Custom CSS option Panel
*/
if (!function_exists('chakavak_custom_css')) {
    function chakavak_custom_css()
    {
        $dynamic_custom_css = '';

        $css_mobile = chakavak_get_option('css_mobile') !== null ? chakavak_get_option('css_mobile') : '';
        $css_tablet = chakavak_get_option('css_tablet') !== null ? chakavak_get_option('css_tablet') : '';
        $css_desktop = chakavak_get_option('css_desktop') !== null ? chakavak_get_option('css_desktop') : '';
        $css_all_screen = chakavak_get_option('css_all_screen') !== null ? chakavak_get_option('css_all_screen') : '';

        if (!empty($css_mobile)) {
            $dynamic_custom_css .= '@media (max-width: 767px) { ' . $css_mobile . '}';
        }
        if (!empty($css_tablet)) {
            $dynamic_custom_css .= '@media (min-width: 768px) { ' . $css_tablet . '}';
        }
        if (!empty($css_desktop)) {
            $dynamic_custom_css .= '@media (min-width: 1025px) { ' . $css_desktop . '}';
        }
        if (!empty($css_all_screen)) {
            $dynamic_custom_css .= $css_all_screen;
        }

        if (!empty($dynamic_custom_css)) {
            echo '<style type="text/css">' . $dynamic_custom_css . '</style>';
        }
    }
}
add_action('wp_head', 'chakavak_custom_css');
