<?php
defined('ABSPATH') or exit;
/**
 * Heading Tag
 */
function chakavak_heading()
{
    return [
        'h1' => 'H1',
        'h2' => 'H2',
        'h3' => 'H3',
        'h4' => 'H4',
        'h5' => 'H5',
        'h6' => 'H6',
        'p' => 'p',
        'span' => 'span',
        'div' => 'div',
    ];
}

function chakavak_true_false()
{
    return [
        'true' => __('Yes', 'chakavak'),
        'false' => __('No', 'chakavak'),
    ];
}

function chakavak_one_sex()
{
    return [
        1 => 1,
        2 => 2,
        3 => 3,
        4 => 4,
        5 => 5,
        6 => 6
    ];
}

function chakavak_one_eight()
{
    return [
        1 => 1,
        '1.1' => '1.1',
        2 => 2,
        '2.2' => '2.2',
        3 => 3,
        '3.2' => '3.2',
        4 => 4,
        '4.2' => '4.2',
        5 => 5,
        '5.2' => '5.2',
        6 => 6,
        '6.2' => '6.2',
        7 => 7,
        8 => 8,
    ];
}

/**
 * Text alignment
 */
function chakavak_alignment()
{
    return [
        'left' => [
            'title' => esc_html__('Left', 'chakavak'),
            'icon' => 'eicon-text-align-left',
        ],
        'center' => [
            'title' => esc_html__('Center', 'chakavak'),
            'icon' => 'eicon-text-align-center',
        ],
        'right' => [
            'title' => esc_html__('Right', 'chakavak'),
            'icon' => 'eicon-text-align-right',
        ],
        'justify' => [
            'title' => esc_html__('justify', 'chakavak'),
            'icon' => 'eicon-text-align-justify',
        ],
    ];
}

function chakavak_alignment_2()
{
    return [
        'left' => [
            'title' => esc_html__('Left', 'chakavak'),
            'icon' => 'eicon-text-align-left',
        ],
        'center' => [
            'title' => esc_html__('Center', 'chakavak'),
            'icon' => 'eicon-text-align-center',
        ],
        'right' => [
            'title' => esc_html__('Right', 'chakavak'),
            'icon' => 'eicon-text-align-right',
        ],
    ];
}

/**
 * horizontal position
 */
function chakavak_horizontal_position()
{
    return [
        'flex-start' => [
            'title' => esc_html__('Left', 'chakavak'),
            'icon' => 'eicon-h-align-left',
        ],
        'center' => [
            'title' => esc_html__('Center', 'chakavak'),
            'icon' => 'eicon-h-align-center',
        ],
        'flex-end' => [
            'title' => esc_html__('Right', 'chakavak'),
            'icon' => 'eicon-h-align-right',
        ],
    ];
}

/**
 * Vertical Position
 */
function chakavak_vertical_position()
{
    return [
        'flex-start' => [
            'title' => esc_html__('Top', 'chakavak'),
            'icon' => 'eicon-v-align-top',
        ],
        'center' => [
            'title' => esc_html__('Center', 'chakavak'),
            'icon' => 'eicon-v-align-middle',
        ],
        'flex-end' => [
            'title' => esc_html__('Bottom', 'chakavak'),
            'icon' => 'eicon-v-align-bottom',
        ],
    ];
}

/**
 * Border Style
 */
function chakavak_border_style()
{
    return [
        'none' => esc_html__('None', 'chakavak'),
        'solid' => esc_html__('Solid', 'chakavak'),
        'double' => esc_html__('Double', 'chakavak'),
        'dotted' => esc_html__('Dotted', 'chakavak'),
        'dashed' => esc_html__('Dashed', 'chakavak'),
        'groove' => esc_html__('Groove', 'chakavak'),
        'ridge' => esc_html__('Ridge', 'chakavak'),
    ];
}
