<?php
defined('ABSPATH') or exit;
$title_tag = $settings['title_tag'];
$title_class = 'chk-post-item__title transition-all';
if ($settings['title_inline_limit']) {
    $title_class .= ' chk-title-inline';
}
?>
<article id="post-<?php echo get_the_ID(); ?>" <?php post_class($post_cls); ?>>

    <?php if (has_post_thumbnail(get_the_ID()) && $settings['show_image'] == 'yes') : ?>

        <div class="chk-post-item__thumbnail pos-relative lh-0 overflow-hidden chk-effect-<?php echo $settings['image_hover_effect']; ?>">
            <?php if ($settings['show_date'] == 'yes') : ?>
                <div class="chk-post-item__date if-center pos-absolute z-1 flex-col text-center">
                    <?php echo sprintf('%s', get_the_date('d')); ?>
                    <span>
                        <?php echo sprintf('%s', get_the_date('M')); ?>
                    </span>
                </div>
            <?php endif; ?>
            <a href="<?php echo esc_url($permalink); ?>" class="chk-post-item__image lh-0 d-block">
                <?php echo $image_html; ?>
            </a>
        </div>

    <?php endif; ?>

    <div class="chk-post-item__content pos-relative z-1">
        <?php if ($settings['show_cat'] == 'yes') : ?>
            <div class="chk-post-item__cat">
                <?php
                echo '<i class="ti-folder"></i>';
                $chk_post_all_cats = get_the_category();
                $chk_post_cat_list = array();
                if ($chk_post_all_cats) {
                    foreach ($chk_post_all_cats as $category) {
                        $chk_post_cat_list[] = '<a href="' . esc_url(get_category_link($category->term_id)) . '" title="' . esc_attr(sprintf(esc_html__('%s', 'chakavak'), $category->name)) . '" >' . esc_html($category->cat_name) . '</a>';
                    }
                    echo implode(' , ', $chk_post_cat_list);
                } ?>
            </div>
        <?php endif; ?>

        <?php
        echo '<' . $title_tag . ' class="' . $title_class . '">';
        echo '<a href="' . $permalink . '" target="' . $settings['target_link'] . '">' . get_the_title() . '</a>';
        echo '</' . $title_tag . '>';
        ?>

        <?php
        if ($settings['show_excerpt'] == 'yes') : ?>
            <div class="chk-post-item__excerpt">
                <?php echo chakavak_short_text(get_the_excerpt(), intval($settings['excerpt_length'])) . ' ...'; ?>
            </div>
        <?php endif; ?>

    </div>

    <div class="mt-auto">
        <div class="chk-post-item__bottom">
            <ul class="chk-post-item__meta">
                <?php
                if ($settings['show_author'] == 'yes') {
                    echo '<li class="chk-post-item__author"><i class="ti-edit-file"></i><a href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '">' . esc_html(get_the_author()) . '</a></li>';
                }
                if ($settings['show_comments'] == 'yes') {
                    echo '<li class="chk-post-item__comment"><i class="ti-comments"></i>' . get_comments_number() . '</li>';
                }
                ?>
            </ul>

            <div class="chk-post-item__readmore">
                <?php
                $icon_readmore = is_rtl() ? '<i class="ti-arrow-large-left"></i>' : '<i class="ti-arrow-large-right"></i>';
                ?>
                <a href="<?php echo esc_url($permalink); ?>" class="if-center">
                    <?php echo $icon_readmore; ?>
                </a>
            </div>
        </div>
    </div>
</article>