<?php
defined('ABSPATH') or exit;
$title_tag = $settings['title_tag'];
$title_class = 'chk-portfolio-item__title transition-all';
if ($settings['title_inline']) {
    $title_class .= ' chk-title-inline';
}
$url = esc_url($permalink);

?>
<article <?php echo $this->get_render_attribute_string('portfolio-item'); ?>>

    <?php if ($thumbnail_id) : ?>
        <div class="chk-portfolio-item__thumbnail-wrapper">
            <div class="chk-portfolio-item__thumbnail pos-relative overflow-hidden z-1 lh-0">
                <?php echo $image_html; ?>
            </div>
        </div>
    <?php endif; ?>

    <div <?php echo $this->get_render_attribute_string('portfolio-content'); ?>>
        <div class="d-flex justify-between items-center">
            <div class="chk-portfolio-item__content-wrapper">
                <?php if ($settings['show_cat'] === 'true') : ?>
                    <span class="chk-portfolio-item__cat transition-all">
                        <?php if (!empty($terms)) {
                            echo $categories_string;
                        } ?>
                    </span>
                <?php endif; ?>

                <?php
                echo "<{$title_tag} class=\"{$title_class}\">";
                echo "<a href=\"{$url}\" class='text-current transition-all'>";
                echo $title;
                echo "</a>";
                echo "</{$title_tag}>";
                ?>
            </div>
            <div class="chk-portfolio-item__readmore">
                <a href="<?php echo $url; ?>" class='text-current transition-all'>
                    <?php echo (is_rtl() ? '<i class="ti-arrow-large-left"></i>' : '<i class="ti-arrow-large-right"></i>'); ?>
                </a>
            </div>
        </div>
    </div>
</article>