<?php

use Elementor\Icons_Manager;

defined('ABSPATH') or exit;
?>
<div class="chk-icon-box-1 chk-icon-box-1__s1 transition-all pos-relative z-1 overflow-hidden chk-bg-before elementor-repeater-item-<?php echo $item['_id'] ?>">
    <div class="chk-icon-box-1__wrap pos-relative z-1">
        <?php if ($item['icon_type'] != 'none') : ?>
            <div class="chk-icon-box-1__icon pos-relative if-center chk-bg-before transition-all z-1">
                <?php if ($item['icon_type'] == 'font') {
                    Icons_Manager::render_icon($item['icon_font'], [
                        'aria-hidden' => 'true',
                        'class' => 'pos-relative'
                    ]);
                } ?>
                <?php if ($item['icon_type'] == 'image') { ?>
                    <img src="<?php echo esc_attr($item['icon_image']['url']); ?>" alt="icon-<?php echo $item['_id']
                    ?>" class="pos-relative z-1 max-w-full h-auto">
                <?php } ?>
            </div>
        <?php endif; ?>

        <div class="chk-icon-box-1__content pos-relative z-1">
            <?php

            //title
            if (!empty($item['title'])) {
                $title_tag = $settings['title_tag'];
                $title_class = 'chk-icon-box-1__title';
                echo "<{$title_tag} class=\"{$title_class}\">";
                Chakavak_Controls_Elementor::render_start_link($this, $item['link'], 'd-inline-block transition-all');
                echo esc_html($item['title']);
                Chakavak_Controls_Elementor::render_end_link($this, $item['link']);
                echo "</{$title_tag}>";
            }

            //subtitle
            if (!empty($item['subtitle'])) {
                $subtitle_tag = $settings['subtitle_tag'];
                $subtitle_class = 'chk-icon-box-1__subtitle';
                echo "<{$subtitle_tag} class=\"{$subtitle_class}\">";
                echo esc_html($item['subtitle']);
                echo "</{$subtitle_tag}>";
            }

            //desc
            if (!empty($item['desc'])) {
                $desc_class = 'chk-icon-box-1__desc';
                echo "<p class=\"{$desc_class}\">";
                echo wp_kses_post($item['desc']);
                echo "</p>";
            }

            ?>
        </div>
    </div>
    <?php if ($settings['sw_button'] && !empty($item['link']['url'])) { ?>
        <div class="mt-auto pos-relative z-1">
            <div class="chk-icon-box-1__button">
                <?php
                Chakavak_Controls_Elementor::render_start_link($this, $item['link'], 'if-center transition-all');
                echo '<span class="if-center">';
                echo esc_html($settings['text_button']);
                echo(is_rtl() ? '<i class="ti-arrow-large-left"></i>' : '<i class="ti-arrow-large-right"></i>');
                echo '</span>';
                Chakavak_Controls_Elementor::render_end_link($this, $item['link']);
                ?>
            </div>
        </div>
    <?php } ?>
</div>