<?php

namespace Elementor;

use Chakavak_main_nav_walker;

defined('ABSPATH') or exit;

/**
 * Widget Name: vertical Menu
 */
class Chakavak_verticalMenu extends Widget_Base
{
    const NAME = 'chk_vmenu';
    const CATEGORY = 'chakavak_header_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Vertical menu', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-select';
    }

    public function get_keywords()
    {
        return ['menu', 'nav', esc_html__('vertical menu', 'chakavak')];
    }

    public function get_script_depends()
    {
        return ['jquery'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('vertical menu', 'chakavak'),
            ]
        );

        $menus = $this->get_available_menus();

        $this->add_control(
            'nav_menu',
            [
                'label' => esc_html__('Select menu', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'multiple' => false,
                'options' => $menus,
                'default' => array_keys($menus)[0],
                'save_default' => true,

            ]
        );

        $this->end_controls_section();

        /*** Style ***/
        $this->start_controls_section(
            'style_mmenu_section',
            [
                'label' => __('Menu content', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        //Menu Items
        $this->add_control(
            'heading_menu_item',
            [
                'label' => __('Menu items', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'mmenu_typography',
                'selector' => '{{WRAPPER}} .chk-vmenu__items ul li a ,{{WRAPPER}} .chk-vmenu__items>li>a',
            ]
        );

        $this->add_control(
            'mmenu_border_color',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-vmenu__items > li' => 'border-bottom-color:{{VALUE}}',
                    '{{WRAPPER}} .chk-vmenu__items ul >li' => 'border-bottom-color:{{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'mmenu_link_color',
            [
                'label' => __('Link color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-vmenu__items > li > a' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-vmenu__items ul li a' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-vmenu__items > li.menu-item-has-children' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-vmenu__items  ul > li.menu-item-has-children' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'mmenu_link_color_hover',
            [
                'label' => __('Link color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-vmenu__items > li > a:hover' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-vmenu__items ul li a:hover' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-vmenu__items ul li.show-submenu' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-vmenu__items > li.show-submenu > a' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-vmenu__items ul li.show-submenu > a' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-vmenu__items>li.show-submenu' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->end_controls_section();

    }

    protected function get_available_menus()
    {

        $menus = wp_get_nav_menus();
        $options = [];
        foreach ($menus as $menu) {
            $options[$menu->slug] = $menu->name;
        }

        return $options;
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element lh-1">
            <div class="chk-vmenu">
                <nav class="chk-vmenu__nav">
                    <?php
                    $menu_class = 'chk-vmenu__items list-none p-0 m-0';
                    wp_nav_menu(array(
                        'menu' => $settings['nav_menu'],
                        'menu_class' => $menu_class,
                        'container' => '',
                        'fallback_cb' => 'wp_page_menu',
                    ));
                    ?>
                </nav>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_verticalMenu());
