<?php

namespace Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Sidepanel
 */
class Chakavak_SidePanel extends Widget_Base
{
    const NAME = 'chk_sidepanel';
    const CATEGORY = 'chakavak_header_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Side Panel', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-sidebar';
    }

    public function get_keywords()
    {
        return ['side panel', 'canvas', esc_html__('Side Panel', 'chakavak')];
    }

    public function get_script_depends()
    {
        return ['jquery'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'style_toggle',
            [
                'label' => __('Toggle icon', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'toggle_size',
            [
                'label' => __('Toggle font size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-sidepanel__btn' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'toggle_bg_size',
            [
                'label' => __('Background size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 20,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-sidepanel__btn' => 'width: {{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'toggle_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-sidepanel__btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('toggle_tabs');

        $this->start_controls_tab(
            'toggle_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'toggle_color_normal',
            [
                'label' => __('Toggle color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-sidepanel__btn' => 'color: {{VALUE}};',
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'toggle_bg_normal',
                'label' => esc_html__('Toggle background color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-sidepanel__btn',

            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'toggle_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'toggle_color_hover',
            [
                'label' => __('Toggle color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-sidepanel__btn:is(:hover,:focus)' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'toggle_bg_hover',
                'label' => esc_html__('Toggle background color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-sidepanel__btn:before',

            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'style_sidepanel',
            [
                'label' => __('Side panel', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'bg_overlay_panel',
            [
                'label' => __('Overlay backgroud color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.chk-sidepanel__overlay' => 'background: {{VALUE}};',
                ]
            ]
        );

        /*Button Submit */
        $this->add_control(
            'panel_heading',
            [
                'label' => __('Body', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'bg_panel',
            [
                'label' => __('Side panel background', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.chk-sidepanel__wrapper' => 'background: {{VALUE}};',
                ]
            ]
        );

        $this->add_responsive_control(
            'panel_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-sidepanel__content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        /*Button Submit */
        $this->add_control(
            'close_heading',
            [
                'label' => __('Close', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs('close_tabs');

        $this->start_controls_tab(
            'close_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'close_color_normal',
            [
                'label' => __('Color default', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.chk-sidepanel__close' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'close_bgcolor_normal',
            [
                'label' => __('Background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.chk-sidepanel__close' => 'background-color: {{VALUE}};',
                ]
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'close_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'close_color_hover',
            [
                'label' => __('Color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.chk-sidepanel__close:is(:hover,:focus)' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'close_bgcolor_hover',
            [
                'label' => __('Background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.chk-sidepanel__close:is(:hover,:focus)' => 'background-color: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'style_sticky_toggle_section',
            [
                'label' => __('Sticky toggle', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('toggle_sticky_tabs');

        $this->start_controls_tab(
            'toggle_sticky_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'toggle_sticky_color_normal',
            [
                'label' => __('Toggle color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .scrolled .chk-sidepanel__btn' => 'color: {{VALUE}};',
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'toggle_sticky_bg_normal',
                'label' => esc_html__('Toggle background color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .scrolled .chk-sidepanel__btn',

            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'toggle_sticky_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'toggle_sticky_color_hover',
            [
                'label' => __('Toggle color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .scrolled .chk-sidepanel__btn:is(:hover,:focus)' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'toggle_sticky_bg_hover',
                'label' => esc_html__('Toggle background color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .scrolled .chk-sidepanel__btn:before',

            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div class="chk-sidepanel chk-header-item">
                <button id="chk-sidepanel-btn" class="chk-sidepanel__btn if-center chk-bg-before pos-relative">
                    <i class="ti-apps pos-relative z-1 d-inline-block"></i>
                </button>
                <div id="chk-sidepanel-overlay" class="chk-site-overlay chk-sidepanel__overlay"></div>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_SidePanel());
