<?php

namespace Elementor;

use Chakavak_Controls_Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Simple Image box 1
 */
class chakavak_Simple_Image_box_1 extends Widget_Base
{
    const NAME = 'chk_simgle_image_box_1';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Simple Image box 1', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-image';
    }

    public function get_keywords()
    {
        return ['image', 'box', __('image box', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-simple-image-box-1'];
    }

    public function get_script_depends()
    {
        return [];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Image Box', 'chakavak'),
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => esc_html__('Image', 'chakavak'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => CHAKAVAK_ELEMENTOR_ASSETS . 'images/placeholder.webp',
                ]
            ]
        );

        Chakavak_Controls_Elementor::image_size($this, 'image_size', null);

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Business Consultant', 'chakavak'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title Tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h3',
                'condition' => [
                    'title!' => '',
                ]
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => __('Link', 'chakavak'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'chakavak'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'button_heading',
            [
                'label' => esc_html__('Button', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'link[url]!' => '',
                ]
            ]
        );

        $this->add_control(
            'button_sw',
            [
                'label' => esc_html__('Show button', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'label_off' => esc_html__('Off', 'chakavak'),
                'label_on' => esc_html__('On', 'chakavak'),
                'return_value' => 'yes',
                'condition' => [
                    'link[url]!' => '',
                ]
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => esc_html__('Label', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('View Demo', 'chakavak'),
                'condition' => [
                    'link[url]!' => '',
                    'button_sw' => 'yes',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->end_controls_section();

        //Item Style
        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'exclude' => ['color'],
                'fields_options' => [
                    'border' => [
                        'default' => 'solid',
                    ],
                    'width' => [
                        'default' => [
                            'top' => '1',
                            'right' => '1',
                            'bottom' => '1',
                            'left' => '1',
                            'isLinked' => true,
                        ]
                    ],
                ],
                'selector' => '{{WRAPPER}} .chk-simple-image-box-1',
            ]
        );

        $this->start_controls_tabs('item_tabs');

        $this->start_controls_tab(
            'item_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow_normal',
                'fields_options' => [
                    'box_shadow_type' =>
                    [
                        'default' => 'yes'
                    ],
                    'box_shadow' => [
                        'default' =>
                        [
                            'horizontal' => 5,
                            'vertical' => 8,
                            'blur' => 15,
                            'spread' => 0,
                            'color' => 'rgba(var(--chk-c-black-rgb), 0.08)'
                        ]
                    ]
                ],
                'selector' => '{{WRAPPER}} .chk-simple-image-box-1',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_normal',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-simple-image-box-1',

            ]
        );

        $this->add_control(
            'item_border_color_normal',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => 'var(--chk-c-gray-200)',
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1' => 'color:{{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'item_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow_hover',
                'selector' => '{{WRAPPER}} .chk-simple-image-box-1:hover',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_hover',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-simple-image-box-1:before',

            ]
        );

        $this->add_control(
            'item_border_color_hover',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => 'var(--chk-c-primary)',
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1:hover' => 'color:{{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'image_style',
            [
                'label' => esc_html__('Image', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'image_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1__image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .chk-simple-image-box-1__image::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        //title
        $this->add_control(
            'image_overlay_heading',
            [
                'label' => __('Image Overlay', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'overlay_bg',
            [
                'label' => esc_html__('Background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1__image::before' => 'background-color:{{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'overlay_opacity',
            [
                'label' => esc_html__('Opacity', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['custom'],
                'range' => [
                    'custom' => [
                        'min' => 0,
                        'max' => 1,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1:hover .chk-simple-image-box-1__image::before' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //Button
        $this->start_controls_section(
            'button_style',
            [
                'label' => __('Button', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'button_sw' => 'yes',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .chk-simple-image-box-1__button-link ',
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1__button-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1__button-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('button_tabs');

        $this->start_controls_tab(
            'button_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1__button-link' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'button_bg_color',
            [
                'label' => __('Background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1__button-link' => 'background-color:{{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'button_color_hover',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1__button-link:hover' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'button_bg_color_hover',
            [
                'label' => __('Background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1__button-link:hover' => 'background-color:{{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


        $this->start_controls_section(
            'title_style',
            [
                'label' => __('Title', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1__title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_alignment',
            [
                'label' => esc_html__('Text align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1__title' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .chk-simple-image-box-1__title',
            ]
        );

        $this->add_control(
            'title_color_normal',
            [
                'label' => esc_html__('Title color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1__title' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'title_color_hover',
            [
                'label' => esc_html__('Title color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1:hover .chk-simple-image-box-1__title' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $button_text = $settings['button_text'] ? $settings['button_text'] : esc_html__('View Demo', 'chakavak');

?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div class="chk-simple-image-box-1 pos-relative chk-bg-before z-1 transition-all overflow-hidden h-full">
                <?php if ($settings['image']['url']) :
                    $alt_img = '';
                    if (!empty($settings['title'])) {
                        $alt_img = esc_html($settings['title']);
                    } else {
                        $alt_img = 'image-' . $settings['_id'];
                    }
                    $image_id = $settings['image']['id'];
                    $image_size = $settings['image_size_size'];
                    $image_custom_dimension = $settings['image_size_custom_dimension'];
                    if ($image_size === 'custom') {
                        $image_src = wp_get_attachment_image_src($image_id, $image_custom_dimension);
                    } else {
                        $image_src = wp_get_attachment_image_src($image_id, $image_size);
                    }
                ?>
                    <div class="chk-simple-image-box-1__image pos-relative">
                        <?php if (!empty($settings['link']['url']) && $settings['button_sw']) : ?>
                            <div class="chk-simple-image-box-1__button">
                                <?php Chakavak_Controls_Elementor::render_start_link($this, $settings['link'], 'chk-simple-image-box-1__button-link transition-all'); ?>
                                <?php echo esc_html($button_text); ?>
                                <?php Chakavak_Controls_Elementor::render_end_link($this, $settings['link']); ?>
                            </div>
                        <?php endif; ?>
                        <?php
                        if ($image_src) {
                            $image_url = $image_src[0];
                            $image_width = $image_src[1];
                            $image_height = $image_src[2];
                            echo '<img src="' . esc_url($image_url) . '" alt="' . $alt_img . '" width="' . esc_attr($image_width) . '" height="' . esc_attr($image_height) . '" class="w-full h-auto d-block overflow-hidden transition-all">';
                        }
                        ?>
                    </div>
                <?php endif; ?>

                <?php
                //title
                if (!empty($settings['title'])) {
                    $title_tag = $settings['title_tag'];
                    $title_class = 'chk-simple-image-box-1__title pos-relative transition-all';
                    echo "<{$title_tag} class=\"{$title_class}\">";
                    Chakavak_Controls_Elementor::render_start_link($this, $settings['link'], 'd-inline-block text-current');
                    echo esc_html($settings['title']);
                    Chakavak_Controls_Elementor::render_end_link($this, $settings['link']);
                    echo "</{$title_tag}>";
                }
                ?>
            </div>
        </div>
<?php
    }

    protected function content_template() {}
}

Plugin::instance()->widgets_manager->register(new chakavak_Simple_Image_box_1());
