<?php

namespace Elementor;

use Chakavak_Controls_Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Simple Icon box 1
 */
class chakavak_Simple_Icon_box_1 extends Widget_Base
{
    const NAME = 'chk_simgle_icon_box_1';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Simple Icon box 1', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-settings';
    }

    public function get_keywords()
    {
        return ['icon', 'box', __('icon box', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-simple-icon-box-1'];
    }

    public function get_script_depends()
    {
        return [];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Icon Box', 'chakavak'),
            ]
        );

        $this->add_control(
            'icon_type',
            [
                'label' => __('Icon Type', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 'font',
                'options' => [
                    'font' => __('Font Icon', 'chakavak'),
                    'image' => __('Image Icon', 'chakavak'),
                ]
            ]
        );

        $this->add_control(
            'icon_font',
            [
                'label' => __('Icon', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'ti-business',
                    'library' => 'theme-icons',
                ],
                'condition' => [
                    'icon_type' => 'font',
                ]
            ]
        );

        $this->add_control(
            'icon_image',
            [
                'label' => esc_html__('Image', 'chakavak'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => CHAKAVAK_ELEMENTOR_ASSETS . 'images/icon.png',
                ],
                'condition' => [
                    'icon_type' => 'image',
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('UI/UX Design', 'chakavak'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title Tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h3',
                'condition' => [
                    'title!' => '',
                ]
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => __('Link', 'chakavak'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => 'https://your-link.com',
            ]
        );

        $this->end_controls_section();

        //Item Style
        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_align',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_horizontal_position(),
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-icon-box-1' => 'align-items: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-icon-box-1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-icon-box-1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'exclude' => ['color'],
                'fields_options' => [
                    'border' => [
                        'default' => 'solid',
                    ],
                    'width' => [
                        'default' => [
                            'top' => '1',
                            'right' => '1',
                            'bottom' => '1',
                            'left' => '1',
                            'isLinked' => true,
                        ]
                    ],
                ],
                'selector' => '{{WRAPPER}} .chk-simple-icon-box-1',
            ]
        );

        $this->start_controls_tabs('item_tabs');

        $this->start_controls_tab(
            'item_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow_normal',
                'selector' => '{{WRAPPER}} .chk-simple-icon-box-1',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_normal',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-simple-icon-box-1',

            ]
        );

        $this->add_control(
            'item_border_color_normal',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => 'var(--chk-c-gray-300)',
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-icon-box-1' => 'color:{{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'item_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow_hover',
                'selector' => '{{WRAPPER}} .chk-simple-icon-box-1:hover',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_hover',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-simple-icon-box-1:before',

            ]
        );

        $this->add_control(
            'item_border_color_hover',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => 'var(--chk-c-primary)',
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-icon-box-1:hover' => 'color:{{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'image_style',
            [
                'label' => esc_html__('Image', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__('Icon Size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 400,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-icon-box-1__icon' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-simple-icon-box-1__icon img' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-simple-icon-box-1__icon svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_space_bottom',
            [
                'label' => esc_html__('Margin bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 0.1,
                    ],
                ],
                'condition' => [
                    'style' => 's1',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-icon-box-1__icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_color_normal',
            [
                'label' => esc_html__('Icon color normal', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-icon-box-1__icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-simple-icon-box-1__icon svg' => 'fill: {{VALUE}};',
                ],
                'condition' => [
                    'icon_type' => 'font',
                ],
            ]
        );

        $this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__('Icon color normal', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-icon-box:hover .chk-simple-icon-box-1__icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-simple-icon-box:hover .chk-simple-icon-box-1__icon svg' => 'fill: {{VALUE}};',
                ],
                'condition' => [
                    'icon_type' => 'font',
                ],
            ]
        );

        $this->add_control(
            'image_hover_effect',
            [
                'label' => esc_html__('Hover Effect', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => esc_html__('None', 'chakavak'),
                    'zoom' => esc_html__('Zoom', 'chakavak'),
                    'grayscale' => esc_html__('Grayscale', 'chakavak')
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'image_filters_normal',
                'label' => esc_html__('Image effect normal', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-simple-icon-box-1__icon img',
                'condition' => [
                    'icon_type' => 'image',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'image_filters_hover',
                'label' => esc_html__('Image effect normal', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-simple-icon-box-1:hover .chk-simple-icon-box-1__icon img',
                'condition' => [
                    'icon_type' => 'image',
                ],
            ]
        );

        $this->end_controls_section();

        //Button

        $this->start_controls_section(
            'title_style',
            [
                'label' => __('Title', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .chk-simple-icon-box-1__title',
            ]
        );

        $this->add_control(
            'title_color_normal',
            [
                'label' => esc_html__('Title color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-icon-box-1__title' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'title_color_hover',
            [
                'label' => esc_html__('Title color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-simple-image-box-1:hover .chk-simple-image-box-1__title' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div class="chk-simple-icon-box-1 pos-relative chk-bg-before z-1 transition-all overflow-hidden">
                <?php if ($settings['icon_type'] == 'font' || $settings['icon_type'] == 'image') : ?>
                    <div class="chk-simple-icon-box-1__icon pos-relative chk-effect-<?php echo $settings['image_hover_effect']; ?>">
                        <?php if ($settings['icon_type'] == 'font') {
                            Icons_Manager::render_icon($settings['icon_font'], [
                                'aria-hidden' => 'true',
                                'class' => 'pos-relative'
                            ]);
                        } ?>

                        <?php if ($settings['icon_type'] == 'image') { ?>
                            <img src="<?php echo esc_attr($settings['icon_image']['url']); ?>" alt="icon" class="pos-relative z-1">
                        <?php } ?>

                    </div>
                <?php endif; ?>
                <?php
                //title
                if (!empty($settings['title'])) {
                    $title_tag = $settings['title_tag'];
                    $title_class = 'chk-simple-icon-box-1__title pos-relative transition-all';
                    echo "<{$title_tag} class=\"{$title_class}\">";
                    Chakavak_Controls_Elementor::render_start_link($this, $settings['link'], 'd-inline-block text-current');
                    echo esc_html($settings['title']);
                    Chakavak_Controls_Elementor::render_end_link($this, $settings['link']);
                    echo "</{$title_tag}>";
                }
                ?>
            </div>
        </div>
<?php
    }

    protected function content_template() {}
}

Plugin::instance()->widgets_manager->register(new chakavak_Simple_Icon_box_1());
