<?php

namespace Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Progress Bar
 */
class chakavak_Progress_Bar extends Widget_Base
{
    const NAME = 'chk_progress_bar';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Progress Bar', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-skill-bar';
    }

    public function get_keywords()
    {
        return ['progress bar', 'progress', 'circle', 'percent', 'skill', esc_html__('progress bar', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-progress-bar'];
    }

    public function get_script_depends()
    {
        return [
            'easypiechart',
            'chk-widgets',
        ];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'bar_style',
            [
                'label' => __('Bar Style', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 'line',
                'options' => [
                    'line' => __('Style 1: Line', 'chakavak'),
                    'circle' => __('Style 2: Circle', 'chakavak'),
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('Keyword Research', 'chakavak'),
                'placeholder' => esc_html__('Enter a Title', 'chakavak'),
            ]
        );

        $this->add_control(
            'percent',
            [
                'label' => __('Percentage', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 70,
                    'unit' => '%',
                ],
            ]
        );

        $this->add_control(
            'percent_sw',
            [
                'label' => esc_html__('Show Percentage', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'percent_end',
            [
                'label' => esc_html__('Percent at end?', 'chakavak'),
                'description' => esc_html__('Is the percentage position at the end?', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'condition' => [
                    'bar_style' => 'line',
                    'percent_sw' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'circle_title_onside',
            [
                'label' => esc_html__('Title on side', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'condition' => [
                    'bar_style' => 'circle',
                ]
            ]
        );

        $this->add_control(
            'circle_align_title_onside',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'chakavak'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'chakavak'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'chakavak'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .chk-progress__circle-wrap' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'circle_title_onside!' => 'yes',
                    'bar_style' => 'circle',
                ]
            ]
        );

        $this->add_control(
            'circle_align_title_bottom',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => 'center',
                'selectors_dictionary' => [
                    'left' => 'flex-end',
                    'right' => 'flex-start',
                    'center' => 'center',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-progress__circle-wrap' => 'justify-content: {{VALUE}};',
                ],
                'condition' => [
                    'circle_title_onside!' => 'no',
                    'bar_style' => 'circle',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'bar_style_section',
            [
                'label' => __('Progress Bar', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'circle_bar_color',
            [
                'label' => __('Line color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => 'var(--chk-c-primary)',
                'condition' => [
                    'bar_style' => 'circle',
                ]
            ]
        );

        $this->add_control(
            'line_bar_color',
            [
                'label' => __('Line color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => 'var(--chk-c-primary)',
                'condition' => [
                    'bar_style' => 'line',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-pline-size' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'circle_bar_height',
            [
                'label' => __('Height line bar', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 3,
                    'unit' => 'px',
                ],
                'condition' => [
                    'bar_style' => 'circle',
                ]
            ]
        );

        $this->add_control(
            'line_bar_height',
            [
                'label' => __('Height line bar', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'condition' => [
                    'bar_style' => 'line',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-pline-bar' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-pline-bar:after' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'circle_bar_size',
            [
                'label' => __('Size bar', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
                'default' => [
                    'size' => 120,
                ],
                'condition' => [
                    'bar_style' => 'circle',
                ]
            ]
        );

        $this->add_control(
            'bg_line_color',
            [
                'label' => __('Background line color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-pline-bar:after' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .chk-pcircle-bar:after' => 'border-color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'circle_bg_height',
            [
                'label' => __('Height background bar', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'condition' => [
                    'bar_style' => 'circle',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-pcircle-bar:after' => 'border-width:{{SIZE}}{{UNIT}};',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_text_section',
            [
                'label' => __('Text', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        //Title
        $this->add_control(
            'heading_title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .chk-ptitle',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-ptitle' => 'color: {{VALUE}};',
                ]
            ]
        );

        //Percentage
        $this->add_control(
            'heading_percent',
            [
                'label' => __('Percentage', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'percent_color',
            [
                'label' => __('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-pnumber' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-pcircle-bar span' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'percent_typography',
                'selector' => '{{WRAPPER}} .chk-pnumber , {{WRAPPER}} .chk-pcircle-bar span',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $this->add_render_attribute('pline-header', 'class', [
            'chk-pline-header',
            'd-flex',
            'items-center',
            'pos-relative',
            ($settings['percent_end'] == 'yes') ? 'justify-between' : 'justify-start',
        ]);
?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">

            <?php if ($settings['bar_style'] == 'line') : ?>
                <div class="chk-progress__line">
                    <div <?php echo $this->get_render_attribute_string('pline-header'); ?>>
                        <?php if ($settings['title']) {
                            echo '<span class="chk-ptitle">' . $settings['title'] . '</span>';
                        } ?>
                        <?php if ($settings['percent_sw']) {
                            echo '<span class="chk-pnumber">' . $settings['percent']['size'] . '%</span>';
                        } ?>
                    </div>

                    <div class="chk-pline-bar pos-relative overflow-hidden">
                        <div class="chk-pline-size h-full z-1 pos-relative" data-percent="<?php echo esc_attr($settings['percent']['size']) . '%'; ?>"></div>
                    </div>

                </div>
            <?php else :
                $this->add_render_attribute('pcircle-wrap', 'class', [
                    'chk-progress__circle-wrap',
                    'pos-relative',
                    'd-flex',
                    'z-1',
                    ($settings['circle_title_onside'] == 'yes') ? 'pcircle-title-onslide flex-row' : 'pcircle-title-bottom flex-col',
                ]);
            ?>

                <div <?php echo $this->get_render_attribute_string('pcircle-wrap'); ?>>
                    <div class="chk-progress__circle" data-color="<?php echo esc_attr($settings['circle_bar_color']); ?>" data-height="<?php echo esc_attr($settings['circle_bar_height']['size']); ?>" data-size="<?php echo esc_attr($settings['circle_bar_size']['size']); ?>">
                        <div class="chk-pcircle-bar" data-percent="<?php echo esc_attr($settings['percent']['size']); ?>">
                            <?php if ($settings['percent_sw']) {
                                echo '<span><span class="chk-pcircle-percent">' . $settings['percent']['size'] . '</span>%</span>';
                            } ?>
                        </div>
                    </div>
                    <?php if ($settings['title']) {
                        echo '<span class="chk-ptitle">' . $settings['title'] . '</span>';
                    } ?>
                </div>
            <?php endif; ?>
        </div>

<?php
    }

    protected function content_template() {}
}

Plugin::instance()->widgets_manager->register(new chakavak_Progress_Bar());
