<?php

namespace Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name:  marquee Slider
 */
class chakavak_marqueeSlider extends Widget_Base
{
    const NAME = 'chk_marquee_slider';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Marquee text slider', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-slider-push';
    }

    public function get_keywords()
    {
        return ['marquee', 'slider', 'text marquee', __('marquee text', 'chakavak')];
    }

    public function get_script_depends()
    {
        return [''];
    }

    public function get_style_depends()
    {
        return ['chk-marquee-slider'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'general_settings',
            [
                'label' => __('General Settings', 'chakavak'),
            ]
        );

        $this->add_control(
            'marquee_second_bg',
            [
                'label' => __('Second BG', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'chakavak'),
                'no' => __('no', 'chakavak'),
            ]
        );

        $this->add_control(
            'marquee_paused',
            [
                'label' => __('Hover Paused', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'chakavak'),
                'no' => __('no', 'chakavak'),
            ]
        );

        $this->add_responsive_control(
            'slider_position',
            [
                'label' => __('Slider Position', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'chk-position-left' => [
                        'title' => __('Left', 'chakavak'),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'chk-position-right' => [
                        'title' => __('Right', 'chakavak'),
                        'icon' => 'eicon-h-align-right',
                    ]
                ]
            ]
        );

        $this->add_responsive_control(
            'marquee_slide_space',
            [
                'label' => __('Padding top & bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'separator' => 'before',
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-marquee-slider__inner' => 'padding: {{SIZE}}{{UNIT}} 0;',
                ],
            ]
        );

        $this->add_responsive_control(
            'marquee_item_gap',
            [
                'label' => __('Item Space between', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-marquee-slide' => 'gap: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-marquee-slider__inner' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('* SEO Consulting', 'chakavak'),
                'placeholder' => __('Enter title', 'chakavak'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'marquee_items',
            [
                'label' => __('Slide Items', 'chakavak'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{title}}}',
                'default' => [
                    [
                        'title' => esc_html__('*  Google Ads', 'chakavak'),
                    ],
                    [
                        'title' => esc_html__('* SEO Consulting', 'chakavak'),
                    ],
                    [
                        'title' => esc_html__('*  SEO Services', 'chakavak'),
                    ],
                    [
                        'title' => esc_html__('*  Website Services', 'chakavak'),
                    ],
                    [
                        'title' => esc_html__('*  Content Production', 'chakavak'),
                    ],
                    [
                        'title' => esc_html__('*  Graphic Design', 'chakavak'),
                    ],
                    [
                        'title' => esc_html__('*  Social Media Services', 'chakavak'),
                    ],
                ],
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h4',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_marquee',
            [
                'label' => __('Marquee Style', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title-typography',
                'label' => __('Title Typography', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-marquee__title',
            ]
        );

        $this->add_control(
            'marquee_slide_bg',
            [
                'label' => __('Marquee Slide BG', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'marquee_second_bg' => ['yes']
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-marquee-slider.slide-bg-on .chk-marquee-slider__inner:before' => 'background: {{VALUE}};',
                ],
            ],
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'marquee_background_color',
                'label' => __('Background Color', 'chakavak'),
                'types' => ['gradient'],
                'selector' => '{{WRAPPER}} .chk-marquee-slider__inner',
            ]
        );

        $this->add_control(
            'marquee_text_color',
            [
                'label' => __('Title Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-marquee__title' => 'color: {{VALUE}};',
                ],
            ]
        );
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $marquee_items = $this->get_settings_for_display('marquee_items');

        $this->add_render_attribute('marquee-slider', 'class', 'chk-marquee-slider ltr');
        $this->add_render_attribute('marquee-slider', 'class', $settings['slider_position']);
        if ($settings['marquee_second_bg'] == 'yes') {
            $this->add_render_attribute('marquee-slider', 'class', 'slide-bg-on');
        }
        if ($settings['marquee_paused'] == 'yes') {
            $this->add_render_attribute('marquee-slider', 'class', 'marquee-hover-paused');
        }
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div <?php echo $this->get_render_attribute_string('marquee-slider'); ?>>
                <div class="chk-marquee-slider__inner">

                    <div class="chk-marquee-slide">
                        <?php foreach ($marquee_items as $item) {
                            if (!empty($item['title'])) {
                                $direction_class = is_rtl() ? 'rtl' : 'ltr';
                                echo '<div class="chk-marquee-item">';
                                echo '<' . $settings['title_tag'] . ' ' . ' class="chk-marquee__title inline-block ' . $direction_class . '"' . '>';
                                echo $item['title'];
                                echo '</' . $settings['title_tag'] . '>';
                                echo '</div>';
                            };
                        } ?>
                    </div>

                    <div class="chk-marquee-slide">
                        <?php foreach ($marquee_items as $item) {
                            if (!empty($item['title'])) {
                                $direction_class = is_rtl() ? 'rtl' : 'ltr';
                                echo '<div class="chk-marquee-item">';
                                echo '<' . $settings['title_tag'] . ' ' . ' class="chk-marquee__title inline-block ' . $direction_class . '"' . '>';
                                echo $item['title'];
                                echo '</' . $settings['title_tag'] . '>';
                                echo '</div>';
                            };
                        } ?>
                    </div>

                </div>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new chakavak_marqueeSlider());
