<?php

namespace Elementor;
defined('ABSPATH') or exit;

/**
 * Widget Name: Image
 */
class Chakavak_Image extends Widget_Base
{
    const NAME = 'chk_image';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Image', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-image';
    }

    public function get_keywords()
    {
        return ['image', esc_html__('Image', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-elementor-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'image_section',
            [
                'label' => esc_html__('Image Setting', 'chakavak'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        \Chakavak_Controls_Elementor::select_image($this, 'select_image', null);
        \Chakavak_Controls_Elementor::image_size($this, 'image_size', null);

        $this->add_responsive_control(
            'align_image',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-end' => [
                        'title' => __('Left', 'chakavak'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'chakavak'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-start' => [
                        'title' => __('Right', 'arvawp'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk_image-element' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => __('Link', 'chakavak'),
                'type' => Controls_Manager::URL,
                'placeholder' => 'https://your-link.com',

            ]
        );

        $this->add_control(
            'animate',
            [
                'label' => esc_html__('Image Animation', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'none' => esc_html__('None ', 'chakavak'),
                    'movement-y' => esc_html__('Top / Bottom ', 'chakavak'),
                    'movement-x' => esc_html__('Left / Right', 'chakavak'),
                ],
                'default' => 'none',
            ]
        );

        $this->add_control(
            'animate_duration',
            [
                'label' => esc_html__('Animation duration', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => esc_html__('1s', 'chakavak'),
                    '2' => esc_html__('2s', 'chakavak'),
                    '3' => esc_html__('3s', 'chakavak'),
                    '4' => esc_html__('4s', 'chakavak'),
                    '5' => esc_html__('5s', 'chakavak'),
                ],
                'default' => '3',
                'condition' => [
                    'animate!' => 'none'
                ]
            ]
        );

        $this->add_control(
            'image_content_heading',
            [
                'label' => esc_html__('Box Content', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'box_sw',
            [
                'label' => __('Active content box', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'chakavak'),
                'label_off' => __('No', 'chakavak'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h4',
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'box_sw' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'box_title',
            [
                'label' => esc_html__('Title', 'chakavak'),
                'label_block' => true,
                'rows' => '2',
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Enter Title', 'chakavak'),
                'default' => esc_html__('This is sample title', 'chakavak'),
                'condition' => [
                    'box_sw' => 'yes',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'box_subtitle',
            [
                'label' => esc_html__('Subtitle', 'chakavak'),
                'label_block' => true,
                'rows' => '2',
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Subtitle', 'chakavak'),
                'default' => esc_html__('This is sample Subtitle', 'chakavak'),
                'condition' => [
                    'box_sw' => 'yes',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_responsive_control(
            'top_position',
            [
                'label' => __('Top Position (%)', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['%', 'px'],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'condition' => [
                    'box_sw' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-image__content' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'right_position',
            [
                'label' => __('Right Position (%)', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['%', 'px'],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'condition' => [
                    'box_sw' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-image__content' => 'right: {{SIZE}}%;',
                ],
            ]
        );

        $this->add_responsive_control(
            'bottom_position',
            [
                'label' => __('Bottom Position (%)', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['%', 'px'],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => '10',
                ],
                'condition' => [
                    'box_sw' => 'yes',
                ],

                'selectors' => [
                    '{{WRAPPER}} .chk-image__content' => 'bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'left_position',
            [
                'label' => __('Left Position (%)', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['%', 'px'],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => '10',
                ],
                'condition' => [
                    'box_sw' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-image__content' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //Style
        $this->start_controls_section(
            'style_image',
            [
                'label' => __('Image', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'width_image',
            [
                'label' => __('Image Width', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['%', 'px'],
                'default' => [
                    'unit' => '%',
                ],
                'tablet_default' => [
                    'unit' => '%',
                ],
                'mobile_default' => [
                    'unit' => '%',
                ],
                'range' => [
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 2000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-image' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
                'description' => esc_html__('NOTE:The height is created automatically according to the width of the image.', 'chakavak'),
            ]
        );

        $this->start_controls_tabs('image_effects');
        $this->start_controls_tab(
            'normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );
        $this->add_control(
            'opacity',
            [
                'label' => __('Opacity', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-image img' => 'opacity: {{SIZE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'css_filters',
                'selector' => '{{WRAPPER}} .chk-image img',
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );
        $this->add_control(
            'opacity_hover',
            [
                'label' => __('Opacity', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-image:hover img' => 'opacity: {{SIZE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'css_filters_hover',
                'selector' => '{{WRAPPER}} .chk-image:hover img',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'image_border',
                'selector' => '{{WRAPPER}} .chk-image img',
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'image_border_radius',
            [
                'label' => __('Border Radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_box_shadow',
                'exclude' => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .chk-image img',
            ]
        );
        $this->end_controls_section();
        //box
        $this->start_controls_section(
            'style_box',
            [
                'label' => __('Box', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'box_sw' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_width',
            [
                'label' => __('Width', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'max' => 500,
                        'min' => 50,
                        'step' => 1,
                    ],
                    '%' => [
                        'max' => 100,
                        'min' => 5,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-image__content' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_border_radius',
            [
                'label' => __('Border Radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-image__content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'box_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .chk-image__content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'box_bg_color',
                'label' => esc_html__('Background Color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-image__content',

            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'selector' => '{{WRAPPER}} .chk-image__content',
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_box_shadow',
                'selector' => '{{WRAPPER}} .chk-image__content',
            ]
        );

        //title
        $this->add_control(
            'title_heading',
            [
                'label' => esc_html__('Title', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'box_title!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'box_title_typography',
                'selector' => '{{WRAPPER}} .chk-image__content-title',
                'condition' => [
                    'box_title!' => '',
                ],
            ]
        );

        $this->add_control(
            'box_title_color',
            [
                'label' => esc_html__('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-image__content-title' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'box_title!' => '',
                ],
            ]
        );

        //subtitle
        $this->add_control(
            'subtitle_heading',
            [
                'label' => esc_html__('subtitle', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'box_subtitle!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'box_subtitle_typography',
                'selector' => '{{WRAPPER}} .chk-image__content-subtitle',
                'condition' => [
                    'box_subtitle!' => '',
                ],
            ]
        );

        $this->add_control(
            'box_subtitle_color',
            [
                'label' => esc_html__('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-image__content-subtitle' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'subtitle_box!' => '',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        if (empty($settings['select_image']['url'])) {
            return;
        }
        $classes = [
            'chk-image',
            'pos-relative',
            'z-1',
            'animate-infinite',
            'animate-' . $settings['animate'],
        ];
        if ($settings['animate'] != 'none') {
            $classes[] = 'duration-' . $settings['animate_duration'];
        }
        $item_cls = implode(' ', $classes);
        $this->add_render_attribute('wrapper', 'class', $item_cls);
        $this->add_render_attribute('content', 'class', 'chk-image__content');
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>

                <?php if ($settings['box_sw']) { ?>
                    <div <?php echo $this->get_render_attribute_string('content'); ?>>

                        <?php if ($settings['box_title']) :
                            $this->add_render_attribute('title', 'class', 'chk-image__content-title');
                            echo '<' . $settings['title_tag'] . ' ' . $this->get_render_attribute_string('title') . '>';
                            echo $settings['box_title'];
                            echo '</' . $settings['title_tag'] . '>';
                        endif; ?>

                        <?php if ($settings['box_subtitle']) :
                            $this->add_render_attribute('subtitle', 'class', 'chk-image__content-subtitle');
                            echo '<p ' . $this->get_render_attribute_string('subtitle') . '>';
                            echo $settings['box_subtitle'];
                            echo '</p>';
                        endif; ?>

                    </div>
                <?php } ?>
                <figure>
                    <?php
                    \Chakavak_Controls_Elementor::render_start_link($this, $settings['link'], 'd-block');
                    echo Group_Control_Image_Size::get_attachment_image_html($settings, 'image_size', 'select_image');
                    \Chakavak_Controls_Elementor::render_end_link($this, $settings['link']);
                    ?>
                </figure>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Image());
