<?php

namespace Elementor;

use Chakavak_Controls_Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Image Box1 Carousel
 */
class Chakavak_Image_Box_Carousel_1 extends Widget_Base
{
    const NAME = 'chk_image_box_carousel_1';
    const CATEGORY = 'chakavak_widgets';

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_name()
    {
        return self::NAME;
    }

    public function get_title()
    {
        return esc_html__('Image box Carousel 1', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-posts-carousel';
    }

    public function get_keywords()
    {
        return ['image', 'box', esc_html__('carousel', 'chakavak'), esc_html__('image box', 'chakavak')];
    }

    public function get_style_depends()
    {
        return [
            'swiper-bundle',
            'chk-image-box-1',
        ];
    }

    public function get_script_depends()
    {
        return [
            'swiper-bundle',
            'chk-widgets'
        ];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Image box', 'chakavak'),
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__('Style', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    's1' => esc_html__('Style 1', 'chakavak'),
                ],
                'default' => 's1',
            ]
        );

        $this->add_control(
            'items_heading',
            [
                'label' => esc_html__('Items', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('UI/UX Design', 'chakavak'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'subtitle',
            [
                'label' => __('Subtitle', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Crafting Digital Experiences', 'chakavak'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__('Image', 'chakavak'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => CHAKAVAK_ELEMENTOR_ASSETS . 'images/placeholder.webp',
                ],
            ]
        );

        $repeater->add_control(
            'desc',
            [
                'label' => __('Description', 'chakavak'),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __('Build the product you need on time with an experienced team that uses a clear and effective design process.', 'chakavak'),
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => __('Link', 'chakavak'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => 'https://your-link.com',
                'default' => [
                    'url' => '#'
                ],
            ]
        );

        $this->add_control(
            'item_boxes',
            [
                'label' => __('Image boxes', 'chakavak'),
                'type' => Controls_Manager::REPEATER,
                'show_label' => false,
                'default' => [
                    [
                        'title' => esc_html__('Web Development', 'chakavak'),
                        'subtitle' => esc_html__('Creativity in Web Design', 'chakavak'),
                        'desc' => esc_html__('Create responsive, user-friendly websites that bring ideas to life and enhance online presence.', 'chakavak'),
                    ],
                    [
                        'title' => esc_html__('UI/UX Design', 'chakavak'),
                        'subtitle' => esc_html__('Designing Intuitive User Interfaces', 'chakavak'),
                        'desc' => esc_html__('Design user-friendly interfaces that prioritize ease, and an enjoyable experience for all users.', 'chakavak'),
                    ],
                    [
                        'title' => esc_html__('Digital Markting', 'chakavak'),
                        'subtitle' => esc_html__('Strategies for Online Growth', 'chakavak'),
                        'desc' => esc_html__('Boost your online presence with effective digital marketing strategies that engage and convert.', 'chakavak'),
                    ]
                ],
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{title}}}',
            ]
        );


        Chakavak_Controls_Elementor::image_size($this, 'image_size', null);

        Chakavak_Controls_Elementor::element_tag($this, 'title_tag', esc_html__('Title tag', 'chakavak'), 'h3');

        Chakavak_Controls_Elementor::element_tag($this, 'subtitle_tag', esc_html__('Subtitle Tag', 'chakavak'), 'h4');

        $this->add_control(
            'button_heading',
            [
                'label' => esc_html__('Button', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'button_sw',
            [
                'label' => esc_html__('Show button', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'label_off' => esc_html__('Off', 'chakavak'),
                'label_on' => esc_html__('On', 'chakavak'),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'button_label',
            [
                'label' => esc_html__('Button label', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Explore More', 'chakavak'),
                'condition' => [
                    'button_sw' => 'yes',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->end_controls_section();

        Chakavak_Controls_Elementor::add_control_carousel($this, false);

        //Item Style
        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('Item body', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .chk-image-box-1',
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_normal',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-image-box-1',
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'label' => esc_html__('Shadow', 'chakavak'),
                'name' => 'item_shadow_normal',
                'selector' => '{{WRAPPER}} .chk-image-box-1',
                'separator' => 'before',
                'fields_options' => [
                    'box_shadow_type' =>
                        [
                            'default' => 'yes'
                        ],
                    'box_shadow' => [
                        'default' =>
                            [
                                'horizontal' => 0,
                                'vertical' => 3,
                                'blur' => 10,
                                'spread' => 0,
                                'color' => 'rgba(0,0,0,0.1)'
                            ]
                    ]
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'label' => esc_html__('Shadow hover', 'chakavak'),
                'name' => 'item_shadow_hover',
                'selector' => '{{WRAPPER}} .chk-image-box-1:hover',
                'fields_options' => [
                    'box_shadow_type' =>
                        [
                            'default' => 'yes'
                        ],
                    'box_shadow' => [
                        'default' =>
                            [
                                'horizontal' => 0,
                                'vertical' => 5,
                                'blur' => 15,
                                'spread' => 0,
                                'color' => 'rgba(0,0,0,0.13)'
                            ]
                    ]
                ],
            ]
        );


        $this->end_controls_section();

        //Image Style
        $this->start_controls_section(
            'image_style',
            [
                'label' => esc_html__('Image', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'image_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1__image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'image_effect',
            [
                'label' => esc_html__('Hover effect', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'grayscale' => esc_html__('Grayscale', 'chakavak'),
                    'zoom' => esc_html__('Zoom', 'chakavak'),
                    'none' => esc_html__('None', 'chakavak'),
                ],
            ]
        );

        $this->end_controls_section();

        //Content
        $this->start_controls_section(
            'content_style',
            [
                'label' => __('Content', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1__content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_alignment',
            [
                'label' => esc_html__('Text align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1__content' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        //title
        $this->add_control(
            'title_heading',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .chk-image-box-1__title',
            ]
        );

        $this->add_responsive_control(
            'title_margin_bottom',
            [
                'label' => esc_html__('Title spacing bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1__title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color_normal',
            [
                'label' => esc_html__('Title color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1__title' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'title_color_hover',
            [
                'label' => esc_html__('Title color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1__title:is(:hover,:focus)' => 'color:{{VALUE}}',
                ]
            ]
        );


        //subtitle
        $this->add_control(
            'subtitle_heading',
            [
                'label' => __('Subtitle', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'selector' => '{{WRAPPER}} .chk-image-box-1__subtitle',
            ]
        );

        $this->add_responsive_control(
            'subtitle_margin_bottom',
            [
                'label' => esc_html__('Subtitle spacing bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'condition' => [
                    'style' => 's1',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1__subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'subtitle_color_normal',
            [
                'label' => esc_html__('Subtitle color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1__subtitle' => 'color:{{VALUE}}',
                ]
            ]
        );

        //Desc
        $this->add_control(
            'desc_heading',
            [
                'label' => __('Description', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'selector' => '{{WRAPPER}} .chk-image-box-1__desc',
            ]
        );

        $this->add_control(
            'desc_color_normal',
            [
                'label' => esc_html__('Description color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1__desc' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->end_controls_section();

        //Button
        $this->start_controls_section(
            'button_style',
            [
                'label' => __('Button', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'button_sw' => 'yes',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .chk-image-box-1__button-label ',
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1__button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1__button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('button_tabs');
        $this->start_controls_tab(
            'button_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1__button' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'button_bg_color',
            [
                'label' => __('Background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1__button' => 'background-color:{{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'button_border_color',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1__button' => 'border-top-color:{{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'button_color_hover',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1:hover .chk-image-box-1__button' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'button_bg_color_hover',
            [
                'label' => __('Background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1:hover .chk-image-box-1__button' => 'background-color:{{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'button_border_color_hover',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-image-box-1:hover .chk-image-box-1__button' => 'border-top-color:{{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        Chakavak_Controls_Elementor::style_nav_carousel($this, ['ca_navigation' => 'yes']);
        Chakavak_Controls_Elementor::style_dots_carousel($this, ['ca_pagination' => 'yes']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $data_rtl = is_rtl() ? 'rtl' : 'ltr';
        $classes = [];
        $classes[] = 'chk-image-box-group-1 chk-image-box-carousel-1 swiper-slider-wrapper';
        $this->add_render_attribute('wrapper', 'class', $classes);
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div <?php echo $this->get_render_attribute_string('wrapper'); ?> dir="<?php echo $data_rtl; ?>">
                <div class="swiper-content-inner">
                    <div class="init-carousel-swiper swiper" data-carousel="<?php echo Chakavak_Controls_Elementor::get_carousel_settings($this); ?>">
                        <div class="swiper-wrapper">
                            <?php
                            $inumber = 1;
                            foreach ($settings['item_boxes'] as $item) { ?>
                                <div class="swiper-slide">
                                    <div class="chk-image-box-1 <?php echo $settings['style']; ?> transition-all pos-relative z-1 overflow-hidden h-full">

                                        <?php if ($item['image']['url']) : ?>
                                            <div class="chk-image-box-1__image <?php echo 'chk-effect-' . $settings['image_effect']; ?>">
                                                <?php
                                                $alt_img = '';
                                                if (!empty($item['title'])) {
                                                    $alt_img = esc_html($item['title']);
                                                } else {
                                                    $alt_img = 'image-' . $item['_id'];
                                                }
                                                $image_id = $item['image']['id'];
                                                $image_size = $settings['image_size_size'];
                                                $image_custom_dimension = $settings['image_size_custom_dimension'];
                                                if ($image_size === 'custom') {
                                                    $image_src = wp_get_attachment_image_src($image_id, $image_custom_dimension);
                                                } else {
                                                    $image_src = wp_get_attachment_image_src($image_id, $image_size);
                                                }

                                                Chakavak_Controls_Elementor::render_start_link($this, $item['link'], 'lh-0 transition-all');
                                                if ($image_src) {
                                                    $image_url = $image_src[0];
                                                    $image_width = $image_src[1];
                                                    $image_height = $image_src[2];
                                                    echo '<img src="' . esc_url($image_url) . '" alt="' . $alt_img . '" width="' . esc_attr($image_width) . '" height="' . esc_attr($image_height) . '" class="w-full h-auto d-block overflow-hidden transition-all">';
                                                }
                                                Chakavak_Controls_Elementor::render_end_link($this, $item['link']);
                                                ?>
                                            </div>
                                        <?php endif; ?>

                                        <div class="chk-image-box-1__content pos-relative">
                                            <?php
                                            //title
                                            if (!empty($item['title'])) {
                                                $title_tag = $settings['title_tag'];
                                                $title_class = 'chk-image-box-1__title transition-all';
                                                echo "<{$title_tag} class=\"{$title_class}\">";
                                                Chakavak_Controls_Elementor::render_start_link($this, $item['link'], 'd-inline-block transition-all');
                                                echo esc_html($item['title']);
                                                Chakavak_Controls_Elementor::render_end_link($this, $item['link']);
                                                echo "</{$title_tag}>";
                                            }

                                            //subtitle
                                            if (!empty($item['subtitle'])) {
                                                $subtitle_tag = $settings['subtitle_tag'];
                                                $subtitle_class = 'chk-image-box-1__subtitle';
                                                echo "<{$subtitle_tag} class=\"{$subtitle_class}\">";
                                                echo esc_html($item['subtitle']);
                                                echo "</{$subtitle_tag}>";
                                            }

                                            //desc
                                            if (!empty($item['desc'])) {
                                                $desc_class = 'chk-image-box-1__desc';
                                                echo "<p class=\"{$desc_class}\">";
                                                echo wp_kses_post($item['desc']);
                                                echo "</p>";
                                            }
                                            ?>
                                        </div>

                                        <?php
                                        if ($settings['button_sw'] && !empty($item['link']['url'])) :
                                            if (is_rtl()) {
                                                $icon_class = "ti-arrow-large-left";
                                            } else {
                                                $icon_class = "ti-arrow-large-right";
                                            }
                                            ?>
                                            <div class="mt-auto">
                                                <?php $button_class = "chk-image-box-1__button d-flex items-center pos-relative"; ?>
                                                <div class="<?php echo $button_class; ?>">
                                                    <?php Chakavak_Controls_Elementor::render_link_overlay($this, $item['link'], 'chk-image-box__button-readmore chk-link-overlay'); ?>
                                                    <span class="chk-image-box-1__button-label"><?php echo($settings['button_label'] ? esc_html($settings['button_label']) : esc_html__('Explore More', 'chakavak')); ?></span>
                                                    <span class="chk-image-box-1__button-icon"><i class="<?php echo $icon_class; ?>"></i></span>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php $inumber++;
                            }
                            ?>
                        </div>
                    </div>
                </div>
                <?php echo($settings['ca_pagination'] ? '<div class="swiper-pagination"></div>' : ''); ?>
                <?php echo($settings['ca_navigation'] ? '<div class="swiper-nav-next"></div><div class="swiper-nav-prev"></div>' : ''); ?>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Image_Box_Carousel_1());
