<?php

namespace Elementor;

use Chakavak_Controls_Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Icon Box Grid 3
 */
class Chakavak_Icon_Box_Grid_3 extends Widget_Base
{
    const NAME = 'chk_icon_box_grid_3';
    const CATEGORY = 'chakavak_widgets';

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_name()
    {
        return self::NAME;
    }

    public function get_title()
    {
        return esc_html__('Icon Box Grid 3', 'chakavak');
    }

    public function get_keywords()
    {
        return ['icon', 'box', 'grid', 'info box', esc_html__('icon box', 'chakavak')];
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-gallery-grid';
    }

    public function get_style_depends()
    {
        return [
            'chk-icon-box-3'
        ];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'chakavak'),
            ]
        );

        $this->add_control(
            'items_heading',
            [
                'label' => esc_html__('Items', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'icon_type',
            [
                'label' => __('Icon Type', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 'font',
                'options' => [
                    'none' => __('None', 'chakavak'),
                    'font' => __('Font Icon', 'chakavak'),
                    'image' => __('Image Icon', 'chakavak'),
                    'class' => __('Custom class', 'chakavak'),
                    'text' => __('Custom Text', 'chakavak'),
                ]
            ]
        );

        $repeater->add_control(
            'icon_font',
            [
                'label' => __('Icon', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'ti-business',
                    'library' => 'theme-icons',
                ],
                'condition' => [
                    'icon_type' => 'font',
                ]
            ]
        );


        $repeater->add_control(
            'icon_image',
            [
                'label' => esc_html__('Image', 'chakavak'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => CHAKAVAK_ELEMENTOR_ASSETS . 'images/icon.png',
                ],
                'condition' => [
                    'icon_type' => 'image',
                ]
            ]
        );

        $repeater->add_control(
            'icon_class',
            [
                'label' => __('Custom Class', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('bi-team', 'chakavak'),
                'condition' => [
                    'icon_type' => 'class',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'icon_text',
            [
                'label' => __('Custom text', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'condition' => [
                    'icon_type' => 'text',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('UI/UX Design', 'chakavak'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'subtitle',
            [
                'label' => __('Subtitle', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Crafting Digital Experiences', 'chakavak'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );


        $repeater->add_control(
            'desc',
            [
                'label' => __('Description', 'chakavak'),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __('Build the product you need on time with an experienced team that uses a clear and effective design process.', 'chakavak'),
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => __('Link', 'chakavak'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => 'https://your-link.com',
            ]
        );

        $this->add_control(
            'icon_boxes',
            [
                'label' => __('Content Items', 'chakavak'),
                'type' => Controls_Manager::REPEATER,
                'show_label' => false,
                'default' => [
                    [
                        'title' => esc_html__('Web Development', 'chakavak'),
                        'desc' => esc_html__('We carry more than just good coding skills. Our experience makes us stand out from other web development.', 'chakavak'),
                        'icon_font' => [
                            'value' => 'ti-business',
                            'library' => 'theme-icons',
                        ],
                    ],
                    [
                        'title' => esc_html__('UI/UX Design', 'chakavak'),
                        'desc' => esc_html__('Build the product you need on time with an experienced team that uses a clear and effective design process.', 'chakavak'),
                        'icon_font' => [
                            'value' => 'ti-dashboard',
                            'library' => 'theme-icons',
                        ],
                    ],
                    [
                        'title' => esc_html__('IT Counsultancy', 'chakavak'),
                        'desc' => esc_html__('Trust our top minds to eliminate workflow pain points, implement new tech, and consolidate app portfolios.', 'chakavak'),
                        'icon_font' => [
                            'value' => 'ti-goal',
                            'library' => 'theme-icons',
                        ],
                    ]
                ],
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{title}}}',
            ]
        );

        $this->end_controls_section();

        Chakavak_Controls_Elementor::add_control_grid($this);

        //Item Style
        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_alignment',
            [
                'label' => esc_html__('Text align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('Padding Box', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_radius',
            [
                'label' => __('Border Radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'label' => __('Border', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-icon-box-3',
                'exclude' => ['color'],
            ]
        );

        $this->start_controls_tabs('tabs_item');

        $this->start_controls_tab(
            'tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_normal',
                'label' => esc_html__('Background Color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-icon-box-3',

            ]
        );

        $this->add_control(
            'item_border_normal',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow_normal',
                'selector' => '{{WRAPPER}} .chk-icon-box-3',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_hover',
                'label' => esc_html__('Background Color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-icon-box-3:before',

            ]
        );

        $this->add_control(
            'item_border_hover',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow_hover',
                'selector' => '{{WRAPPER}} .chk-icon-box-3:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        //Style icon
        $this->start_controls_section(
            'icon_style',
            [
                'label' => __('Icon', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__('Icon Size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3__icon' => '--icon-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_padding',
            [
                'label' => esc_html__('Padding', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3__icon' => '--icon-padding: {{SIZE}}{{UNIT}}',
                ],
                'default' => [
                    'unit' => 'em',
                ],
                'tablet_default' => [
                    'unit' => 'em',
                ],
                'mobile_default' => [
                    'unit' => 'em',
                ],
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3__icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_space',
            [
                'label' => __('Spacing', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0.1,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3__icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'label' => __('Border', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-icon-box-3__icon',
                'exclude' => ['color'],
            ]
        );

        $this->start_controls_tabs('tabs_icon_style');

        $this->start_controls_tab(
            'icon_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3__icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-icon-box-3__icon i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-icon-box-3__icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon_bg_normal',
                'label' => esc_html__('Background Color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-icon-box-3__icon',

            ]
        );

        $this->add_control(
            'icon_border_normal',
            [
                'label' => __('Border Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3__icon' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'icon_shadow_normal',
                'selector' => '{{WRAPPER}} .chk-icon-box-3__icon',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'icon_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'icon_color_hover',
            [
                'label' => __('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3:hover .chk-icon-box-3__icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-icon-box-3:hover .chk-icon-box-3__icon i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-icon-box-3:hover .chk-icon-box-3__icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon_bg_hover',
                'label' => esc_html__('Background Color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-icon-box-3__icon:before',

            ]
        );

        $this->add_control(
            'icon_border_hover',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3:hover .chk-icon-box-3__icon' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'icon_shadow_hover',
                'selector' => '{{WRAPPER}} .chk-icon-box-3:hover .chk-icon-box-3__icon',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        //title
        $this->start_controls_section(
            'title_style',
            [
                'label' => __('Title', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Select Tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h3',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .chk-icon-box-3__title',
            ]
        );

        $this->add_responsive_control(
            'title_space',
            [
                'label' => __('Spacing', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3__title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3__title,
					 {{WRAPPER}} .chk-icon-box-3__title a' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'title_color_hover',
            [
                'label' => __('Text color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3:hover .chk-icon-box-3__title,
					 {{WRAPPER}} .chk-icon-box-3:hover .chk-icon-box-3__title a,
					 {{WRAPPER}} .chk-icon-box-3:hover .chk-icon-box-3__title a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //Subtitle
        $this->start_controls_section(
            'subtitle_style',
            [
                'label' => __('Subtitle', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'subtitle_tag',
            [
                'label' => esc_html__('Select Tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h5',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'selector' => '{{WRAPPER}} .chk-icon-box-3__subtitle',
            ]
        );

        $this->add_responsive_control(
            'subtitle_space',
            [
                'label' => __('Spacing', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3__subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3__subtitle' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'subtitle_color_hover',
            [
                'label' => __('Text color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3:hover .chk-icon-box-3__subtitle' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //desc
        $this->start_controls_section(
            'desc_style',
            [
                'label' => __('Description', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'desc_tag',
            [
                'label' => esc_html__('Select Tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'p',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'selector' => '{{WRAPPER}} .chk-icon-box-3__desc',
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3__desc' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'desc_color_hover',
            [
                'label' => __('Text color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-3:hover .chk-icon-box-3__desc' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $classes = [];
        $classes[] = 'chk-icon-box-group-3 chk-layout-grid';
        $this->add_render_attribute('wrapper', 'class', $classes);
        Chakavak_Controls_Elementor::get_grid_settings($this);
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
                <div <?php echo $this->get_render_attribute_string('grid') ?>>
                    <?php
                    foreach ($settings['icon_boxes'] as $item) {
                        echo '<div class="col-xs">'; ?>

                        <div class="chk-icon-box-3 chk-bg-before overflow-hidden pos-relative z-1 transition-all">
                            <?php if ($item['icon_type'] != 'none') {
                                echo '<div class="chk-icon-box-3__icon if-center chk-bg-before overflow-hidden pos-relative">';
                                if ($item['icon_type'] == 'font') {
                                    Icons_Manager::render_icon($item['icon_font'], [
                                        'aria-hidden' => 'true',
                                        'class' => 'pos-relative'
                                    ]);
                                } elseif ($item['icon_type'] == 'image') {
                                    echo '<img src="' . esc_attr($item['icon_image']['url']) . '" alt="icon-' .
                                        $this->get_id() . '" class="pos-relative z-1">';
                                } elseif ($item['icon_type'] == 'class') {
                                    echo '<span class="pos-relative z-1 lh-1 ' . esc_attr($item['icon_class']) . '"></span>';
                                } elseif ($item['icon_type'] == 'text') {
                                    echo '<span class="chk-icon-box-3__icon-text pos-relative z-1 lh-1">' . esc_attr($item['icon_text']) .
                                        '</span>';
                                }
                                echo '</div>';
                            } ?>
                            <?php
                            if ($item['title']) :
                                $this->add_render_attribute('title', 'class', 'chk-icon-box-3__title pos-relative z-1');
                                echo '<' . $settings['title_tag'] . ' ' . $this->get_render_attribute_string('title') . '>';
                                Chakavak_Controls_Elementor::render_start_link($this, $item['link'], 'd-block');
                                echo esc_html($item['title']);
                                Chakavak_Controls_Elementor::render_end_link($this, $item['link']);
                                echo '</' . $settings['title_tag'] . '>';
                            endif;

                            if ($item['subtitle']) :
                                $this->add_render_attribute('subtitle', 'class', 'chk-icon-box-3__subtitle pos-relative z-1');
                                echo '<' . $settings['subtitle_tag'] . ' ' . $this->get_render_attribute_string('subtitle') . '>';
                                echo esc_html($item['subtitle']);
                                echo '</' . $settings['subtitle_tag'] . '>';
                            endif;

                            if ($item['desc']) :
                                $this->add_render_attribute('desc', 'class', 'chk-icon-box-3__desc pos-relative z-1');
                                echo '<' . $settings['desc_tag'] . ' ' . $this->get_render_attribute_string('desc') . '>';
                                echo wp_kses_post($item['desc']);
                                echo '</' . $settings['desc_tag'] . '>';
                            endif;
                            ?>
                        </div>
                        <?php echo '</div>';
                    }
                    ?>
                </div>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Icon_Box_Grid_3());
