<?php

namespace Elementor;

use Chakavak_Controls_Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Icon Box 4
 */
class Chakavak_Icon_Box_4 extends Widget_Base
{
    const NAME = 'chk_ibox_4';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Icon Box 4', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-icon-box';
    }

    public function get_keywords()
    {
        return ['icon', 'icon box', 'info box', esc_html__('Icon box', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-icon-box-4'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'content_icon_box',
            [
                'label' => esc_html__('Icon Box', 'chakavak'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'box_style',
            [
                'label' => __('Box Style', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 's1',
                'options' => [
                    's1' => __('Style 1: Icon right', 'chakavak'),
                    's2' => __('Style 2: Icon left', 'chakavak'),
                    's3' => __('Style 3: Icon top', 'chakavak'),
                ]
            ]
        );

        $this->add_control(
            'icon_type',
            [
                'label' => __('Icon Type', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 'font',
                'options' => [
                    'none' => __('None', 'chakavak'),
                    'font' => __('Font Icon', 'chakavak'),
                    'image' => __('Image Icon', 'chakavak'),
                    'text' => __('Text', 'chakavak'),
                ]
            ]
        );

        $this->add_control(
            'icon_font',
            [
                'label' => __('Icon', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'icon_type' => 'font',
                ]
            ]
        );

        $this->add_control(
            'icon_image',
            [
                'label' => esc_html__('Image', 'chakavak'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => get_template_directory_uri() . '/inc/elementor/assets/images/icon.png',
                ],
                'condition' => [
                    'icon_type' => 'image',
                ]
            ]
        );

        $this->add_control(
            'icon_text',
            [
                'label' => esc_html__('Text', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => '01',
                'condition' => [
                    'icon_type' => 'text',
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('UI/UX Design', 'chakavak'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => __('Subtitle', 'chakavak'),
                'type' => Controls_Manager::TEXTAREA,
                'rows' => '3',
                'default' => __('Crafting Digital Experiences', 'chakavak'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => __('Link', 'chakavak'),
                'type' => Controls_Manager::URL,
                'placeholder' => 'https://your-link.com',
            ]
        );

        $this->end_controls_section();

        //Item
        $this->start_controls_section(
            'style_item',
            [
                'label' => __('Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-4' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .chk-icon-box-4',
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_normal',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-icon-box-4',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow_normal',
                'selector' => '{{WRAPPER}} .chk-icon-box-4',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'icon_style',
            [
                'label' => __('Icon', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'icon_type!' => 'none',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__('Size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-4__icon' => '--icon-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_padding',
            [
                'label' => esc_html__('Padding', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-4__icon' => '--icon-padding: {{SIZE}}{{UNIT}}',
                ],
                'default' => [
                    'unit' => 'em',
                ],
                'tablet_default' => [
                    'unit' => 'em',
                ],
                'mobile_default' => [
                    'unit' => 'em',
                ],
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-4__icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_position',
            [
                'label' => esc_html__('Position', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_vertical_position(),
                'default' => 'flex-start',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-4' => 'align-items: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} .chk-icon-box-4__icon',
                'exclude' => ['color'],
            ]
        );

        $this->start_controls_tabs('tabs_icon_item');

        $this->start_controls_tab(
            'tab_icon_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-4__icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-icon-box-4__icon svg' => 'fill: {{VALUE}};',
                ],
                'condition' => [
                    'icon_type!' => 'image',
                ],
            ]
        );

        $this->add_control(
            'icon_border_color',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-4__icon' => 'border-color: {{VALUE}};',
                ],
                'conditions' => [
                    'relation' => 'or', // or
                    'terms' => [
                        [
                            'name' => 'icon_border_width[top]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'icon_border_width[right]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'icon_border_width[left]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'icon_border_width[bottom]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                    ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'css_filters_normal',
                'selector' => '{{WRAPPER}} .chk-icon-box-4__icon img',
                'condition' => [
                    'icon_type' => 'image',
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon_bgcolor_normal',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-icon-box-4__icon',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'icon_box_shadow',
                'selector' => '{{WRAPPER}} .chk-icon-box-4__icon',
            ]
        );
        $this->end_controls_tab();

        //hover
        $this->start_controls_tab(
            'tab_icon_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'icon_color_hover',
            [
                'label' => __('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-4:hover .chk-icon-box-4__icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-icon-box-4:hover .chk-icon-box-4__icon svg' => 'fill: {{VALUE}};',
                ],
                'condition' => [
                    'icon_type!' => 'image',
                ],
            ]
        );

        $this->add_control(
            'icon_border_color_hover',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-4:hover .chk-icon-box-4__icon' => 'border-color: {{VALUE}};',
                ],
                'conditions' => [
                    'relation' => 'or', // or
                    'terms' => [
                        [
                            'name' => 'icon_border_width[top]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'icon_border_width[right]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'icon_border_width[left]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'icon_border_width[bottom]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                    ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'css_filters_hover',
                'selector' => '{{WRAPPER}} .chk-icon-box-4:hover .chk-icon-box-4__icon img',
                'condition' => [
                    'icon_type' => 'image',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon_bgcolor_hover',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-icon-box-4__icon:before',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'icon_box_shadow_hover',
                'selector' => '{{WRAPPER}} .chk-icon-box-4:hover .chk-icon-box-4__icon',
            ]
        );

        $this->end_controls_section();

        //title

        $this->start_controls_section(
            'style_content_section',
            [
                'label' => __('Content', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_alignment',
            [
                'label' => esc_html__('Text align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => 'right',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-4__content' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'heading_title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'title!' => '',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Select Tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h3',
                'condition' => [
                    'title!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .chk-icon-box-4__title',
                'condition' => [
                    'title!' => '',
                ],
            ]
        );


        $this->add_responsive_control(
            'title_space',
            [
                'label' => __('Spasing bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-4__title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'title!' => '',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-4__title,
					 {{WRAPPER}} .chk-icon-box-4__title a' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'title!' => '',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label' => __('Color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-4__title:hover,
					 {{WRAPPER}} .chk-icon-box-4__title:hover a' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'title!' => '',
                ],
            ]
        );

        //subtitle
        $this->add_control(
            'heading_subtitle',
            [
                'label' => __('Subtitle', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'subtitle!' => '',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'subtitle_tag',
            [
                'label' => esc_html__('Select Tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h4',
                'condition' => [
                    'subtitle!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'selector' => '{{WRAPPER}} .chk-icon-box-4__subtitle',
                'condition' => [
                    'subtitle!' => '',
                ],
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => __('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-4__subtitle' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'subtitle!' => '',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $this->add_render_attribute('chk-icon-box-4', 'class', 'chk-icon-box-4 pos-relative transition-all z-1');
        $this->add_render_attribute('chk-icon-box-4', 'class', $settings['box_style']);

        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div <?php echo $this->get_render_attribute_string('chk-icon-box-4'); ?>>
                <?php if ($settings['icon_type'] != 'none') { ?>
                    <div class="chk-icon-box-4__icon pos-relative if-center transition-all chk-bg-before z-1 overflow-hidden">
                        <?php if ($settings['icon_type'] == 'font') {
                            Icons_Manager::render_icon($settings['icon_font'], [
                                'aria-hidden' => 'true',
                                'class' => 'pos-relative'
                            ]);
                        } ?>
                        <?php if ($settings['icon_type'] == 'image') { ?>
                            <img src="<?php echo esc_attr($settings['icon_image']['url']); ?>" alt="<?php echo
                            esc_attr(esc_html($settings['title'])); ?>" class="chk-icon-box-4__icon-image max-w-full
                            h-auto pos-relative z-1">
                        <?php } ?>
                        <?php if ($settings['icon_type'] == 'text' && !empty($settings['icon_text'])) { ?>
                            <span class="chk-icon-box-4__icon-text d-inline-block pos-relative z-1"><?php echo esc_attr(esc_html
                                ($settings['icon_text'])); ?></span>
                        <?php } ?>
                    </div>
                <?php } ?>
                <div class="chk-icon-box-4__content pos-relative z-1">
                    <?php if (!empty($settings['title'])) {
                        $tag_title = $settings['title_tag'];
                        $cls_title = "chk-icon-box-4__title transition-all";
                        echo "<{$tag_title} class=\"{$cls_title}\">";
                        Chakavak_Controls_Elementor::render_start_link($this, $settings['link'], 'd-block transition-all');
                        echo esc_html($settings['title']);
                        Chakavak_Controls_Elementor::render_end_link($this, $settings['link']);
                        echo "</{$tag_title}>";
                    } ?>

                    <?php if (!empty($settings['subtitle'])) {
                        $tag_subtitle = $settings['subtitle_tag'];
                        $cls_subtitle = "chk-icon-box-4__subtitle transition-all";
                        echo "<{$tag_subtitle} class=\"{$cls_subtitle}\">";
                        echo esc_html($settings['subtitle']);
                        echo "</{$tag_subtitle}>";
                    } ?>
                </div>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Icon_Box_4());
