<?php

namespace Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Heading
 */
class Chakavak_heading extends Widget_Base
{
    const NAME = 'chk_heading';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Heading', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-heading';
    }

    public function get_keywords()
    {
        return ['heading', 'title', esc_html__('heading', 'chakavak'), esc_html__('Title', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-elementor-widgets'];
    }

    public function get_script_depends()
    {
        return [];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'title_content',
            [
                'label' => esc_html__('Title Content', 'chakavak'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'heading_alignment',
            [
                'label' => esc_html__('Text align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-heading' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h2',
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'chakavak'),
                'label_block' => true,
                'type' => Controls_Manager::TEXTAREA,
                'rows' => '3',
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('Enter Title', 'chakavak'),
                'description' => esc_html__('You can use HTML.', 'chakavak'),
                'default' => esc_html__('Sample Title Text', 'chakavak'),
            ]
        );

        //ssubtitle
        $this->add_control(
            'subtitle_heading',
            [
                'label' => esc_html__('Subtitle', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'sw_subtitle',
            [
                'label' => __('Show Subtitle', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'chakavak'),
                'label_off' => __('No', 'chakavak'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('subtitle', 'chakavak'),
                'label_block' => true,
                'type' => Controls_Manager::TEXTAREA,
                'rows' => '2',
                'placeholder' => esc_html__('Enter subtitle', 'chakavak'),
                'description' => esc_html__('You can use HTML.', 'chakavak'),
                'default' => esc_html__('subtitle text example', 'chakavak'),
                'condition' => [
                    'sw_subtitle' => 'yes',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'subtitle_location',
            [
                'label' => esc_html__('Display Location', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'above_title' => esc_html__('Above Title', 'chakavak'),
                    'below_title' => esc_html__('Below Title', 'chakavak'),
                ],
                'default' => 'above_title',
                'condition' => [
                    'sw_subtitle' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'subtitle_tag',
            [
                'label' => esc_html__('Subtitle tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h4',
                'condition' => [
                    'sw_subtitle' => 'yes',
                ],
            ]
        );

        //Desc
        $this->add_control(
            'desc_heading',
            [
                'label' => esc_html__('Description', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'sw_desc',
            [
                'label' => __('Show Description', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'chakavak'),
                'label_off' => __('No', 'chakavak'),
                'default' => 'no',
            ]
        );

        $this->add_control(
            'desc',
            [
                'label' => esc_html__('Description', 'chakavak'),
                'label_block' => true,
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Enter Description', 'chakavak'),
                'description' => esc_html__('You can use HTML.', 'chakavak'),
                'default' => esc_html__('Lorem ipsum dolor sit amet cotetur adipisicing elit, sed do mod tempor incididunt ut labore etdolore emu some the and one baldbe dear.', 'chakavak'),
                'condition' => [
                    'sw_desc' => 'yes',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'desc_tag',
            [
                'label' => esc_html__('Description tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'p',
                'condition' => [
                    'sw_desc' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        //heading style
        $this->start_controls_section(
            'title_style',
            [
                'label' => esc_html__('Title', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'title!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .chk-heading__title',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Text Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-heading__title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__('Space Bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .chk-heading__title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'title_shadow',
                'selector' => '{{WRAPPER}} .chk-heading__title',
            ]
        );

        $this->end_controls_section();

        //subtitle style
        $this->start_controls_section(
            'subtitle_style',
            [
                'label' => esc_html__('subtitle', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'subtitle!' => '',
                    'sw_subtitle' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'selector' => '{{WRAPPER}} .chk-heading__subtitle span',
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => esc_html__('Text Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-heading__subtitle span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'subtitle_bg_color',
                'label' => esc_html__('Background Color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-heading__subtitle span',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Background Color', 'chakavak'),
                    ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'subtitle_shadow',
                'selector' => '{{WRAPPER}} .chk-heading__subtitle span',
            ]
        );

        $this->add_control(
            'subtitle_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .chk-heading__subtitle span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'subtitle_margin',
            [
                'label' => esc_html__('Spacing', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .chk-heading__subtitle.top-subtitle' => 'margin-top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-heading__subtitle.bottom-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'desc_style',
            [
                'label' => esc_html__('Description', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'desc!' => '',
                    'sw_desc' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'selector' => '{{WRAPPER}} .chk-heading__desc',
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__('Text Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-heading__desc' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'desc_shadow',
                'selector' => '{{WRAPPER}} .chk-heading__desc',
            ]
        );

        $this->add_responsive_control(
            'desc_margin',
            [
                'label' => esc_html__('Spacing', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .chk-heading__desc' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        if ($settings['sw_subtitle']) {
            $this->add_render_attribute('subtitle', 'class', 'chk-heading__subtitle');
            if ($settings['subtitle_location'] == 'above_title') {
                $this->add_render_attribute('subtitle', 'class', 'top-subtitle');
            } else {
                $this->add_render_attribute('subtitle', 'class', 'bottom-subtitle');
            }
        }

        $this->add_render_attribute('desc', 'class', 'chk-heading__desc');

?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div class="chk-heading">
                <?php
                if ($settings['sw_subtitle']) :
                    if ($settings['subtitle'] && $settings['subtitle_location'] == 'above_title') :
                        echo '<' . $settings['subtitle_tag'] . ' ' . $this->get_render_attribute_string('subtitle') . '>';
                        echo '<span>' . $settings['subtitle'] . '</span>';
                        echo '</' . $settings['subtitle_tag'] . '>';
                    endif;
                endif;

                if ($settings['title']) :
                    $this->add_render_attribute('title', 'class', 'chk-heading__title');
                    //$this->add_inline_editing_attributes( 'title', 'basic' );
                    echo '<' . $settings['title_tag'] . ' ' . $this->get_render_attribute_string('title') . '>';
                    echo $settings['title'];
                    echo '</' . $settings['title_tag'] . '>';
                endif;

                if ($settings['sw_subtitle']) :
                    if ($settings['subtitle'] && $settings['subtitle_location'] == 'below_title') :
                        echo '<' . $settings['subtitle_tag'] . ' ' . $this->get_render_attribute_string('subtitle') . '>';
                        echo '<span>' . $settings['subtitle'] . '</span>';
                        echo '</' . $settings['subtitle_tag'] . '>';
                    endif;
                endif;

                //desc
                if ($settings['sw_desc'] && !empty($settings['desc'])) {
                    echo '<' . $settings['desc_tag'] . ' ' . $this->get_render_attribute_string('desc') . '>';
                    echo $settings['desc'];
                    echo '</' . $settings['desc_tag'] . '>';
                }
                ?>
            </div>
        </div>
<?php
    }

    protected function content_template() {}
}

Plugin::instance()->widgets_manager->register(new Chakavak_heading());
