<?php

namespace Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Google map
 */
class chakavak_Gmap extends Widget_Base
{
    const NAME = 'chk_gmap';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Google Map', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-google-maps';
    }

    public function get_keywords()
    {
        return ['map', 'google map', __('google map', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-gmap'];
    }

    public function get_script_depends()
    {
        return [];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'chakavak'),
            ]
        );

        $this->add_control(
            'lng',
            [
                'label' => esc_html__('Longitude', 'chakavak'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => 51.34224291194243
            ]
        );

        $this->add_control(
            'lat',
            [
                'label' => esc_html__('Latitude', 'chakavak'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => 35.69997422705035
            ]
        );

        $this->add_control(
            'zoom',
            [
                'label' => esc_html__('Zoom', 'chakavak'),
                'type' => Controls_Manager::NUMBER,
                'default' => 14,
                'min' => 1,
                'step' => 1,
            ]
        );

        $this->add_control(
            'gmap_buttons',
            [
                'label' => __('Buttons', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );
        $repeater = new Repeater();
        $repeater->add_control(
            'label_btn',
            [
                'label' => esc_html__('Label Button', 'chakavak'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'link_btn',
            [
                'label' => esc_html__('Link Map', 'chakavak'),
                'type' => Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'chakavak'),
            ]
        );
        $this->add_control(
            'gmap_btns',
            [
                'label' => esc_html__('Buttons', 'chakavak'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ label_btn }}}',
                'item_actions' => [
                    'add' => false,
                    'duplicate' => false,
                    'remove' => false,
                    'sort' => true,
                ],
                'default' => [
                    [
                        'label_btn' => __('Navigation Google', 'chakavak'),
                        'link_btn' => [
                            'url' => '#',
                        ],
                    ],
                    [
                        'label_btn' => __('Navigation Neshan', 'chakavak'),
                        'link_btn' => [
                            'url' => '#',
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        //Style

        $this->start_controls_section(
            'style_gmap',
            [
                'label' => __('Style Map', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'map_height',
            [
                'label' => esc_html__('Map Height', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-gmap' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 2000
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 400
                ],
            ]
        );

        $this->add_control(
            'gmap_filter',
            [
                'label' => esc_html__('Effect', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'default' => __('Default', 'chakavak'),
                    'grayscale' => __('Grayscale', 'chakavak'),
                ],
                'default' => 'default',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'map_border',
                'selector' => '{{WRAPPER}} .chk-gmap',
            ]
        );

        $this->add_responsive_control(
            'map_radius',
            [
                'label' => __('Border Radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .chk-gmap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'map_shadow',
                'fields_options' => [
                    'box_shadow_type' =>
                    [
                        'default' => 'yes'
                    ],
                    'box_shadow' => [
                        'default' =>
                        [
                            'horizontal' => 0,
                            'vertical' => 3,
                            'blur' => 5,
                            'spread' => 0,
                            'color' => 'rgba(0,0,0,0.08)'
                        ]
                    ]
                ],
                'selector' => '{{WRAPPER}} .chk-gmap',
            ]
        );

        /*buttons*/
        $this->add_control(
            'gmap_buttons_style',
            [
                'label' => __('Buttons style', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'selector' => '{{WRAPPER}} .chk-gmap__button',
            ]
        );

        $this->add_responsive_control(
            'btn_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .chk-gmap__button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-gmap__button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('button_tabs');

        $this->start_controls_tab(
            'btn_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );
        $this->add_control(
            'btn_color_normal',
            [
                'label' => esc_html__('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-gmap__button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'btn_border_color',
            [
                'label' => esc_html__('Border Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-gmap__button' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'btn_bgcolor_normal',
            [
                'label' => esc_html__('Background Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-gmap__button' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'btn_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );
        $this->add_control(
            'btn_color_hover',
            [
                'label' => esc_html__('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-gmap__button:is(:hover,:focus)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'btn_border_color_hover',
            [
                'label' => esc_html__('Border Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-gmap__button:is(:hover,:focus)' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'btn_bgcolor_hover',
            [
                'label' => esc_html__('Background Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-gmap__button:is(:hover,:focus)' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $lng = $settings['lng'];
        $lat = $settings['lat'];
        $zoom = $settings['zoom'];
?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div class="chk-gmap effect-map-<?php echo $settings['gmap_filter'] ?>">
                <iframe src="https://maps.google.com/maps?q=<?php echo $lat; ?>, <?php echo $lng; ?>&z=<?php echo $zoom; ?>&output=embed"
                    loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                <?php if ($settings['gmap_btns']): ?>
                    <div class="chk-gmap__buttons">
                        <?php foreach ($settings['gmap_btns'] as $btn): ?>
                            <?php \Chakavak_Controls_Elementor::render_start_link($this, $btn['link_btn'], 'chk-button chk-gmap__button'); ?>
                            <span><?php echo $btn['label_btn']; ?></span>
                            <?php \Chakavak_Controls_Elementor::render_end_link($this, $btn['link_btn']); ?>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
<?php
    }

    protected function content_template() {}
}

Plugin::instance()->widgets_manager->register(new chakavak_Gmap());
