<?php

namespace Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Counter1
 */
class chakavak_Counter_1 extends Widget_Base
{
    const NAME = 'chk_counter_1';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Counter 1', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-counter';
    }

    public function get_keywords()
    {
        return ['counter', 'number', esc_html__('Counter', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-counter-1'];
    }

    public function get_script_depends()
    {
        return [
            'chakavak-widgets',
        ];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Counter', 'chakavak'),
            ]
        );

        $this->add_control(
            'icon_heading',
            [
                'label' => __('Icon', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'icon_type',
            [
                'label' => esc_html__('Icon type', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'none' => [
                        'title' => esc_html__('None', 'chakavak'),
                        'icon' => 'eicon-ban',
                    ],
                    'icon' => [
                        'title' => esc_html__('Icon', 'chakavak'),
                        'icon' => 'eicon-star',
                    ],
                    'image' => [
                        'title' => esc_html__('Image', 'chakavak'),
                        'icon' => 'eicon-image',
                    ],
                ],
                'default' => 'icon',
            ]
        );

        $this->add_control(
            'icon_font',
            [
                'label' => esc_html__('Icon', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'icon_type' => 'icon',
                ],
            ]
        );

        $this->add_control(
            'icon_image',
            [
                'label' => esc_html__('Image', 'chakavak'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => CHAKAVAK_ELEMENTOR_ASSETS . 'images/icon.png',
                ],
                'condition' => [
                    'icon_type' => 'image',
                ],
            ]
        );

        $this->add_control(
            'icon_view',
            [
                'label' => __('View icon', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'default' => __('Default', 'chakavak'),
                    'stacked' => __('Stacked', 'chakavak'),
                ],
                'default' => 'default',
                'prefix_class' => 'chk-counter-1__view-',
                'condition' => [
                    'icon_type!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'content_heading',
            [
                'label' => __('Content', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title:', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Downloads', 'chakavak'),
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h4',
                'condition' => [
                    'title!' => '',
                ]
            ]
        );


        $this->add_control(
            'number_counter',
            [
                'label' => __('Number:', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('800', 'chakavak'),
            ]
        );

        $this->add_control(
            'suffix',
            [
                'label' => __('suffix Number:', 'chakavak'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'time',
            [
                'label' => __('Duration', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 200,
                        'max' => 10000,
                        'step' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 2000,
                ],
            ]
        );

        $this->add_control(
            'position',
            [
                'label' => __('Icon Position', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'default' => 'top',
                'options' => [
                    'left' => [
                        'title' => __('Left', 'chakavak'),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'top' => [
                        'title' => __('Top', 'chakavak'),
                        'icon' => 'eicon-v-align-top',
                    ],
                    'right' => [
                        'title' => __('Right', 'chakavak'),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'prefix_class' => 'chk-counter-1__',
                'toggle' => false,
                'render_type' => 'template',
                'condition' => [
                    'icon_type!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'content_vertical_alignment',
            [
                'label' => __('Icon vertical align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__('Top', 'chakavak'),
                        'icon' => 'eicon-v-align-top',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'chakavak'),
                        'icon' => 'eicon-v-align-middle',
                    ],
                    'flex-end' => [
                        'title' => esc_html__('Bottom', 'chakavak'),
                        'icon' => 'eicon-v-align-bottom',
                    ],
                ],
                'default' => 'center',
                'prefix_class' => 'chk-counter-1__valign-',
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'icon_type',
                            'operator' => '!=',
                            'value' => 'none',
                        ],
                        [
                            'name' => 'position',
                            'operator' => '!=',
                            'value' => 'top',
                        ],
                    ],
                ],
            ]
        );


        $this->add_responsive_control(
            'alignment_content',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => __('Right', 'chakavak'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => __('Center', 'chakavak'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'left' => [
                        'title' => __('Left', 'chakavak'),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-counter-1' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //Style

        $this->start_controls_section(
            'style_content_section',
            [
                'label' => __('Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'rem', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-counter-1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-counter-1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_color',
                'label' => esc_html__('Item background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-counter-1',

            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .chk-counter-1',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .chk-counter-1',
                'separator' => 'before',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'icon_style',
            [
                'label' => __('Icon', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'icon_type!' => 'none',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __('Icon size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 150,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 1,
                        'max' => 30,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-counter-1__icon' => '--icon-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_padding',
            [
                'label' => esc_html__('Padding', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .chk-counter-1__icon' => '--icon-padding: {{SIZE}}{{UNIT}}',
                ],
                'default' => [
                    'unit' => 'em',
                ],
                'tablet_default' => [
                    'unit' => 'em',
                ],
                'mobile_default' => [
                    'unit' => 'em',
                ],
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                ],
                'condition' => [
                    'icon_view' => 'stacked',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-counter-1__icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'icon_view' => 'stacked',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_space',
            [
                'label' => __('Spacing between', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}.chk-counter-1__top .chk-counter-1__icon' => 'row-gap: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}}:is(.chk-counter-1__left,.chk-counter-1__right) .chk-counter-1' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __('Icon color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-counter-1__icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-counter-1__icon svg' => 'fill: {{VALUE}};',
                    '{{WRAPPER}} .chk-counter-1__icon path' => 'stroke: {{VALUE}};',
                ],

                'condition' => [
                    'icon_type!' => 'image',
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon_bg_color',
                'label' => esc_html__('Icon background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-counter-1__icon',
                'separator' => 'before',
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'icon_type',
                            'operator' => '!=',
                            'value' => 'none',
                        ],
                        [
                            'name' => 'icon_view',
                            'operator' => '!=',
                            'value' => 'default',
                        ]
                    ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} .chk-counter-1__icon',
                'separator' => 'before',
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'icon_type',
                            'operator' => '!=',
                            'value' => 'none',
                        ],
                        [
                            'name' => 'icon_view',
                            'operator' => '!=',
                            'value' => 'default',
                        ]
                    ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'icon_shadow',
                'selector' => '{{WRAPPER}} .chk-counter-1__icon',
                'separator' => 'before',
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'icon_type',
                            'operator' => '!=',
                            'value' => 'none',
                        ],
                        [
                            'name' => 'icon_view',
                            'operator' => '!=',
                            'value' => 'default',
                        ]
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'number_style',
            [
                'label' => __('Number', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'number_counter!' => '',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'number_typography',
                'exclude' => [
                    'letter_spacing',
                    'text_transform',
                ],
                'selector' => '{{WRAPPER}} .chk-counter-1__number',
            ]
        );

        $this->add_control(
            'number_color',
            [
                'label' => __('Number color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-counter-1__number' => 'color: {{VALUE}};',
                ],
            ]
        );

        //Extra
        $this->add_control(
            'suffix_heading',
            [
                'label' => __('Suffix Number', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'suffix!' => '',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'suffix_typography',
                'exclude' => [
                    'letter_spacing',
                    'text_transform',
                ],
                'selector' => '{{WRAPPER}} .chk-counter-1__extra',
                'condition' => [
                    'suffix!' => '',
                ]
            ]
        );

        $this->add_control(
            'suffix_color',
            [
                'label' => __('Suffix color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-counter-1__extra' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'suffix!' => '',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'title_style',
            [
                'label' => __('Title', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'title!' => '',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'exclude' => [
                    'letter_spacing',
                    'text_transform',
                ],
                'selector' => '{{WRAPPER}} .chk-counter-1__title',
            ]
        );

        $this->add_responsive_control(
            'title_space',
            [
                'label' => __('Spacing', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-counter-1__content:not(.title-top) .chk-counter-1__title' => 'margin-top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-counter-1__content.title-top .chk-counter-1__title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Title color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-counter-1__title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div class="chk-counter-1 pos-relative lh-1">

                <?php if ('none' != $settings['icon_type']) : ?>
                    <div class="chk-counter-1__icon d-inline-flex">
                        <?php if ('icon' == $settings['icon_type']) {
                            ob_start();
                            Icons_Manager::render_icon($settings['icon_font'], [
                                'aria-hidden' => 'true',
                                'class' => 'pos-relative z-2'
                            ]);
                            $counter_icon = ob_get_clean();
                            if ('' != $counter_icon) {
                                echo $counter_icon;
                            }
                        } ?>
                        <?php if ('image' == $settings['icon_type']) { ?>
                            <img src="<?php echo esc_attr($settings['icon_image']['url']); ?>" width="<?php echo esc_attr($settings['icon_image']['width']); ?>" height="<?php echo esc_attr($settings['icon_image']['height']); ?>" alt="<?php echo esc_attr($settings['title']); ?>" class="max-w-full d-inline-block h-auto" loading="lazy">
                        <?php } ?>
                    </div>
                <?php endif; ?>

                <?php if (!empty($settings['number_counter'])) : ?>

                    <div class="chk-counter-1__content lh-1">

                        <div class="chk-counter-1__number-wrap">
                            <span class="chk-counter-1__number chk-counter-number d-inline-block" data-duration="<?php echo esc_attr($settings['time']['size']); ?>">
                                <?php $this->print_unescaped_setting('number_counter'); ?>
                            </span>
                            <span class="chk-counter-1__extra">
                                <?php echo esc_html($settings['suffix']); ?>
                            </span>
                        </div>

                        <?php if (!empty($settings['title'])) {
                            $this->add_render_attribute('title', 'class', 'chk-counter-1__title');
                            echo '<' . $settings['title_tag'] . ' ' . $this->get_render_attribute_string('title') . '>';
                            echo esc_html($settings['title']);
                            echo '</' . $settings['title_tag'] . '>';
                        } ?>
                    </div>
                <?php endif; ?>

            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new chakavak_Counter_1());
