<?php

namespace Elementor;
defined('ABSPATH') or exit;

/**
 * Widget Name:  Countdown
 */
class chakavak_Countdown extends Widget_Base
{
    const NAME = 'chk_countdown';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Countdown', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-countdown';
    }

    public function get_keywords()
    {
        return ['countdown', 'timer', esc_html__('countdown', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-countdown'];
    }

    public function get_script_depends()
    {
        return [
            'chk-countdown',
            'chk-widgets',
        ];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'countdown_content',
            [
                'label' => __('Countdown', 'chakavak'),
            ]
        );

        $this->add_control(
            'countdown_time',
            [
                'label' => esc_html__('Due Date', 'chakavak'),
                'type' => Controls_Manager::DATE_TIME,
                'picker_options' => [
                    'format' => 'Ym/d H:m:s'
                ],
                'default' => date("Y/m/d H:m:s", strtotime("+ 25 Day")),
            ]
        );

        $this->add_control(
            'standard_countdown',
            [
                'label' => esc_html__('Standard Countdown', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'chakavak'),
                'label_off' => esc_html__('No', 'chakavak'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'units',
            [
                'label' => esc_html__('Time Units', 'chakavak'),
                'type' => Controls_Manager::SELECT2,
                'options' => [
                    'year' => esc_html__('Year', 'chakavak'),
                    'month' => esc_html__('Month', 'chakavak'),
                    'week' => esc_html__('Week', 'chakavak'),
                    'day' => esc_html__('Day', 'chakavak'),
                    'hour' => esc_html__('Hour', 'chakavak'),
                    'minute' => esc_html__('Minute', 'chakavak'),
                    'second' => esc_html__('Second', 'chakavak'),
                ],
                'default' => [
                    'year',
                    'month',
                    'week',
                    'day',
                    'hour',
                    'minute',
                    'second',
                ],
                'multiple' => true,
                'condition' => [
                    'standard_countdown!' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label' => esc_html__('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => __('Right', 'chakavak'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => __('Center', 'chakavak'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-end' => [
                        'title' => __('Left', 'chakavak'),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-countdown' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'direction',
            [
                'label' => esc_html__('Direction digit', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'separator' => 'after',
                'options' => [
                    'rtl' => [
                        'title' => __('Right to left', 'chakavak'),
                        'icon' => 'eicon-h-align-right',
                    ],
                    'ltr' => [
                        'title' => __('Left to right', 'chakavak'),
                        'icon' => 'eicon-h-align-left',
                    ],
                ],
                'default' => 'ltr',
                'selectors' => [
                    '{{WRAPPER}} .chk-countdown' => 'direction: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'action',
            [
                'label' => esc_html__('Action', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'text' => esc_html__('Message', 'chakavak'),
                    'url' => esc_html__('Redirection Link', 'chakavak')
                ],
                'description' => esc_html__('Choose whether if you want to set a message or a redirect link', 'chakavak'),
                'default' => 'text'
            ]
        );

        $this->add_control(
            'text_state',
            [
                'label' => esc_html__('Show Message', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'chakavak'),
                'label_off' => esc_html__('Hide', 'chakavak'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'message',
            [
                'label' => esc_html__('Message', 'chakavak'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Countdown is finished!', 'chakavak'),
                'condition' => [
                    'action' => 'text'
                ]
            ]
        );

        $this->add_control(
            'redirect',
            [
                'label' => esc_html__('Redirect To', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'condition' => [
                    'action' => 'url'
                ],
                'default' => get_permalink(1)
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'counter_translation',
            [
                'label' => esc_html__('Translation', 'chakavak'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'text_state' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'text_year',
            [
                'label' => esc_html__('Year', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Year', 'chakavak'),
                'condition' => [
                    'standard_countdown!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'text_month',
            [
                'label' => esc_html__('Month', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Month', 'chakavak'),
                'condition' => [
                    'standard_countdown!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'text_week',
            [
                'label' => esc_html__('Week', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Week', 'chakavak'),
                'condition' => [
                    'standard_countdown!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'text_day',
            [
                'label' => esc_html__('Day', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Day', 'chakavak'),
            ]
        );

        $this->add_control(
            'text_hour',
            [
                'label' => esc_html__('Hour', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Hour', 'chakavak'),
            ]
        );

        $this->add_control(
            'text_minute',
            [
                'label' => esc_html__('Minute', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Minute', 'chakavak'),
            ]
        );

        $this->add_control(
            'text_second',
            [
                'label' => esc_html__('Second', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Second', 'chakavak'),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_radius',
            [
                'label' => esc_html__('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-countdown__item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-countdown__item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_space',
            [
                'label' => esc_html__('Space between', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-countdown__item' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_width',
            [
                'label' => esc_html__('Width', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 300,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                        '%' => 100,
                    ],
                    'em' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-countdown__item' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_height',
            [
                'label' => esc_html__('Height', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 300,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                        '%' => 100,
                    ],
                    'em' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-countdown__item' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_background',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Background item', 'chakavak'),
                    ],
                ],
                'selector' => '{{WRAPPER}} .chk-countdown__item',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .chk-countdown__item',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow',
                'selector' => '{{WRAPPER}} .chk-countdown__item',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'digit_style',
            [
                'label' => esc_html__('Digit', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'digit_number',
            [
                'label' => __('Number', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'number_color',
            [
                'label' => esc_html__('Number Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} div:not(.chk-countdown__text)' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'number_typography',
                'selector' => '{{WRAPPER}} div:not(.chk-countdown__text)',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'label' => esc_html__('Number Shadow', 'chakavak'),
                'name' => 'number_shadow',
                'selector' => '{{WRAPPER}} div:not(.chk-countdown__text)',
            ]
        );

        $this->add_control(
            'digit_label',
            [
                'label' => __('Label', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'label_color',
            [
                'label' => esc_html__('Number Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} div.chk-countdown__text' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'label_typography',
                'selector' => '{{WRAPPER}} div.chk-countdown__text',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'label' => esc_html__('Label Shadow', 'chakavak'),
                'name' => 'label_shadow',
                'selector' => '{{WRAPPER}} div.chk-countdown__text',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'message_style',
            [
                'label' => esc_html__('Message', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'message_alignment',
            [
                'label' => esc_html__('Text align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'selectors' => [
                    '{{WRAPPER}} .chk-countdown__message' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'message_typography',
                'selector' => '{{WRAPPER}} .chk-countdown__message',
            ]
        );

        $this->add_responsive_control(
            'message_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-countdown__message' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'message_radius',
            [
                'label' => __('Border Radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-countdown__message' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'message_color',
            [
                'label' => esc_html__('Text Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-countdown__message' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'message_shadow',
                'selector' => '{{WRAPPER}} .chk-countdown__message',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'message_bg',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-countdown__message',
            ]
        );
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $countunit = $settings['units'];
        if ('yes' == $settings['standard_countdown']) {
            $countunit = array('day', 'hour', 'minute', 'second');
        }
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div class="chk-countdown" <?php
            if ('yes' != $settings['standard_countdown']) { ?>
                data-text-year="<?php echo esc_attr($settings['text_year']); ?>"
                data-text-month="<?php echo esc_attr($settings['text_month']); ?>"
                data-text-week="<?php echo esc_attr($settings['text_week']); ?>"
            <?php } ?>
                 data-text-day="<?php echo esc_attr($settings['text_day']); ?>"
                 data-text-hour="<?php echo esc_attr($settings['text_hour']); ?>"
                 data-text-minute="<?php echo esc_attr($settings['text_minute']); ?>"
                 data-text-second="<?php echo esc_attr($settings['text_second']); ?>"
                 data-time="<?php echo esc_attr($settings['countdown_time']); ?>"
                 data-text="<?php echo esc_attr($settings['text_state']); ?>"
                 data-standard-countdown="<?php echo esc_attr($settings['standard_countdown']); ?>"
                 data-link="<?php echo esc_attr($settings['redirect']); ?>"
                 data-message="<?php echo esc_attr($settings['message']); ?>"
                 data-edit-mode="<?php echo esc_attr__('You can\'\t redirect url from elementor edit mode!!', 'chakavak') ?>"
                 data-valid-redirect="<?php echo esc_attr__('May be you don\'\t enter a valid redirect url', 'chakavak') ?>"
            >
                <?php if (date_timestamp_get(date_create($settings['countdown_time'])) > time()) :
                    foreach ($countunit as $value) :
                        ?>
                        <div class="chk-countdown__item">
                            <div class="chk-countdown__<?php echo esc_attr($value); ?>">00</div>
                            <?php if ('yes' == $settings['text_state']) : ?>
                                <div class="chk-countdown__text">
                                    <?php echo esc_html(ucfirst($value)); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php
                    endforeach;
                endif; ?>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new chakavak_Countdown());
