<?php

namespace Elementor;

use Chakavak_Controls_Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Brands
 */
class Chakavak_Brands extends Widget_Base
{
    const NAME = 'chk_brands';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Brands', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-carousel';
    }

    public function get_keywords()
    {
        return ['images', 'image carousel', 'carousel', esc_html__('Brands', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-elementor-widgets',];
    }

    public function get_script_depends()
    {
        return ['chk-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'chakavak'),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__('Choose image', 'chakavak'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => CHAKAVAK_ELEMENTOR_ASSETS . 'images/brand-1.webp',
                ],
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__('Image link', 'chakavak'),
                'type' => Controls_Manager::URL,
                'placeholder' => 'https://your-link.com',
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__('Image name', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__('Enter Name', 'chakavak'),
                'description' => esc_html__('This name will be show only item admin and Alt image', 'chakavak'),
                'default' => 'Youtube',
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'brands',
            [
                'label' => esc_html__('Brand item', 'chakavak'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
                'default' => [
                    [
                        'title' => esc_html__('Brand 1', 'chakavak'),
                        'image' => ['url' => CHAKAVAK_ELEMENTOR_ASSETS . 'images/brand-1.webp']
                    ],
                    [
                        'title' => esc_html__('Brand 2', 'chakavak'),
                        'image' => ['url' => CHAKAVAK_ELEMENTOR_ASSETS . 'images/brand-2.webp']
                    ],
                    [
                        'title' => esc_html__('Brand 3', 'chakavak'),
                        'image' => ['url' => CHAKAVAK_ELEMENTOR_ASSETS . 'images/brand-3.webp']
                    ],
                ]
            ]
        );

        Chakavak_Controls_Elementor::image_size($this, 'image', null, 'full');

        $this->add_control(
            'grayscale_hover',
            [
                'label' => esc_html__('Grayscale hover image', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('On', 'chakavak'),
                'label_off' => esc_html__('Off', 'chakavak'),
                'default' => 'no',
            ]
        );

        $this->end_controls_section();

        Chakavak_Controls_Elementor::add_control_carousel($this, false);

        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('Brand', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('Image padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-brand__item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_radius',
            [
                'label' => esc_html__('Radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-brand__item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .chk-brand__item',
            ]
        );


        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bgcolor',
                'label' => esc_html__('Background color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-brand__item',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .chk-brand__item',
            ]
        );

        $this->end_controls_section();

        Chakavak_Controls_Elementor::style_nav_carousel($this, ['ca_navigation' => 'yes']);

        Chakavak_Controls_Elementor::style_dots_carousel($this, ['ca_pagination' => 'yes']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $classes = [];
        $classes[] = 'chk-brands-carousel swiper-slider-wrapper';
        if ($settings['grayscale_hover'] == 'yes') {
            $classes[] = 'chk-hover-grayscale';
        }
        $this->add_render_attribute('wrapper', 'class', $classes);
        $data_rtl = is_rtl() ? 'rtl' : 'ltr';
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div <?php echo $this->get_render_attribute_string('wrapper'); ?> dir="<?php echo $data_rtl; ?>">
                <div class="swiper-content-inner">
                    <div class="init-carousel-swiper swiper" data-carousel="<?php echo Chakavak_Controls_Elementor::get_carousel_settings($this); ?>">
                        <div class="swiper-wrapper">
                            <?php
                            $count = 1;
                            foreach ($settings['brands'] as $brand) {
                                echo '<div class="swiper-slide"><div class="item chk-brand__item pos-relative transition-all">';
                                Chakavak_Controls_Elementor::render_link_overlay($this, $brand['link']);
                                $image_url = $brand['image']['url'];
                                $image_html = '<div class="chk-brand__item-image">';
                                $image_html .= '<img src="' . esc_url($image_url) . '" alt="brand-' . $count . '" class="lh-0 transition-all d-block max-w-full"/>';
                                $image_html .= '</div>';
                                echo $image_html;
                                echo '</div></div>';
                                $count++;
                            }
                            ?>
                        </div>
                    </div>
                    <?php echo($settings['ca_pagination'] ? '<div class="swiper-pagination"></div>' : ''); ?>
                    <?php echo($settings['ca_navigation'] ? '<div class="swiper-nav-next"></div><div class="swiper-nav-prev"></div>' : ''); ?>

                </div>
            </div>
        </div>

        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Brands());
