<?php

namespace Elementor;

use Chakavak_Controls_Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Box service 1
 */
class Chakavak_Box_service_1 extends Widget_Base
{
    const NAME = 'chk_box_service_1';
    const CATEGORY = 'chakavak_widgets';

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_name()
    {
        return self::NAME;
    }

    public function get_title()
    {
        return esc_html__('Box Service 1', 'chakavak');
    }

    public function get_keywords()
    {
        return ['icon', 'box', 'info box', esc_html__('box service', 'chakavak')];
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-info-box';
    }

    public function get_style_depends()
    {
        return ['chk-box-service-1'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'chakavak'),
            ]
        );

        $this->add_control(
            'items_heading',
            [
                'label' => esc_html__('Items', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'icon_type',
            [
                'label' => __('Icon Type', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 'font',
                'options' => [
                    'none' => __('None', 'chakavak'),
                    'font' => __('Font Icon', 'chakavak'),
                    'image' => __('Image Icon', 'chakavak'),
                ]
            ]
        );

        $this->add_control(
            'icon_font',
            [
                'label' => __('Icon', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'ti-business',
                    'library' => 'theme-icons',
                ],
                'condition' => [
                    'icon_type' => 'font',
                ]
            ]
        );

        $this->add_control(
            'icon_image',
            [
                'label' => esc_html__('Image', 'chakavak'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => CHAKAVAK_ELEMENTOR_ASSETS . 'images/icon.png',
                ],
                'condition' => [
                    'icon_type' => 'image',
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Web Design', 'chakavak'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'desc',
            [
                'label' => __('Description', 'chakavak'),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __('Build the product you need on time with an experienced team that uses a clear and effective design process.', 'chakavak'),
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => __('Link', 'chakavak'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => 'https://your-link.com',
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title Tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h2',
                'condition' => [
                    'title!' => '',
                ]
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'label',
            [
                'label' => __('Label', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __('Enter label item', 'chakavak'),
                'default' => __('Full Responsive', 'chakavak'),
            ]
        );

        $this->add_control(
            'features',
            [
                'label' => __('Features', 'chakavak'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ label }}}',
                'default' => [
                    [
                        'label' => __('Full Responsive', 'chakavak'),
                    ],
                    [
                        'label' => __('Standard and up-to-date coding', 'chakavak'),
                    ],
                    [
                        'label' => __('Portfolio introduction', 'chakavak'),
                    ],
                ],
            ]
        );

        $this->add_control(
            'button_heading',
            [
                'label' => esc_html__('Button', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'link[url]!' => '',
                ]
            ]
        );

        $this->add_control(
            'button_sw',
            [
                'label' => esc_html__('Show button', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'label_off' => esc_html__('Off', 'chakavak'),
                'label_on' => esc_html__('On', 'chakavak'),
                'return_value' => 'yes',
                'separator' => 'before',
                'condition' => [
                    'link[url]!' => '',
                ]
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => esc_html__('Label', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('View details', 'chakavak'),
                'condition' => [
                    'link[url]!' => '',
                    'button_sw' => 'yes',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->end_controls_section();

        //Item Style
        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'exclude' => ['color'],
                'fields_options' => [
                    'border' => [
                        'default' => 'solid',
                    ],
                    'width' => [
                        'default' => [
                            'top' => '2',
                            'right' => '2',
                            'bottom' => '2',
                            'left' => '2',
                            'isLinked' => true,
                        ]
                    ],
                ],
                'selector' => '{{WRAPPER}} .chk-box-service-1',
            ]
        );

        $this->start_controls_tabs('item_tabs');

        $this->start_controls_tab(
            'item_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_normal',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => [
                        'default' => 'gradient',
                    ],
                    'color' => [
                        'default' => 'var(--chk-c-gray-100)',
                    ],
                    'color_b' => [
                        'default' => 'transparent',
                    ],
                ],
                'selector' => '{{WRAPPER}} .chk-box-service-1',

            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow_normal',
                'fields_options' => [
                    'box_shadow_type' =>
                        [
                            'default' => 'yes'
                        ],
                    'box_shadow' => [
                        'default' =>
                            [
                                'horizontal' => 0,
                                'vertical' => 0,
                                'blur' => 8,
                                'spread' => 0,
                                'color' => 'rgba(0,0,0,0.05)'
                            ]
                    ]
                ],
                'selector' => '{{WRAPPER}} .chk-box-service-1',
            ]
        );

        $this->add_control(
            'item_border_color_normal',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => 'var(--chk-c-gray-200)',
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1' => 'border-color:{{VALUE}}'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'item_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_hover',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-box-service-1:before',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow_hover',
                'fields_options' => [
                    'box_shadow_type' =>
                        [
                            'default' => 'yes'
                        ],
                    'box_shadow' => [
                        'default' =>
                            [
                                'horizontal' => 0,
                                'vertical' => 0,
                                'blur' => 15,
                                'spread' => 0,
                                'color' => 'rgba(0,0,0,0.08)'
                            ]
                    ]
                ],
                'selector' => '{{WRAPPER}} .chk-box-service-1:hover',
            ]
        );

        $this->add_control(
            'item_border_color_hover',
            [
                'label' => esc_html__('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => 'var(--chk-c-primary)',
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        //icon style
        $this->start_controls_section(
            'icon_style',
            [
                'label' => esc_html__('Icon', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'icon_type!' => 'none'
                ]
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__('Icon Size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__icon' => '--icon-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_padding',
            [
                'label' => esc_html__('Padding', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__icon' => '--icon-padding: {{SIZE}}{{UNIT}}',
                ],
                'default' => [
                    'unit' => 'em',
                ],
                'tablet_default' => [
                    'unit' => 'em',
                ],
                'mobile_default' => [
                    'unit' => 'em',
                ],
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                ],
            ]
        );

        $this->add_control(
            'icon_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} .chk-box-service-1__icon',
                'separator' => 'before',
                'exclude' => ['color'],
            ]
        );

        $this->start_controls_tabs('icon_tabs');

        $this->start_controls_tab(
            'icon_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon_bg_normal',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-box-service-1__icon',
            ]
        );

        $this->add_control(
            'icon_color_normal',
            [
                'label' => esc_html__('Icon color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-box-service-1__icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_border_color_normal',
            [
                'label' => esc_html__('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__icon' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'icon_shadow_normal',
                'selector' => '{{WRAPPER}} .chk-box-service-1__icon',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'icon_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon_bg_hover',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-box-service-1__icon:before',
            ]
        );

        $this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__('Icon color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1:hover .chk-box-service-1__icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-box-service-1:hover .chk-box-service-1__icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_border_color_hover',
            [
                'label' => esc_html__('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1:hover .chk-box-service-1__icon' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'icon_shadow_hover',
                'selector' => '{{WRAPPER}} .chk-box-service-1:hover .chk-box-service-1__icon',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        //Content
        $this->start_controls_section(
            'header_style',
            [
                'label' => __('Header', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'header_align',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-end' => [
                        'title' => __('Left', 'chakavak'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'chakavak'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-start' => [
                        'title' => __('Right', 'chakavak'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__header' => 'justify-content: {{VALUE}};',
                ],
                'default' => '',
            ]
        );

        $this->add_responsive_control(
            'header_margin_bottom',
            [
                'label' => esc_html__('spacing bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__header' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        //title
        $this->add_control(
            'title_heading',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'title!' => ''
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .chk-box-service-1__title',
                'condition' => [
                    'title!' => ''
                ]
            ]
        );

        $this->add_control(
            'title_color_normal',
            [
                'label' => esc_html__('Title color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__title' => 'color:{{VALUE}}',
                ],
                'condition' => [
                    'title!' => ''
                ]
            ]
        );

        $this->add_control(
            'title_color_hover',
            [
                'label' => esc_html__('Title color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1:hover .chk-box-service-1__title' => 'color:{{VALUE}}',
                ],
                'condition' => [
                    'title!' => ''
                ]
            ]
        );

        $this->end_controls_section();


        //Content
        $this->start_controls_section(
            'desc_style',
            [
                'label' => __('Description', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'desc!' => ''
                ]
            ]
        );

        $this->add_responsive_control(
            'desc_align',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'chakavak'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'chakavak'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'chakavak'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => __('Justify', 'chakavak'),
                        'icon' => 'eicon-text-align-justify',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__desc' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'desc_margin_bottom',
            [
                'label' => esc_html__('spacing bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__desc' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'selector' => '{{WRAPPER}} .chk-box-service-1__desc',
            ]
        );

        $this->add_control(
            'desc_color_normal',
            [
                'label' => esc_html__('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__desc' => 'color:{{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'desc_color_hover',
            [
                'label' => esc_html__('Text color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1:hover .chk-box-service-1__desc' => 'color:{{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        //Features
        $this->start_controls_section(
            'features_style',
            [
                'label' => __('Features', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'features!' => '',
                ],
            ]
        );

        $this->add_control(
            'features_columns',
            [
                'label' => esc_html__('Columns', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => esc_html__('1 column', 'chakavak'),
                    '2' => esc_html__('2 columns', 'chakavak'),
                    '3' => esc_html__('3 columns', 'chakavak'),
                ],
                'default' => '2',
            ]
        );

        $this->add_responsive_control(
            'features_align',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'chakavak'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'chakavak'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'chakavak'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__feature-item' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'features_gap',
            [
                'label' => esc_html__('spacing between', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 20,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 5,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__features' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'features_typography',
                'selector' => '{{WRAPPER}} .chk-box-service-1__feature-item',
            ]
        );

        $this->add_control(
            'features_color_normal',
            [
                'label' => esc_html__('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__feature-item' => 'color:{{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'features_color_hover',
            [
                'label' => esc_html__('Text color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1:hover .chk-box-service-1__feature-item' => 'color:{{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        //Button
        $this->start_controls_section(
            'button_style',
            [
                'label' => __('Button', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'button_sw' => 'yes',
                    'link[url]!' => '',
                ]
            ]
        );

        $this->add_responsive_control(
            'button_align',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'chakavak'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'chakavak'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'chakavak'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__button' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .chk-box-service-1__button > a ',
            ]
        );

        $this->add_responsive_control(
            'button_margin_top',
            [
                'label' => esc_html__('Margin top', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 0.1,
                    ],
                ],
                'condition' => [
                    'style' => 's1',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__button' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('button_style_tabs');

        $this->start_controls_tab(
            'button_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'button_text_normal',
            [
                'label' => esc_html__('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__button > a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_border_top_normal',
            [
                'label' => esc_html__('Border top color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1__button' => 'border-top-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'button_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'button_text_hover',
            [
                'label' => esc_html__('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1:hover .chk-box-service-1__button > a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_border_top_hover',
            [
                'label' => esc_html__('Border top color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-box-service-1:hover .chk-box-service-1__button' => 'border-top-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div class="chk-box-service-1 pos-relative d-flex flex-col h-full overflow-hidden chk-bg-before transition-all">
                <div class="chk-box-service-1__header d-flex items-center flex-wrap transition-all pos-relative z-1">
                    <?php if ($settings['icon_type'] != 'none') : ?>
                        <figure class="chk-box-service-1__icon if-center pos-relative z-1 chk-bg-before transition-all">
                            <?php
                            if ($settings['icon_type'] == 'font') {
                                Icons_Manager::render_icon($settings['icon_font'], [
                                    'aria-hidden' => 'true',
                                    'class' => 'pos-relative'
                                ]);
                            } elseif ($settings['icon_type'] == 'image') {
                                echo '<img src="' . esc_attr($settings['icon_image']['url']) . '" alt="' . esc_html($settings['title']) . '" class="max-w-full h-auto pos-relative z-1">';
                            }
                            ?>
                        </figure>
                    <?php endif; ?>

                    <?php
                    if (!empty($settings['title'])) {
                        $title_tag = $settings['title_tag'];
                        $title_class = 'chk-box-service-1__title pos-relative z-1';
                        echo "<{$title_tag} class=\"{$title_class}\">";
                        Chakavak_Controls_Elementor::render_start_link($this, $settings['link'], 'd-inline-block text-current transition-all');
                        echo esc_html($settings['title']);
                        Chakavak_Controls_Elementor::render_end_link($this, $settings['link']);
                        echo "</{$title_tag}>";
                    }
                    ?>
                </div>

                <?php
                if (!empty($settings['desc'])) {
                    $desc_class = 'chk-box-service-1__desc mb-0 pos-relative z-1 ';
                    echo "<p class=\"{$desc_class}\">";
                    echo wp_kses_post($settings['desc']);
                    echo "</p>";
                }
                ?>
                <?php if ($settings['features']) : ?>
                    <ul class="chk-box-service-1__features  pos-relative z-1 list-none p-0 d-grid grid-cols-xs-1 grid-cols-lg-<?php echo $settings['features_columns']; ?>">
                        <?php foreach ($settings['features'] as $item) {
                            echo '<li class="chk-box-service-1__feature-item pos-relative transition-all">';
                            echo '<span class="transition-all">';
                            echo esc_html($item['label']);
                            echo '</span>';
                            echo '</li>';
                        } ?>
                    </ul>
                <?php endif; ?>

                <?php if ($settings['button_sw'] && !empty($settings['link']['url'])) { ?>
                    <div class="chk-box-service-1__button-wrap pos-relative z-1 mt-auto pos-relative">
                        <div class="chk-box-service-1__button">
                            <?php
                            Chakavak_Controls_Elementor::render_start_link($this, $settings['link'], 'if-center transition-all');
                            echo '<span class="if-center">';
                            echo esc_html($settings['button_text']);
                            echo(is_rtl() ? '<i class="ti-arrow-large-left"></i>' : '<i class="ti-arrow-large-right"></i>');
                            echo '</span>';
                            Chakavak_Controls_Elementor::render_end_link($this, $settings['link']);
                            ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Box_service_1());
