<?php

namespace Elementor;

use Chakavak_Controls_Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Banner 1
 */
class chakavak_banner extends Widget_Base
{
    const NAME = 'chk_banner_1';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Banner 1', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-banner';
    }

    public function get_keywords()
    {
        return ['banner', esc_html__('banner', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-elementor-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'banner_section',
            [
                'label' => esc_html__('Banner', 'chakavak'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'banner_image',
            [
                'label' => __('Select image', 'chakavak'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => CHAKAVAK_ELEMENTOR_ASSETS . 'images/placeholder.webp',
                ],
            ]
        );
        $this->add_control(
            'link',
            [
                'label' => __('Link', 'chakavak'),
                'type' => Controls_Manager::URL,
                'placeholder' => 'https://your-link.com',
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'title_heading',
            [
                'label' => esc_html__('Title', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title text', 'chakavak'),
                'label_block' => true,
                'type' => Controls_Manager::TEXTAREA,
                'rows' => '3',
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('Enter title', 'chakavak'),
                'description' => esc_html__('You can use HTML.', 'chakavak'),
                'default' => esc_html__('Sample Title Text', 'chakavak'),
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h4',
                'condition' => [
                    'title!' => '',
                ]
            ]
        );

        //desc
        $this->add_control(
            'desc_heading',
            [
                'label' => esc_html__('Description', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'sw_desc',
            [
                'label' => __('Show Description', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'chakavak'),
                'label_off' => __('No', 'chakavak'),
                'default' => 'no',
            ]
        );

        $this->add_control(
            'desc',
            [
                'label' => esc_html__('Description', 'chakavak'),
                'label_block' => true,
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Enter Description', 'chakavak'),
                'description' => esc_html__('You can use HTML.', 'chakavak'),
                'default' => esc_html__('Lorem ipsum dolor sit amet cotetur adipisicing elit, sed do mod tempor incididunt ut labore etdolore emu some the and one baldbe dear.', 'chakavak'),
                'condition' => [
                    'sw_desc' => 'yes',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'desc_tag',
            [
                'label' => esc_html__('Decription tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'p',
                'condition' => [
                    'sw_desc' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        //heading style
        $this->start_controls_section(
            'banner_style',
            [
                'label' => esc_html__('Banner', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'banner_height',
            [
                'label' => esc_html__('Height', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-1' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'banner_overlay',
                'label' => esc_html__('Overlay Color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-banner-1',

            ]
        );

        $this->add_responsive_control(
            'banner_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'rem', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'banner_border_radius',
            [
                'label' => esc_html__('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'banner_image_opacity',
            [
                'label' => esc_html__('Image Opacity Hover', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-1:hover > .chk-banner-1__image' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'banner_content_style',
            [
                'label' => esc_html__('Content', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_alignment',
            [
                'label' => esc_html__('Content align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => 'right',
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-1__content' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'content_vertical_alignment',
            [
                'label' => __('Content vertical align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'default' => 'title-bottom',
                'options' => [
                    'flex-start' => [
                        'title' => __('Top', 'chakavak'),
                        'icon' => 'eicon-v-align-top',
                    ],
                    'center' => [
                        'title' => __('Center', 'chakavak'),
                        'icon' => 'eicon-v-align-middle',
                    ],
                    'flex-end' => [
                        'title' => __('Bottom', 'chakavak'),
                        'icon' => 'eicon-v-align-bottom',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-1' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_heading_style',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'title!' => '',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .chk-banner-1__title',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-1__title' => 'color:{{VALUE}}',
                ],
                'condition' => [
                    'title!' => '',
                ]
            ],
        );

        //desc
        $this->add_control(
            'desc_heading_style',
            [
                'label' => __('Description', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'sw_desc' => 'yes',
                    'desc!' => '',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'selector' => '{{WRAPPER}} .chk-banner-1__desc',
                'condition' => [
                    'sw_desc' => 'yes',
                    'desc!' => '',
                ]
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-1__desc' => 'color:{{VALUE}}',
                ],
                'condition' => [
                    'sw_desc' => 'yes',
                    'desc!' => '',
                ]
            ],
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div class="chk-banner-1 pos-relative z-2 overflow-hidden">
                <?php Chakavak_Controls_Elementor::render_link_overlay($this, $settings['link'], 'chk-link-overlay lh-0 d-block'); ?>
                <img src="<?php echo esc_attr($settings['banner_image']['url']); ?>" alt="<?php echo (!empty($settings['title'])) ? $settings['title'] : 'banner1 image'; ?>" class="chk-banner-1__image">

                <div class="chk-banner-1__content">
                    <?php if (!empty($settings['title'])) :
                        $this->add_render_attribute('title', 'class', 'chk-banner-1__title');
                        echo '<' . $settings['title_tag'] . ' ' . $this->get_render_attribute_string('title') . '>';
                        echo wp_kses_post($settings['title']);
                        echo '</' . $settings['title_tag'] . '>';
                    endif; ?>

                    <?php if (!empty($settings['desc'])) :
                        $this->add_render_attribute('desc', 'class', 'chk-banner-1__desc');
                        echo '<' . $settings['desc_tag'] . ' ' . $this->get_render_attribute_string('desc') . '>';
                        echo wp_kses_post($settings['desc']);
                        echo '</' . $settings['desc_tag'] . '>';
                    endif; ?>
                </div>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new chakavak_banner());
