<?php

namespace Elementor;

defined('ABSPATH') or exit;

class Chakavak_Aparat_Namasha extends Widget_Base
{
    const NAME = 'chk_aparat_namasha';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Aparat & Namasha', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-video-camera';
    }

    public function get_keywords()
    {
        return ['video', esc_html__('aparat', 'chakavak'), esc_html__('Namasha', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-elementor-widgets'];
    }

    public function get_script_depends()
    {
        return [];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Video', 'chakavak'),
            ]
        );

        $this->add_control(
            'video_type',
            [
                'label' => esc_html__('Video Type', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'aparat' => esc_html__('Aparat', 'chakavak'),
                    'namasha' => esc_html__('Namasha', 'chakavak'),
                ],
                'default' => 'aparat',
            ]
        );

        $this->add_control(
            'id_aparat',
            [
                'label' => __('ID Video', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __('Enter ID video', 'chakavak'),
                'default' => __('n71h233', 'chakavak'),
                'condition' => [
                    'video_type' => 'aparat',
                ],
                'dynamic' => [
                    'active' => true,
                ],
                'description' => __('Paste the video ID from the address bar For example the video address https://www.aparat.com/v/n71h233 Just put n71h233 ID', 'chakavak'),
            ]
        );

        $this->add_control(
            'id_namasha',
            [
                'label' => __('ID Video', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __('Enter ID video', 'chakavak'),
                'default' => __('3gJdRzSC', 'chakavak'),
                'condition' => [
                    'video_type' => 'namasha',
                ],
                'dynamic' => [
                    'active' => true,
                ],
                'description' => __('Paste the video ID from the address bar For example the video address https://www.namasha.com/v/28hjIL6o Just put 28hjIL6o ID', 'chakavak'),
            ]
        );

        $this->add_control(
            'label_video',
            [
                'label' => __('Video label', 'chakavak'),
                'type' => Controls_Manager::TEXTAREA,
                'rows' => '3',
                'placeholder' => __('video label', 'chakavak'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'label_tag',
            [
                'label' => esc_html__('Select Tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h3',
                'condition' => [
                    'label_video!' => '',
                ],
            ]
        );

        $this->add_control(
            'label_location',
            [
                'label' => esc_html__('Display Location', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'above-video' => esc_html__('Above Video', 'chakavak'),
                    'below-video' => esc_html__('Below Video', 'chakavak'),
                ],
                'default' => 'above-video',
                'condition' => [
                    'label_video!' => '',
                ],
            ]
        );

        $this->end_controls_section();

        //Style
        $this->start_controls_section(
            'style_item',
            [
                'label' => __('Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'video_width',
            [
                'label' => __('Width', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-video-embed' => 'width: {{SIZE}}{{UNIT}};height:auto;',
                ],
            ]
        );
        $this->add_responsive_control(
            'video_alignment',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-end' => [
                        'title' => __('Left', 'chakavak'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'chakavak'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-start' => [
                        'title' => __('Right', 'chakavak'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .chk-video-embed__wrap' => 'justify-content: {{VALUE}}',
                ]
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-video-embed' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-video-embed' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .chk-video-embed__iframe ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .chk-video-embed',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-video-embed',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow',
                'selector' => '{{WRAPPER}} .chk-video-embed',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_video',
            [
                'label' => __('Video', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'iframe_shadow',
                'selector' => '{{WRAPPER}} .chk-video-embed__iframe',
            ]
        );

        $this->add_control(
            'label_heading_style',
            [
                'label' => esc_html__('Label', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'label_video!' => '',
                ],
            ],
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'label_typography',
                'selector' => '{{WRAPPER}} .chk-video-embed__label',
                'condition' => [
                    'label_video!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'label_alignment',
            [
                'label' => esc_html__('Text align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-video-embed__label' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'label_video!' => '',
                ],
            ]
        );

        $this->add_control(
            'label_color',
            [
                'label' => esc_html__('text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-video-embed__label' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'label_video!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'label_margin',
            [
                'label' => __('Spacing top to bottom', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'allowed_dimensions' => ['top', 'bottom'],
                'default' => [
                    'top' => '',
                    'right' => '0',
                    'bottom' => '',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-video-embed__label' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $type = $settings['video_type'];
        $apart_id = isset($settings['id_aparat']) ? $settings['id_aparat'] : 'n71h233';
        $namasha_id = isset($settings['id_aparat']) ? $settings['id_aparat'] : 'lC6sjWuw';
        if (!empty($settings['label_video'])) {
            $this->add_render_attribute('label', 'class', 'chk-video-embed__label');
        }

        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div class="chk-video-embed__wrap d-flex items-center">
                <div class="chk-video-embed pos-relative w-full">
                    <?php
                    if (!empty($settings['label_video']) && $settings['label_location'] == 'above-video') {
                        echo '<' . $settings['label_tag'] . ' ' . $this->get_render_attribute_string('label') . '>';
                        echo esc_html($settings['label_video']);
                        echo '</' . $settings['label_tag'] . '>';
                    } ?>

                    <?php if ($type == 'aparat') : ?>
                        <div class="chk-video-embed__iframe chk-iframe-aparat h_iframe-aparat_embed_frame">
                            <span class="aparat-embed-frame"></span>
                            <iframe loading="lazy" class="lazyloaded" src='https://www.aparat.com/video/video/embed/videohash/<?php echo $apart_id; ?>/vt/frame' allowFullScreen="allowfullscreen" webkitallowfullscreen="true" mozallowfullscreen="true">
                            </iframe>
                        </div>
                    <?php endif; ?>

                    <?php if ($type == 'namasha') : ?>
                        <div class="chk-video-embed__iframe chk-iframe-namasha">
                            <iframe loading="lazy" class="chk-video-embed__iframe lazyloaded" src='https://www.namasha.com/embed/<?php echo $namasha_id; ?>' allowfullscreen="allowfullscreen" mozallowfullscreen="true" webkitallowfullscreen="true">
                            </iframe>
                        </div>
                    <?php endif; ?>

                    <?php
                    if (!empty($settings['label_video']) && $settings['label_location'] == 'below-video') {
                        echo '<' . $settings['label_tag'] . ' ' . $this->get_render_attribute_string('label') . '>';
                        echo esc_html($settings['label_video']);
                        echo '</' . $settings['label_tag'] . '>';
                    } ?>
                </div>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Aparat_Namasha());
