<?php

class Chakavak_Elementor_Override
{
    public function __construct()
    {
        $this->elementor_init_setup();
    }

    function elementor_init_setup()
    {
        if (empty(get_option('elementor_allow_svg', ''))) {
            update_option('elementor_allow_svg', 1);
        }
        if (empty(get_option('elementor_load_fa4_shim', ''))) {
            update_option('elementor_load_fa4_shim', 'yes');
        }
        if (empty(get_option('elementor_container_width', ''))) {
            update_option('elementor_container_width', '1200');
        }

        add_action('elementor/element/container/section_layout/after_section_end', [$this, 'chakavak_custom_control_header'], 10, 3);
        add_action('elementor/element/section/section_structure/after_section_end', [$this, 'chakavak_custom_control_header'], 10, 3);
    }

    private function chakavak_get_current_post($document)
    {
        $post = $document->get_post();
        if (($postId = wp_is_post_revision($post)) !== false) {
            $post = get_post($postId);
        }
        if (!$post instanceof WP_Post) {
            return false;
        }

        return $post;
    }

    function chakavak_custom_control_header($section, $args)
    {
        $section->start_controls_section(
            'header_custom_class',
            [
                'label' => __('For Header', 'chakavak'),
                'tab' => Elementor\Controls_Manager::TAB_LAYOUT,
            ]
        );
        $section->add_control(
            'sticky_class',
            [
                'label' => __('Sticky header', 'chakavak'),
                'type' => Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'is-fixed',
                'prefix_class' => '',
            ]
        );
        $section->add_control(
            'sticky_background',
            [
                'label' => __('Background Scroll', 'chakavak'),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}.elementor-section.chk-is-stuck' => 'background: {{VALUE}};',
                    '{{WRAPPER}}.elementor-element.chk-is-stuck' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'sticky_class' => 'is-fixed',
                ],
            ]
        );

        $section->end_controls_section();
    }
}

new Chakavak_Elementor_Override();
