<?php

/**
 * Adding custom icon to icon control in Elementor
 */
function chakavak_icons_library($tabs = array())
{
	// Append new icons

	$theme_icons = [
		"external-link",
		"link",
		"reply-arrow",
		"push-pin",
		"adjust",
		"align-center",
		"apps",
		"arrow-down",
		"arrow-large-down",
		"arrow-large-left",
		"arrow-large-right",
		"arrow-large-up",
		"arrow-left",
		"arrow-right",
		"arrow-right-bottom",
		"arrow-up",
		"arrow-up-left",
		"at-symbol",
		"authentication",
		"bill",
		"bookmark",
		"bookmark-fill",
		"box",
		"business",
		"calendar",
		"camera",
		"certificate",
		"chat-message",
		"check",
		"check-circle",
		"check-mark",
		"check-square",
		"circle",
		"clock",
		"close",
		"close-circle",
		"comma",
		"comments",
		"credit-card",
		"dashboard",
		"database-backup",
		"diploma",
		"discount",
		"documents",
		"dots",
		"download",
		"edit-file",
		"email",
		"expand",
		"eye",
		"faq",
		"faq-circle",
		"fax",
		"file",
		"file-invoice",
		"fingerprint",
		"flash",
		"flash-fill",
		"flow-chart",
		"folder",
		"full-screen",
		"goal",
		"graduation-cap",
		"guarantee",
		"headset",
		"heart",
		"heart-fill",
		"home",
		"infinity",
		"info",
		"key",
		"king",
		"knight",
		"lifebuoy",
		"list",
		"literature",
		"location",
		"lock",
		"logo-aparat",
		"logo-behance",
		"logo-dribbble",
		"logo-facebook",
		"logo-gmail",
		"logo-instagram",
		"logo-linkedin",
		"logo-pinterest",
		"logo-skype",
		"logo-spotify",
		"logo-telegram",
		"logo-twitter",
		"logo-whatsapp",
		"logo-x",
		"logo-youtube",
		"menu",
		"minus",
		"minus-circle",
		"minus-square",
		"mobile",
		"moon",
		"music",
		"new",
		"notification",
		"page",
		"pencil",
		"percentage",
		"phone",
		"phone-call",
		"phone-flip",
		"place-marker",
		"play",
		"play-circle",
		"plus",
		"plus-circle",
		"plus-square",
		"print",
		"qr-code",
		"queen",
		"quote-left",
		"quote-right",
		"search",
		"settings",
		"share",
		"shop",
		"shopping-bag",
		"shopping-cart",
		"shutdown",
		"square",
		"stack-paper",
		"star",
		"star-fill",
		"sun",
		"support-man",
		"support-women",
		"telephone",
		"third-ribbon",
		"trophy",
		"two-lines",
		"update",
		"upload",
		"user",
		"user-circle",
		"user-edit",
		"user-locked",
		"user-settings",
		"users",
		"video",
		"view-more",
		"wallet",
		"website"
	];

	$business_icons = [
		'hours-support',
		'administrator',
		'advertising',
		'analytics',
		'award',
		'backup',
		'boost',
		'briefcase',
		'call',
		'certificate',
		'chess',
		'communicate',
		'content',
		'content-1',
		'content-2',
		'content-creation',
		'contract',
		'conversation',
		'creative-tools',
		'customer-management',
		'cv',
		'data-analytics',
		'database',
		'designer',
		'domain',
		'ecommerce',
		'email-marketing',
		'employee',
		'fast-delivery',
		'fence',
		'folder',
		'folders',
		'full-stack',
		'goal',
		'graphic-design',
		'handshake',
		'headhunting',
		'illustration',
		'interactive',
		'labor-day',
		'landing-page',
		'languages',
		'learning',
		'list',
		'logistics',
		'marketing',
		'marketing-1',
		'medal',
		'medal-1',
		'movie',
		'nas',
		'need-job',
		'need-job-1',
		'news',
		'open-file',
		'performance',
		'photos',
		'podium',
		'product-manager',
		'project-management',
		'recommendation',
		'service',
		'site-map',
		'social-media',
		'social-media-2',
		'speedometer',
		'startup',
		'strategy',
		'success',
		'tax-consultant',
		'team',
		'technical-support',
		'term',
		'time',
		'translation',
		'trolley',
		'trophy',
		'virtual-assistant',
		'web-alert',
		'web-development-1',
		'website',
		'worker',
		'working-together',
		'workspace',
		'work-vest',
		'dashboard',
		'strategy-2'
	];

	$tabs['theme-icons'] = [
		'name'          => 'chakavak-theme-icons',
		'label'         => esc_html__('Theme Icons', 'chakavak'),
		'labelIcon'     => 'eicon-icon-box',
		'prefix'        => 'ti-',
		'displayPrefix' => '',
		'url'           => get_template_directory_uri() . '/assets/css/theme-icons.min.css',
		'icons'         => $theme_icons,
		'ver'           => '1.0.0',
	];

	$tabs['business-icons'] = [
		'name'          => 'chakavak-business-icons',
		'label'         => esc_html__('Business Icons', 'chakavak'),
		'labelIcon'     => 'eicon-icon-box',
		'prefix'        => 'bi-',
		'displayPrefix' => '',
		'url'           => get_template_directory_uri() . '/assets/css/business-icons.min.css',
		'icons'         => $business_icons,
		'ver'           => '1.0.0',
	];

	return $tabs;
}

add_filter('elementor/icons_manager/additional_tabs', 'chakavak_icons_library');
