<?php

/**
 * Template Requirements
 * Requirements Template for admin panel
 * @package Chakavak
 */

global $wpdb;
$php_requirements = 7.0;
$memory_limit_requirements = 134217728;
$max_upload_size = 134217728;
$max_execution_time_requirements = 600;
$max_input_time_requirements = 600;
$max_input_vars_requirements = 3000;
?>
<div class="chk-panel__body" id="tab-support">
    <h4 class="chk-box-server-status-title"><?php esc_html_e('Status Server', 'chakavak') ?></h4>
    <div class="row">
        <div class="col-12">
            <div class="chk-panel__box mb-16">
                <div class="chk-panel__content">
                    <h4 class="chk-box-server-status-title"><?php esc_html_e('Wordpress information', 'chakavak') ?></h4>
                    <table class="table chk-status-lists">
                        <tr>
                            <th><span><?php esc_html_e('Home URL', 'chakavak'); ?></span></th>
                            <td><strong><?php echo esc_html(home_url('/')); ?></strong></td>
                        </tr>
                        <tr>
                            <th><span><?php esc_html_e('Site URL', 'chakavak'); ?></span></th>
                            <td><strong><?php echo esc_html(site_url('/')); ?></strong></td>
                        </tr>

                        <tr>
                            <th><span><?php esc_html_e('Wordpress version', 'chakavak'); ?></span></th>
                            <td><strong><?php echo esc_html(get_bloginfo('version')); ?></strong></td>
                        </tr>

                        <tr>
                            <th><span><?php esc_html_e('Language', 'chakavak'); ?></span></th>
                            <td><strong><?php echo get_locale(); ?></strong></td>
                        </tr>

                        <tr>
                            <th><span><?php esc_html_e('Memory limit', 'chakavak'); ?></span></th>
                            <?php
                            if ($memory_limit_requirements > chakavak_memory_limit()) {
                                echo '<td>';
                                echo '<p class="message-info-error">ٰ' . esc_html__('Value: ', 'chakavak') . ' ' . esc_html(size_format(chakavak_memory_limit())) . '.' . esc_html_e('We recommend setting the memory to at least 128MB.', 'chakavak') . '</p>';
                                echo '<p class="note"><a target="_blank" href="https://www.wpbeginner.com/wp-tutorials/fix-wordpress-memory-exhausted-error-increase-php-memory/">' . esc_html_e('How to change memory?', 'chakavak') . '</a></p>';
                                echo '</td>';
                            } else {
                                echo '<td><strong>' . esc_html__('Value: ', 'chakavak') . esc_html(size_format(chakavak_memory_limit())) . '</strong></td>';
                            }
                            ?>
                        </tr>
                        <tr>
                            <th><span><?php esc_html_e('Wordpress debug', 'chakavak'); ?></span></th>
                            <?php
                            if (defined('WP_DEBUG') and WP_DEBUG === true) {
                                echo '<td>';
                                echo '<strong>' . esc_html__('Active wordpress Debug', 'chakavak') . '</strong>';
                                echo '<p class="note"><a target="_blank" href="https://wordpress.org/support/article/debugging-in-wordpress/">' . esc_html__('How to Disable WordPress Debugging?', 'chakavak') . '</a></p>';
                                echo '</td>';
                            } else {
                                echo '<td>';
                                echo '<strong>' . esc_html__('Disable WordPress Debugging', 'chakavak') . '</strong>';
                                echo '</td>';
                            }
                            ?>
                        </tr>
                    </table>
                </div>
            </div>

            <div class="chk-panel__box mb-16">
                <div class="chk-panel__content">
                    <h4 class="chk-box-server-status-title"><?php esc_html_e('Template information', 'chakavak') ?></h4>
                    <table class="table chk-status-lists">
                        <tr>
                            <th><span><?php esc_html_e('Theme name', 'chakavak'); ?></span></th>
                            <td><strong><?php echo esc_html(wp_get_theme()->get('Name')); ?></strong></td>
                        </tr>
                        <tr>
                            <th><span><?php esc_html_e('Theme Version', 'chakavak'); ?></span></th>
                            <td><strong><?php echo esc_html(wp_get_theme()->get('Version')); ?></strong></td>
                        </tr>

                        <tr>
                            <th><span><?php esc_html_e('Theme designer', 'chakavak'); ?></span></th>
                            <td><a href="<?php echo esc_url_raw(wp_get_theme()->get('AuthorURI')) ?>" target="_blank"><strong><?php echo esc_html(wp_get_theme()->get('Author')); ?></strong></a></td>
                        </tr>

                    </table>
                </div>
            </div>

            <div class="chk-panel__box mb-16">
                <div class="chk-panel__content">
                    <h4 class="chk-box-server-status-title"><?php esc_html_e('Server information', 'chakavak') ?></h4>
                    <table class="table chk-status-lists">

                        <tr>
                            <th><span><?php esc_html_e('PHP Version', 'chakavak'); ?></span></th>
                            <td>
                                <?php
                                if (version_compare(phpversion(), $php_requirements, '<')) {
                                    echo '<p class="message-info-error">' . esc_html__('Value: ', 'chakavak') . esc_html(phpversion()) . '.' . esc_html__('We recommend the following minimum PHP version:', 'chakavak') . ' ' . esc_html($php_requirements) . '</p>';
                                } else {
                                    echo '<strong>' . esc_html__('Value: ', 'chakavak') . esc_html(phpversion()) . '</strong>';
                                }
                                ?>
                            </td>
                        </tr>

                        <tr>
                            <th><span><?php esc_html_e('Maximum upload size', 'chakavak'); ?></span></th>
                            <td>
                                <strong><?php echo esc_html__('Value: ', 'chakavak') . esc_html(size_format(chakavak_let_to_num((ini_get('post_max_size'))))); ?></strong>
                                <?php
                                echo '<p class="note"><span>' . esc_html__('You cannot upload images, templates, and plugins that are larger than this size.', 'chakavak') . '</span>';
                                echo ' <a class="d-block px-6" target="_blank" href="http://www.wpbeginner.com/wp-tutorials/how-to-increase-the-maximum-file-upload-size-in-wordpress/">' . esc_html__('Guide to changing upload size', 'chakavak') . '</a></p>';
                                ?>
                            </td>
                        </tr>

                        <tr>
                            <th><span><?php esc_html_e('Maximum execution time', 'chakavak'); ?></span></th>
                            <td>
                                <?php
                                if ($max_execution_time_requirements > ini_get('max_execution_time')) {
                                    echo '<p class="message-info-error">' . esc_html_e('Value: ', 'chakavak') . esc_html(ini_get('max_execution_time')) . '.' . esc_html__(' maximum runtime we recommend:', 'chakavak') . ' ' . esc_html($max_execution_time_requirements) . '</p>';
                                    echo '<p class="note"><a class="d-block px-6" target="_blank" href="https://code.tutsplus.com/tutorials/how-to-increase-max_execution_time-in-php--cms-37017">' . esc_html__('How to increase maximum execution time in php', 'chakavak') . '</a></p>';
                                } else {
                                    echo '<strong>' . esc_html__('Value: ', 'chakavak') . esc_html(ini_get('max_execution_time')) . '</strong>';
                                }
                                ?>
                            </td>
                        </tr>

                        <tr>
                            <th><span><?php esc_html_e('Maximum input time', 'chakavak'); ?></span></th>
                            <td>
                                <?php
                                if ($max_input_time_requirements > ini_get('max_input_time')) {
                                    echo '<p class="message-info-error"><strong>' . esc_html__('Value: ', 'chakavak') . esc_html(ini_get('max_input_time')) . '.' . esc_html__(' maximum input time we recommend:', 'chakavak') . ' ' . esc_html($max_input_time_requirements) . '</strong></p>';
                                    echo '<p class="note"><a class="d-block px-6" target="_blank" href="http://www.wpbeginner.com/wp-tutorials/how-to-increase-the-maximum-file-upload-size-in-wordpress/">' . esc_html__('How to increase maximum input time in php', 'chakavak') . '</a></p>';
                                } else {
                                    echo '<strong>' . esc_html__('Value: ', 'chakavak') . esc_html(ini_get('max_input_time')) . '</strong>';
                                }
                                ?>
                            </td>
                        </tr>

                        <tr>
                            <th><span><?php esc_html_e('Maximum input Variables', 'chakavak'); ?></span></th>
                            <td>
                                <?php
                                if ($max_input_vars_requirements > ini_get('max_input_vars')) {
                                    echo '<p class="message-info-error">' . esc_html__('Value: ', 'chakavak') . esc_html(ini_get('max_input_vars'));
                                    echo '<br />' . esc_html__(' Minimum maximum input variables we recommend:', 'chakavak') . ' ' . esc_html($max_input_vars_requirements) . '</p>';
                                    echo '<p class="note"><a class="d-block px-6" target="_blank" href="http://www.wpbeginner.com/wp-tutorials/how-to-increase-the-maximum-file-upload-size-in-wordpress/">' . esc_html__('How to increase maximum input variables in php', 'chakavak') . '</a></p>';
                                } else {
                                    echo '<strong>' . esc_html_e('Value: ', 'chakavak') . esc_html(ini_get('max_input_vars')) . '</strong>';
                                }
                                ?>
                            </td>
                        </tr>

                        <tr>
                            <th><span><?php esc_html_e('MySql Version', 'chakavak'); ?></span></th>
                            <td><strong><?php echo esc_html__('Value: ', 'chakavak'); ?><?php echo(!empty($wpdb->is_mysql) ? $wpdb->db_version() : ''); ?></strong></td>
                        </tr>

                        <tr>
                            <th><span><?php esc_html_e('Maximum upload size in Wordpress', 'chakavak'); ?></span></th>
                            <td>
                                <?php
                                if ($max_upload_size > wp_max_upload_size()) {
                                    echo '<p class="message-info-error">' . esc_html_e('Value: ', 'chakavak') . esc_html(size_format(wp_max_upload_size())) . '.' . esc_html__('Minimum recommended amount: 128 MB.', 'chakavak') . '</p>';
                                    echo '<p class="note"><a class="d-block px-6" target="_blank" href="http://www.wpbeginner.com/wp-tutorials/how-to-increase-the-maximum-file-upload-size-in-wordpress/">' . esc_html__('How to increase Maximum upload size in Wordpress in php', 'chakavak') . '</a>';
                                } else {
                                    echo '<strong>' . esc_html_e('Value: ', 'chakavak') . esc_html(size_format(wp_max_upload_size())) . '</strong>';
                                }
                                ?>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>

        </div>
    </div>
</div>