<?php
defined('ABSPATH') or exit;
add_action('admin_menu', 'chakavak_panel_register_menu');
function chakavak_panel_register_menu()
{
    $flatsome_icon = get_template_directory_uri() . '/inc/backend/assets/images/chakavak-icon.png';
    add_menu_page(
        __('Welcome to Chakavak', 'chakavak'),
        __('chakavak', 'chakavak'),
        'manage_options',
        'chakavak-panel',
        'chakavak_panel_welcome',
        $flatsome_icon,
        '2'
    );

    add_submenu_page(
        'chakavak-panel',
        __('Help & Guides', 'chakavak'),
        __('Help & Guides', 'chakavak'),
        'manage_options',
        'chakavak-panel-support',
        'chakavak_panel_support'
    );

    add_submenu_page(
        'chakavak-panel',
        __('Status', 'chakavak'),
        __('Status', 'chakavak'),
        'manage_options',
        'chakavak-panel-status',
        'chakavak_panel_status'
    );

    add_submenu_page(
        'chakavak-panel',
        '',
        __('Template builder', 'chakavak'),
        'manage_options',
        'edit.php?post_type=chk_builders'
    );

    add_submenu_page(
        'chakavak-panel',
        '',
        __('Import Demoes', 'chakavak'),
        'manage_options',
        'themes.php?page=one-click-demo-import'
    );

    add_submenu_page(
        'chakavak-panel',
        __('Change log ', 'chakavak'),
        __('Change log', 'chakavak'),
        'manage_options',
        'chakavak-panel-changelog',
        'chakavak_panel_changelog'
    );
}

function chakavak_panel_style()
{
    $uri = get_template_directory_uri();
    $theme = wp_get_theme(get_template());
    $version = $theme->get('Version');
    wp_enqueue_style('chakavak-panel-style', $uri . '/inc/backend/assets/css/panel.min.css', array(), $version);
}

add_action('admin_enqueue_scripts', 'chakavak_panel_style');


/**
 * The welcome screen
 */
function chakavak_panel_welcome()
{
    ?>
    <div class="chk-panel">
        <div class="chk-panel__wrap chk-welcome__wrap">
            <?php require get_template_directory() . '/inc/backend/panel/sections/top.php'; ?>
            <?php require get_template_directory() . '/inc/backend/panel/sections/tab-welcome.php'; ?>
        </div>
    </div>
    <?php
}

function chakavak_panel_support()
{
    ?>
    <div class="chk-panel">
        <div class="chk-panel__wrap chk-support__wrap">
            <?php require get_template_directory() . '/inc/backend/panel/sections/top.php'; ?>
            <?php require get_template_directory() . '/inc/backend/panel/sections/tab-support.php'; ?>
        </div>
    </div>
    <?php
}

function chakavak_panel_status()
{
    ?>
    <div class="chk-panel">
        <div class="chk-panel__wrap chk-status__wrap">
            <?php require get_template_directory() . '/inc/backend/panel/sections/top.php'; ?>
            <?php require get_template_directory() . '/inc/backend/panel/sections/tab-status.php'; ?>
        </div>
    </div>
    <?php
}

function chakavak_panel_changelog()
{
    ?>
    <div class="chk-panel">
        <div class="chk-panel__wrap chk-changelog__wrap">
            <?php require get_template_directory() . '/inc/backend/panel/sections/top.php'; ?>
            <?php require get_template_directory() . '/inc/backend/panel/sections/tab-changelog.php'; ?>
        </div>
    </div>
    <?php
}
