<?php
defined('ABSPATH') or exit;
$chakavakThemeOptions = 'chakavak_theme_options';

if (class_exists('CSF')) {
    /*
	* Set a unique slug-like ID
	*/
    CSF::createOptions($chakavakThemeOptions, array(
        'menu_title' => esc_html__('Theme options', 'chakavak'),
        'menu_slug' => 'chakavak-theme-options',
        'enqueue_webfont' => true,
        'show_in_customizer' => false,
        'show_search' => false,
        'menu_type' => 'submenu',
        'menu_parent' => 'chakavak-panel',
        //'menu_position' => 50,
        'show_bar_menu' => false,
        'theme' => 'light',

        'framework_title' => wp_kses(
            sprintf(__("Chakavak Options <small>Version %s</small>", 'chakavak'), CHAKAVAK_VER),
            array('small' => array())
        ),
        'footer_text' => esc_html__('Chakavak theme options ', 'chakavak'),

    ));

    require_once CHAKAVAK_BACKEND_DIR . 'options-and-metabox/theme-options/options-header.php';
    require_once CHAKAVAK_BACKEND_DIR . 'options-and-metabox/theme-options/options-pheader.php';
    require_once CHAKAVAK_BACKEND_DIR . 'options-and-metabox/theme-options/options-footer.php';
    require_once CHAKAVAK_BACKEND_DIR . 'options-and-metabox/theme-options/options-blog.php';
    require_once CHAKAVAK_BACKEND_DIR . 'options-and-metabox/theme-options/options-portfolio.php';
    require_once CHAKAVAK_BACKEND_DIR . 'options-and-metabox/theme-options/options-other.php';
    require_once CHAKAVAK_BACKEND_DIR . 'options-and-metabox/theme-options/options-loader.php';
    require_once CHAKAVAK_BACKEND_DIR . 'options-and-metabox/theme-options/options-color-scheme.php';
    require_once CHAKAVAK_BACKEND_DIR . 'options-and-metabox/theme-options/options-typography.php';
    require_once CHAKAVAK_BACKEND_DIR . 'options-and-metabox/theme-options/options-404.php';
    require_once CHAKAVAK_BACKEND_DIR . 'options-and-metabox/theme-options/options-maintenance.php';
    require_once CHAKAVAK_BACKEND_DIR . 'options-and-metabox/theme-options/options-scripts.php';

    // Backup section
    CSF::createSection($chakavakThemeOptions, array(
        'title' => esc_html__('Backup Export', 'chakavak'),
        'id' => 'backup_options',
        'icon' => 'fa fa-window-restore',
        'fields' => array(
            array(
                'type' => 'backup',
            ),
        ),
    ));
}
