<?php
if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}
if (class_exists('CSF')) {
    $prefix = 'chakavak';
    CSF::createSection($chakavakThemeOptions, [
        'title' => esc_html__('Portfolio', 'chakavak'),
        'id' => 'portfolio_opts',
        'icon' => 'ai-portfolio',
    ]);


    /*
     * Portfolio Archive
     */
    CSF::createSection($chakavakThemeOptions, [
        'parent' => 'portfolio_opts',
        'title' => esc_html__('Archive', 'chakavak'),
        'fields' => [

            [
                'id' => 'portfolio_active',
                'type' => 'switcher',
                'default' => true,
                'title' => esc_html__('Portfolio', 'chakavak'),
                'desc' => esc_html__('Enable/disable the portfolio on your website.', 'chakavak'),
            ],


            [
                'id' => 'portfolio_layout',
                'type' => 'image_select',
                'title' => esc_html__('Portfolio Layout', 'chakavak'),
                'options' => [
                    'full-content' => CHAKAVAK_BACKEND_ASSETS . 'images/full-width.png',
                    'left-sidebar' => CHAKAVAK_BACKEND_ASSETS . 'images/left-sidebar.png',
                    'right-sidebar' => CHAKAVAK_BACKEND_ASSETS . 'images/right-sidebar.png',
                ],
                'default' => 'full-content',
            ],

            [
                'id' => 'portfolio_archive',
                'type' => 'select',
                'title' => esc_html__('Main Archive', 'chakavak'),
                'desc' => esc_html__('The settings in this section apply when you click on the main portfolio archive via the Breadcrumbs.', 'chakavak'),
                'options' => [
                    'archive_default' => esc_attr__('Archive page default', 'chakavak'),
                    'archive_custom' => esc_attr__('Archive page custom', 'chakavak'),
                ],
                'default' => 'archive_default',
            ],


            [
                'id' => 'portfolio_columns_desktop',
                'type' => 'select',
                'title' => esc_html__('Columns in desktop', 'chakavak'),
                'default' => '3',
                'subtitle' => esc_html__('Choose the default columns on the Desktop for the archive page.', 'chakavak'),
                'options' => [
                    '1' => esc_attr__('1 Columns', 'chakavak'),
                    '2' => esc_attr__('2 Columns', 'chakavak'),
                    '3' => esc_attr__('3 Columns', 'chakavak'),
                    '4' => esc_attr__('4 Columns', 'chakavak'),
                ],
            ],

            [
                'id' => 'portfolio_columns_tablet',
                'type' => 'select',
                'title' => esc_html__('Columns in tablet', 'chakavak'),
                'default' => '2',
                'subtitle' => esc_html__('Choose the default columns on the tablet for the archive page.', 'chakavak'),
                'options' => [
                    '1' => esc_attr__('1 Columns', 'chakavak'),
                    '2' => esc_attr__('2 Columns', 'chakavak'),
                    '3' => esc_attr__('3 Columns', 'chakavak'),
                ],
            ],

            [
                'id' => 'portfolio_columns_mobile',
                'type' => 'select',
                'title' => esc_html__('Columns in mobile', 'chakavak'),
                'default' => '1',
                'subtitle' => esc_html__('Choose the default columns on the mobile for the archive page.', 'chakavak'),
                'options' => [
                    '1' => esc_attr__('1 Columns', 'chakavak'),
                    '2' => esc_attr__('2 Columns', 'chakavak'),
                ],
            ],

            [
                'id' => 'portfolio_style',
                'type' => 'select',
                'title' => esc_html__('Portfolio Style', 'chakavak'),
                'default' => 'grid',
                'options' => [
                    'grid' => esc_attr__('Grid Normal', 'chakavak'),
                    'masonry' => esc_attr__('Grid Masonry', 'chakavak'),
                ],
            ],

            [
                'id' => 'archive_page_custom',
                'type' => 'select',
                'title' => esc_html__('Select Page', 'chakavak'),
                'desc' => esc_attr__('Choose a custom page for archive portfolio page.', 'chakavak'),
                'options' => 'pages',
                'query_args' => [
                    'posts_per_page' => -1 // for get all pages (also it's same for posts).
                ],
                'dependency' => ['portfolio_archive', '==', 'archive_custom'],
            ],

            [
                'id' => 'portfolio_posts_per_page',
                'type' => 'number',
                'title' => esc_attr__('Posts per page', 'chakavak'),
                'default' => '6',
            ],

            [
                'id' => 'archive_portfolio_desc',
                'type' => 'select',
                'title' => esc_html__('Archive description position ', 'chakavak'),
                'options' => [
                    'top-desc' => esc_html__('Top of the page ', 'chakavak'),
                    'bottom-desc' => esc_html__('Bottom of the page ', 'chakavak'),
                ],
                'default' => 'bottom-desc',
            ],

            [
                'type' => 'subheading',
                'content' => esc_html__('Portfolio Card', 'chakavak'),
            ],

            [
                'id' => 'portfolio_card_title_tag',
                'type' => 'select',
                'title' => esc_html__('Title Tag', 'chakavak'),
                'subtitle' => esc_html__('Select Title HTML Tag', 'chakavak'),
                'placeholder' => esc_html__('Select an option', 'chakavak'),
                'options' => [
                    'h1' => esc_html__('Tag H1', 'chakavak'),
                    'h2' => esc_html__('Tag H2', 'chakavak'),
                    'h3' => esc_html__('Tag H3', 'chakavak'),
                    'h4' => esc_html__('Tag H4', 'chakavak'),
                    'h5' => esc_html__('Tag H5', 'chakavak'),
                    'strong' => esc_html__('Tag strong', 'chakavak'),
                    'span' => esc_html__('Tag span', 'chakavak'),
                ],
                'default' => 'h2',
            ],

            [
                'id' => 'portfolio_sw_overly',
                'type' => 'switcher',
                'default' => true,
                'title' => esc_html__('Show Overlay on image', 'chakavak'),
            ],

            [
                'id' => 'portfolio_title_inline',
                'type' => 'switcher',
                'default' => true,
                'title' => esc_html__('Single line title', 'chakavak'),
            ],

            [
                'id' => 'portfolio_sw_cat',
                'type' => 'switcher',
                'default' => true,
                'title' => esc_html__('Show Category', 'chakavak'),
            ],
        ]
    ]);

    /*
    * Single Page
    */
    CSF::createSection($chakavakThemeOptions, [
        'parent' => 'portfolio_opts',
        'title' => esc_html__('Single Portfolio', 'chakavak'),
        'fields' => [

            [
                'id' => 'portfolio_details_title_tag',
                'type' => 'select',
                'title' => esc_html__('Details title Tag', 'chakavak'),
                'subtitle' => esc_html__('Select Title HTML Tag', 'chakavak'),
                'placeholder' => esc_html__('Select an option', 'chakavak'),
                'options' => chakavak_heading(),
                'default' => 'span',
            ],

            [
                'id' => 'portfolio_details_title',
                'type' => 'text',
                'title' => esc_attr__('Title details', 'chakavak'),
                'default' => esc_attr__('Portfolio details', 'chakavak'),
            ],

            [
                'id' => 'portfolio_nav',
                'type' => 'switcher',
                'title' => esc_attr__('portfolios Previous and next', 'chakavak'),
                'default' => true,
            ],

            [
                'id' => 'portfolio_related',
                'type' => 'switcher',
                'title' => esc_attr__('Related Portfolio', 'chakavak'),
                'default' => true,
            ],

            [
                'id' => 'portfolio_related_title',
                'type' => 'text',
                'title' => esc_attr__('Title', 'chakavak'),
                'default' => esc_attr__('Related Portfolio', 'chakavak'),
                'dependency' => ['portfolio_related', '==', true,],
            ],

            [
                'id' => 'portfolio_related_items',
                'type' => 'fieldset',
                'title' => esc_html__('Number items per row', 'chakavak'),
                'dependency' => ['portfolio_related', '==', true,],
                'fields' => [
                    [
                        'id' => 'portfolio_related_items_desktop',
                        'type' => 'spinner',
                        'title' => esc_html__('In Desktop', 'chakavak'),
                        'subtitle' => esc_html__('From at least 1025px to up', 'chakavak'),
                        'min' => 1,
                        'max' => 6,
                        'step' => 1,
                    ],
                    [
                        'id' => 'portfolio_related_items_tablet',
                        'type' => 'spinner',
                        'title' => esc_html__('In Tablet', 'chakavak'),
                        'subtitle' => esc_html__('From at least 768px to 1024px', 'chakavak'),
                        'min' => 1,
                        'max' => 4,
                        'step' => 1,
                    ],
                    [
                        'id' => 'portfolio_related_items_mobile',
                        'type' => 'spinner',
                        'title' => esc_html__('In Mobile', 'chakavak'),
                        'subtitle' => esc_html__('From at least 576px to 767px', 'chakavak'),
                        'min' => 1,
                        'max' => 3,
                        'step' => 1,
                    ],
                ]
            ],

            [
                'id' => 'portfolio_comments',
                'type' => 'switcher',
                'title' => esc_attr__('Enable Comments', 'chakavak'),
                'default' => true,
            ],
        ]
    ]);
}
