<?php
defined('ABSPATH') or exit;
if (class_exists('CSF')) {
    CSF::createSection($chakavakThemeOptions, [
        'id' => 'header_opts', // Set a unique slug-like ID
        'title' => esc_html__('Header Site', 'chakavak'),
        'icon' => 'ai-header',
        'fields' => [
            [
                'id' => 'header_layout',
                'type' => 'select',
                'title' => esc_attr__('Select Header Desktop', 'chakavak'),
                'desc' => esc_attr__('Choose the header on desktop.', 'chakavak'),
                'chosen' => true,
                'placeholder' => esc_attr__('Select Header', 'chakavak'),
                'options' => 'posts',
                'query_args' => [
                    'post_type' => 'chk_builders',
                    'posts_per_page' => -1
                ],
            ],
            [
                'id' => 'header_transparent',
                'title' => esc_html__('Header transparent ?', 'chakavak'),
                'type' => 'switcher',
                'default' => false,
            ],
            [
                'id' => 'header_mobile',
                'type' => 'select',
                'title' => esc_attr__('Select Header Mobile', 'chakavak'),
                'desc' => esc_attr__('Choose the header on mobile.', 'chakavak'),
                'chosen' => true,
                'placeholder' => esc_attr__('Select Header', 'chakavak'),
                'options' => 'posts',
                'query_args' => [
                    'post_type' => 'chk_builders',
                    'posts_per_page' => -1
                ],
            ],
            [
                'id' => 'is_sidepanel',
                'title' => esc_html__('Show side Panel?', 'chakavak'),
                'type' => 'switcher',
                'desc' => esc_attr__('It displays when the Side Panel item is placed in the header section.', 'chakavak'),
                'default' => false,
            ],
            [
                'id' => 'sidepanel_layout',
                'type' => 'select',
                'title' => esc_attr__('Select Side Panel', 'chakavak'),
                'desc' => esc_attr__('Choose the side panel on header.', 'chakavak'),
                'chosen' => true,
                'placeholder' => esc_attr__('Select a panel', 'chakavak'),
                'options' => 'posts',
                'query_args' => [
                    'post_type' => 'chk_builders',
                ],
                'dependency' => ['is_sidepanel', '==', 'true']
            ],
            [
                'id' => 'panel_left',
                'title' => esc_html__('Side Panel On Left', 'chakavak'),
                'type' => 'switcher',
                'default' => false,
                'dependency' => ['is_sidepanel', '==', 'true']
            ],
        ]
    ]);
}
