<?php
if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {

    CSF::createSection($chakavakThemeOptions, array(
        'id' => 'footer_opts', // Set a unique slug-like ID
        'title' => esc_html__('Footer Site', 'chakavak'),
        'icon' => 'ai-footer',
        'fields' => [
            [
                'id' => 'footer_layout',
                'type' => 'select',
                'title' => esc_attr__('Select Footer', 'chakavak'),
                'subtitle' => esc_attr__('Choose the Footer.', 'chakavak'),
                'chosen' => true,
                'placeholder' => esc_attr__('Select Footer', 'chakavak'),
                'options' => 'posts',
                'query_args' => [
                    'post_type' => 'chk_builders',
                    'posts_per_page' => -1
                ],
            ],
            //Back To top
            [
                'type' => 'subheading',
                'content' => esc_html__('Back To Top', 'chakavak'),
            ],
            [
                'id' => 'back_top',
                'type' => 'switcher',
                'title' => esc_html__('Back To Top?', 'chakavak'),
                'default' => true
            ],
            [
                'id' => 'back_top_color',
                'type' => 'color',
                'title' => esc_html__('Icon Color', 'chakavak'),
                'dependency' => [
                    'back_top', '==', 'true'
                ],
                'output' => '.chk-progress__wrap',
                'output_mode' => 'color',
            ],
            [
                'id' => 'back_top_bgcolor',
                'type' => 'color',
                'title' => esc_html__('Background Color', 'chakavak'),
                'dependency' => [
                    'back_top', '==', 'true'
                ],
                'output' => '.chk-progress__wrap',
                'output_mode' => 'background-color',
            ],

            [
                'id' => 'back_top_position',
                'type' => 'button_set',
                'title' => esc_html__('Button Position', 'chakavak'),
                'options' => [
                    'left-position' => __('Left', 'chakavak'),
                    'right-position' => __('Right', 'chakavak'),
                ],
                'default' => 'left-position',
                'dependency' => [
                    'back_top', '==', 'true'
                ],
            ],
        ]
    ));
}
