<?php
if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {
    CSF::createSection($chakavakThemeOptions, [
        'id' => 'color_scheme_opts', // Set a unique slug-like ID
        'title' => esc_html__('Color scheme', 'chakavak'),
        'icon' => 'ai-color',
        'fields' => [
            [
                'id' => 'primary_color',
                'type' => 'color',
                'title' => esc_html__('Primary color', 'chakavak'),
                'default' => '#1d4ed8',
            ],
            [
                'id' => 'secondary_color',
                'type' => 'color',
                'title' => esc_html__('Secondary color', 'chakavak'),
                'default' => '#02153f',
            ],
            [
                'id' => 'text_color',
                'type' => 'color',
                'title' => esc_html__('Text color', 'chakavak'),
                'default' => '#374151',
                'subtitle' => esc_html__('Only for default site text and has nothing to do with Elementor item color settings.', 'chakavak'),
            ],
            [
                'id' => 'heading_color',
                'type' => 'color',
                'title' => esc_html__('Heading color', 'chakavak'),
                'subtitle' => esc_html__('Only for default site text and has nothing to do with Elementor item color settings.', 'chakavak'),
                'default' => '#111827',
            ],
            [
                'id' => 'bg_body',
                'type' => 'color',
                'title' => esc_html__('Background color body', 'chakavak'),
                'default' => '#fefefe',
            ],
        ]
    ]);
}
