<?php
if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {
    CSF::createSection($chakavakThemeOptions, array(
        'id' => '404_opts', // Set a unique slug-like ID
        'title' => esc_html__('404 Page', 'chakavak'),
        'icon' => 'ai-404',
        'fields' => [
            [
                'id' => '404_page',
                'type' => 'select',
                'title' => esc_html__('404 page type?', 'chakavak'),
                'subtitle' => esc_html__('Choose your 404 page type.', 'chakavak'),
                'options' => [
                    '404_default' => esc_attr__('Default', 'chakavak'),
                    '404_custom' => esc_attr__('Page custom', 'chakavak'),
                ],
                'default' => '404_default',
            ],

            [
                'id' => '404_page_title',
                'type' => 'text',
                'title' => esc_html__('Main title', 'chakavak'),
                'default' => esc_html__('Sorry! Page Not Found!', 'chakavak'),
                'dependency' => ['404_page', '==', '404_default'],
            ],

            [
                'id' => '404_page_desc',
                'type' => 'textarea',
                'title' => esc_html__('Description', 'chakavak'),
                'default' => esc_html__('Oops! The page which you are looking for does not exist. Please return to the homepage.', 'chakavak'),
                'dependency' => ['404_page', '==', '404_default'],
            ],

            [
                'id' => '404_page_custom',
                'type' => 'select',
                'title' => esc_html__('Select Page', 'chakavak'),
                'desc' => esc_attr__('Choose a custom page for 404 page.', 'chakavak'),
                'options' => 'pages',
                'query_args' => [
                    'posts_per_page' => -1
                ],
                'dependency' => ['404_page', '==', '404_custom'],
            ],

        ]
    ));
}
