<?php
defined('ABSPATH') or exit;
if (class_exists('CSF')) {
    $prefix = 'chakavak';

    /*Page Site Options */
    $single_metabox = 'chakavak_single_meta';

    CSF::createMetabox($single_metabox, [
        'title' => esc_html__('FAQ Options', 'chakavak'),
        'post_type' => ['post'],
        'theme' => 'light',
        'show_restore' => true,
        'class' => 'chakavak-metabox-options',
    ]);

    //page options
    CSF::createSection($single_metabox, [
        'title' => esc_html__('FAQ', 'chakavak'),
        'icon' => 'ai-articles',
        'fields' => [
            [
                'id' => 'faq_switch',
                'type' => 'switcher',
                'title' => esc_html__('Enable FAQ', 'chakavak'),
                'default' => false,
            ],

            [
                'id' => 'faq_schema_switch',
                'type' => 'switcher',
                'title' => esc_html__('Enable Schema for FAQ', 'chakavak'),
                'default' => false,
                'dependency' => ['faq_switch', '==', 'true'],
            ],

            [
                'id'     => 'faq_items',
                'type'   => 'group',
                'title'  => esc_html__('FAQ', 'chakavak'),
                'dependency' => ['faq_switch', '==', 'true'],
                'button_title'    => esc_html__('Add New', 'chakavak'),
                'accordion_title' => esc_html__('FAQ New', 'chakavak'),
                'fields' => [
                    [
                        'id'    => 'question',
                        'type'  => 'textarea',
                        'title' => esc_html__('Question', 'chakavak'),
                    ],
                    [
                        'id'            => 'answer',
                        'type'          => 'wp_editor',
                        'title'         => esc_html__('answer', 'chakavak'),
                        'tinymce'       => true,
                        'quicktags'     => true,
                        'media_buttons' => false,
                        'height'        => '120px',
                    ]
                ]
            ]

        ],
    ]);
}
